/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PriorityValue;
import bibliothek.gui.dock.util.UIScheme;

public class UIPriorityValue<T>
extends PriorityValue<Value<T>> {
    public boolean set(Priority priority, T t, UIScheme<?, ?, ?> uIScheme) {
        T t2 = this.getValue();
        if (t == null) {
            this.set(priority, null);
        } else if (uIScheme == null) {
            this.set(priority, new DirectValue<T>(t));
        } else {
            this.set(priority, new SchemeValue<T>(t, uIScheme));
        }
        return t2 != this.getValue();
    }

    public UIScheme<?, ?, ?> getScheme(Priority priority) {
        Value value = (Value)this.get(priority);
        if (value instanceof SchemeValue) {
            return ((SchemeValue)value).scheme;
        }
        return null;
    }

    public boolean isAllScheme() {
        Priority[] priorityArray = Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Priority priority = priorityArray[n2];
            if (this.getScheme(priority) == null && this.get(priority) != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public T getValue() {
        Value value = (Value)this.get();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public T getValue(Priority priority) {
        Value value = (Value)this.get(priority);
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    private static class DirectValue<T>
    implements Value<T> {
        private T value;

        public DirectValue(T t) {
            this.value = t;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }

    private static class SchemeValue<T>
    implements Value<T> {
        private T value;
        private UIScheme<?, ?, ?> scheme;

        public SchemeValue(T t, UIScheme<?, ?, ?> uIScheme) {
            this.value = t;
            this.scheme = uIScheme;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }

    public static interface Value<T> {
        public T getValue();
    }
}

