/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UIValue;
import bibliothek.util.Path;
import java.util.HashMap;
import java.util.Map;

public class TypedUIProperties {
    private UIProperties<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> properties;
    private Map<String, Type<?>> types = new HashMap();
    private Map<UIBridge<?, ?>, ThemeBridge<?>> bridges = new HashMap();

    public TypedUIProperties(DockController dockController) {
        this.properties = new UIProperties(dockController);
    }

    public <T> void registerType(Type<T> type) {
        if (this.types.get(type.getKey()) != null) {
            throw new IllegalArgumentException("the key '" + type.getKey() + "' is already in use");
        }
        this.types.put(type.getKey(), type);
    }

    private <T> void check(Type<T> type) {
        if (this.types.get(type.getKey()) != type) {
            throw new IllegalArgumentException("type '" + type.getKey() + "=" + type + " is not registered");
        }
    }

    public void setScheme(Priority priority, UIScheme<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> uIScheme) {
        this.properties.setScheme(priority, uIScheme);
    }

    public UIScheme<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> getScheme(Priority priority) {
        return this.properties.getScheme(priority);
    }

    public <V> void add(String string, Path path, Type<V> type, UIValue<V> uIValue) {
        this.check(type);
        this.properties.add(type.getKey(string), type.getKind(path), uIValue);
    }

    public void remove(UIValue<?> uIValue) {
        this.properties.remove(uIValue);
    }

    public <V> void publish(Priority priority, Path path, Type<V> type, UIBridge<V, UIValue<V>> uIBridge) {
        this.check(type);
        path = type.getKind(path);
        ThemeBridge<Object> themeBridge = this.bridges.get(uIBridge);
        if (themeBridge == null) {
            themeBridge = new ThemeBridge<V>(type.getKey().length() + 1, uIBridge);
            this.bridges.put(uIBridge, themeBridge);
        }
        this.properties.publish(priority, path, themeBridge);
    }

    public <V> void unpublish(Priority priority, Path path, Type<V> type) {
        this.check(type);
        path = type.getKind(path);
        UIBridge<Object, UIValue<Object>> uIBridge = this.properties.getBridge(priority, path);
        if (uIBridge != null) {
            this.properties.unpublish(priority, path);
            ThemeBridge<?> themeBridge = this.bridges.get(uIBridge);
            if (themeBridge != null) {
                this.checkUsed(themeBridge);
            }
        }
    }

    public <V> void unpublish(Priority priority, UIBridge<V, UIValue<V>> uIBridge) {
        ThemeBridge<?> themeBridge = this.bridges.get(uIBridge);
        if (themeBridge != null) {
            this.properties.unpublish(priority, themeBridge);
            this.checkUsed(themeBridge);
        }
    }

    private void checkUsed(ThemeBridge<?> themeBridge) {
        if (!this.properties.isStored(themeBridge)) {
            this.bridges.remove(themeBridge.getDelegate());
        }
    }

    public <V> void put(Priority priority, String string, Type<V> type, V v) {
        this.check(type);
        string = type.getKey(string);
        this.properties.put(priority, string, v);
    }

    public <V> V get(String string, Type<V> type) {
        this.check(type);
        string = type.getKey(string);
        return (V)this.properties.get(string);
    }

    public void clear(Priority priority) {
        this.properties.clear(priority);
    }

    private static class ThemeBridge<V>
    implements UIBridge<V, UIValue<V>> {
        private int offset;
        private UIBridge<V, UIValue<V>> delegate;

        public ThemeBridge(int n, UIBridge<V, UIValue<V>> uIBridge) {
            this.offset = n;
            this.delegate = uIBridge;
        }

        public UIBridge<V, UIValue<V>> getDelegate() {
            return this.delegate;
        }

        @Override
        public void add(String string, UIValue<V> uIValue) {
            this.delegate.add(string.substring(this.offset), uIValue);
        }

        @Override
        public void remove(String string, UIValue<V> uIValue) {
            this.delegate.remove(string.substring(this.offset), uIValue);
        }

        @Override
        public void set(String string, V v, UIValue<V> uIValue) {
            this.delegate.set(string.substring(this.offset), v, uIValue);
        }
    }

    public static class Type<T> {
        private final String key;

        public Type(String string) {
            if (string == null) {
                throw new IllegalArgumentException("key must not be null");
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("key must contain at least one character");
            }
            if (string.contains(".")) {
                throw new IllegalArgumentException("key must not contain the character '.'");
            }
            if (!Path.isValidPath(string)) {
                throw new IllegalArgumentException("key not a valid path");
            }
            this.key = string;
        }

        public String getKey() {
            return this.key;
        }

        public String getKey(String string) {
            return String.valueOf(this.key) + "." + string;
        }

        public Path getKind(Path path) {
            return new Path(this.key).append(path);
        }
    }
}

