/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.TypedUIProperties;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.UISchemeListener;
import bibliothek.gui.dock.util.UIValue;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypedPropertyUIScheme
implements UIScheme<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> {
    private DockProperties properties;
    private Map<String, Link<?, ?>> links = new HashMap();
    private List<UISchemeListener<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>>> listeners = new ArrayList<UISchemeListener<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>>>();
    private int bound = 0;

    public TypedPropertyUIScheme(DockProperties dockProperties) {
        if (dockProperties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        this.properties = dockProperties;
    }

    public <V, A extends V> void link(PropertyKey<A> propertyKey, TypedUIProperties.Type<V> type, String string) {
        String string2 = type.getKey(string);
        Link<?, ?> link = this.links.get(string2);
        if (link != null) {
            link.setKey(propertyKey);
        } else {
            Link<V, A> link2 = new Link<V, A>(propertyKey, type, string);
            this.links.put(string2, link2);
            if (this.bound > 0) {
                link2.setProperties(this.properties);
            }
        }
    }

    public <V> void unlink(TypedUIProperties.Type<V> type, String string) {
        String string2 = type.getKey(string);
        Link<?, ?> link = this.links.remove(string2);
        if (link != null) {
            link.setProperties((DockProperties)null);
        }
    }

    @Override
    public void addListener(UISchemeListener<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> uISchemeListener) {
        this.listeners.add(uISchemeListener);
    }

    @Override
    public void removeListener(UISchemeListener<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> uISchemeListener) {
        this.listeners.remove(uISchemeListener);
    }

    protected void fire(UISchemeEvent<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> uISchemeEvent) {
        UISchemeListener[] uISchemeListenerArray;
        UISchemeListener[] uISchemeListenerArray2 = uISchemeListenerArray = this.listeners.toArray(new UISchemeListener[this.listeners.size()]);
        int n = uISchemeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            UISchemeListener uISchemeListener = uISchemeListenerArray2[n2];
            uISchemeListener.changed(uISchemeEvent);
            ++n2;
        }
    }

    @Override
    public UIBridge<Object, UIValue<Object>> getBridge(Path path, UIProperties<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> uIProperties) {
        return null;
    }

    @Override
    public Object getResource(String string, UIProperties<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> uIProperties) {
        Link<?, ?> link = this.links.get(string);
        if (link == null) {
            int n = 0;
            for (Map.Entry<String, Link<?, ?>> entry : this.links.entrySet()) {
                int n2;
                if (!string.startsWith(entry.getKey()) || (n2 = entry.getKey().length()) <= n) continue;
                n = n2;
                link = entry.getValue();
            }
        }
        if (link == null) {
            return null;
        }
        return link.getValue();
    }

    @Override
    public void install(UIProperties<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> uIProperties) {
        if (this.bound == 0) {
            for (Link<?, ?> link : this.links.values()) {
                link.setProperties((DockProperties)null);
            }
        }
        ++this.bound;
    }

    @Override
    public void uninstall(UIProperties<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> uIProperties) {
        --this.bound;
        if (this.bound == 0) {
            for (Link<?, ?> link : this.links.values()) {
                link.setProperties(this.properties);
            }
        }
    }

    private class Link<V, A extends V>
    extends PropertyValue<A> {
        private TypedUIProperties.Type<V> type;
        private String id;

        public Link(PropertyKey<A> propertyKey, TypedUIProperties.Type<V> type, String string) {
            super(propertyKey);
            this.type = type;
            this.id = string;
        }

        @Override
        protected void valueChanged(A a, A a2) {
            TypedPropertyUIScheme.this.fire(new UISchemeEvent<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>>(){

                @Override
                public Collection<Path> changedBridges(Set<Path> set) {
                    return Collections.emptyList();
                }

                @Override
                public Collection<String> changedResources(Set<String> set) {
                    if (set == null) {
                        return null;
                    }
                    String string = Link.this.type.getKey(Link.this.id);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String string2 : set) {
                        if (!string2.startsWith(string)) continue;
                        arrayList.add(string2);
                    }
                    return arrayList;
                }

                @Override
                public UIScheme<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> getScheme() {
                    return TypedPropertyUIScheme.this;
                }
            });
        }
    }
}

