/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.LayoutLocked;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class DockUtilities {
    private static boolean checkLayoutLock = true;

    public static void visit(Dockable dockable, DockVisitor dockVisitor) {
        DockUtilities.visitDockable(dockable, dockVisitor);
    }

    public static void visit(DockStation dockStation, DockVisitor dockVisitor) {
        Dockable dockable = dockStation.asDockable();
        if (dockable != null) {
            DockUtilities.visitDockable(dockable, dockVisitor);
        } else {
            DockUtilities.visitStation(dockStation, dockVisitor);
        }
    }

    public static void visit(DockElement dockElement, DockVisitor dockVisitor) {
        Dockable dockable = dockElement.asDockable();
        if (dockable != null) {
            DockUtilities.visitDockable(dockable, dockVisitor);
        } else {
            DockStation dockStation = dockElement.asDockStation();
            if (dockStation != null) {
                DockUtilities.visitStation(dockStation, dockVisitor);
            }
        }
    }

    private static void visitDockable(Dockable dockable, DockVisitor dockVisitor) {
        dockVisitor.handleDockable(dockable);
        DockStation dockStation = dockable.asDockStation();
        if (dockStation != null) {
            DockUtilities.visitStation(dockStation, dockVisitor);
        }
    }

    private static void visitStation(DockStation dockStation, DockVisitor dockVisitor) {
        dockVisitor.handleDockStation(dockStation);
        Dockable[] dockableArray = new Dockable[dockStation.getDockableCount()];
        int n = 0;
        while (n < dockableArray.length) {
            dockableArray[n] = dockStation.getDockable(n);
            ++n;
        }
        Dockable[] dockableArray2 = dockableArray;
        int n2 = dockableArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Dockable dockable = dockableArray2[n3];
            DockUtilities.visitDockable(dockable, dockVisitor);
            ++n3;
        }
    }

    public static List<Dockable> listDockables(final DockElement dockElement, final boolean bl) {
        final ArrayList<Dockable> arrayList = new ArrayList<Dockable>();
        DockUtilities.visit(dockElement, new DockVisitor(){

            @Override
            public void handleDockable(Dockable dockable) {
                if (bl || dockable != dockElement) {
                    arrayList.add(dockable);
                }
            }
        });
        return arrayList;
    }

    public static boolean isAncestor(DockElement dockElement, DockElement dockElement2) {
        if (dockElement == null) {
            throw new NullPointerException("ancestor must not be null");
        }
        if (dockElement2 == null) {
            throw new NullPointerException("child must not be null");
        }
        Dockable dockable = dockElement2.asDockable();
        DockStation dockStation = null;
        while (dockable != null) {
            if (dockElement == dockable) {
                return true;
            }
            dockStation = dockable.getDockParent();
            Dockable dockable2 = dockable = dockStation == null ? null : dockStation.asDockable();
        }
        return dockStation == dockElement;
    }

    public static boolean isAncestor(PerspectiveElement perspectiveElement, PerspectiveElement perspectiveElement2) {
        if (perspectiveElement == null) {
            throw new NullPointerException("ancestor must not be null");
        }
        if (perspectiveElement2 == null) {
            throw new NullPointerException("child must not be null");
        }
        PerspectiveDockable perspectiveDockable = perspectiveElement2.asDockable();
        PerspectiveStation perspectiveStation = null;
        while (perspectiveDockable != null) {
            if (perspectiveElement == perspectiveDockable) {
                return true;
            }
            perspectiveStation = perspectiveDockable.getParent();
            PerspectiveDockable perspectiveDockable2 = perspectiveDockable = perspectiveStation == null ? null : perspectiveStation.asDockable();
        }
        return perspectiveStation == perspectiveElement;
    }

    public static DockStation getRoot(DockElement dockElement) {
        Dockable dockable = dockElement.asDockable();
        if (dockable == null) {
            return dockElement.asDockStation();
        }
        DockStation dockStation = dockable.getDockParent();
        if (dockStation == null) {
            return dockElement.asDockStation();
        }
        while ((dockable = dockStation.asDockable()) != null && dockable.getDockParent() != null) {
            dockStation = dockable.getDockParent();
        }
        return dockStation;
    }

    public static Dockable getDirectChild(DockStation dockStation, Dockable dockable) {
        DockStation dockStation2 = dockable.getDockParent();
        while (dockStation2 != null) {
            if (dockStation2 == dockStation) {
                return dockable;
            }
            dockable = dockStation2.asDockable();
            DockStation dockStation3 = dockStation2 = dockable == null ? null : dockable.getDockParent();
        }
        return null;
    }

    public static DockableProperty append(DockableProperty dockableProperty, DockableProperty dockableProperty2) {
        if (dockableProperty == null) {
            return dockableProperty2;
        }
        dockableProperty = dockableProperty.copy();
        DockUtilities.getLastProperty(dockableProperty).setSuccessor(dockableProperty2);
        return dockableProperty;
    }

    public static DockableProperty getLastProperty(DockableProperty dockableProperty) {
        while (dockableProperty.getSuccessor() != null) {
            dockableProperty = dockableProperty.getSuccessor();
        }
        return dockableProperty;
    }

    public static DockableProperty getPropertyChain(Dockable dockable) {
        DockStation dockStation = DockUtilities.getRoot(dockable);
        if (dockStation == null || dockStation == dockable) {
            return null;
        }
        return DockUtilities.getPropertyChain(dockStation, dockable);
    }

    public static DockableProperty getPropertyChain(DockStation dockStation, Dockable dockable) {
        if (dockStation == dockable) {
            throw new IllegalArgumentException("ground and dockable are the same");
        }
        DockStation dockStation2 = dockable.getDockParent();
        DockableProperty dockableProperty = dockStation2.getDockableProperty(dockable, dockable);
        Dockable dockable2 = dockable;
        while (dockStation2 != dockStation) {
            dockable2 = dockStation2.asDockable();
            if (dockable2 == null) {
                throw new IllegalArgumentException("The chain is not complete");
            }
            dockStation2 = dockable2.getDockParent();
            if (dockStation2 == null) {
                throw new IllegalArgumentException("The chain is not complete");
            }
            DockableProperty dockableProperty2 = dockStation2.getDockableProperty(dockable2, dockable);
            dockableProperty2.setSuccessor(dockableProperty);
            dockableProperty = dockableProperty2;
        }
        return dockableProperty;
    }

    public static DockableProperty getPropertyChain(PerspectiveStation perspectiveStation, PerspectiveDockable perspectiveDockable) {
        if (perspectiveStation == perspectiveDockable) {
            throw new IllegalArgumentException("ground and dockable are the same");
        }
        PerspectiveStation perspectiveStation2 = perspectiveDockable.getParent();
        DockableProperty dockableProperty = perspectiveStation2.getDockableProperty(perspectiveDockable, perspectiveDockable);
        PerspectiveDockable perspectiveDockable2 = perspectiveDockable;
        while (perspectiveStation2 != perspectiveStation) {
            perspectiveDockable2 = perspectiveStation2.asDockable();
            if (perspectiveDockable2 == null) {
                throw new IllegalArgumentException("The chain is not complete");
            }
            perspectiveStation2 = perspectiveDockable2.getParent();
            if (perspectiveStation2 == null) {
                throw new IllegalArgumentException("The chain is not complete");
            }
            DockableProperty dockableProperty2 = perspectiveStation2.getDockableProperty(perspectiveDockable2, perspectiveDockable);
            dockableProperty2.setSuccessor(dockableProperty);
            dockableProperty = dockableProperty2;
        }
        return dockableProperty;
    }

    public static Component getShowingComponent(Dockable dockable) {
        Component component = dockable.getComponent();
        if (!component.isShowing()) {
            Object object;
            DockTitle[] dockTitleArray = dockable.listBoundTitles();
            int n = dockTitleArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = dockTitleArray[n2];
                component = object.getComponent();
                if (component.isShowing()) break;
                ++n2;
            }
            if (!component.isShowing() && (object = dockable.getController()) != null) {
                DockElementRepresentative[] dockElementRepresentativeArray = ((DockController)object).getRepresentatives(dockable);
                int n3 = dockElementRepresentativeArray.length;
                n = 0;
                while (n < n3) {
                    DockElementRepresentative dockElementRepresentative = dockElementRepresentativeArray[n];
                    if (dockElementRepresentative.getComponent().isShowing()) {
                        component = dockElementRepresentative.getComponent();
                        break;
                    }
                    ++n;
                }
            }
        }
        if (component.isShowing()) {
            return component;
        }
        return null;
    }

    public static void ensureTreeValidity(DockStation dockStation, Dockable dockable) {
        if (dockStation == null) {
            throw new NullPointerException("parent must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("child must not be null");
        }
        DockStation dockStation2 = dockable.getDockParent();
        if (dockable == dockStation) {
            throw new IllegalArgumentException("child and parent are the same");
        }
        if (DockUtilities.isAncestor(dockable, dockStation)) {
            throw new IllegalArgumentException("can't create a cycle");
        }
        if (dockStation2 != null) {
            if (dockStation2 != dockStation && !dockStation2.canDrag(dockable)) {
                throw new IllegalStateException("old parent of child does not want do release the child");
            }
            dockStation2.drag(dockable);
        }
    }

    public static void ensureTreeValidity(PerspectiveStation perspectiveStation, PerspectiveDockable perspectiveDockable) {
        if (perspectiveStation == null) {
            throw new NullPointerException("parent must not be null");
        }
        if (perspectiveDockable == null) {
            throw new NullPointerException("child must not be null");
        }
        PerspectiveStation perspectiveStation2 = perspectiveDockable.getParent();
        if (perspectiveDockable == perspectiveStation) {
            throw new IllegalArgumentException("child and parent are the same");
        }
        if (DockUtilities.isAncestor(perspectiveDockable, perspectiveStation)) {
            throw new IllegalArgumentException("can't create a cycle");
        }
        if (perspectiveStation2 != null && perspectiveStation2 != perspectiveStation) {
            perspectiveStation2.remove(perspectiveDockable);
        }
    }

    public static Icon disabledIcon(JComponent jComponent, Icon icon) {
        if (icon == null) {
            return null;
        }
        Icon icon2 = UIManager.getLookAndFeel().getDisabledIcon(jComponent, icon);
        if (icon2 != null) {
            return icon2;
        }
        if (jComponent != null) {
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            if (n > 0 && n2 > 0) {
                BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                icon.paintIcon(jComponent, graphics2D, 0, 0);
                graphics2D.dispose();
                icon = new ImageIcon(bufferedImage);
                icon2 = UIManager.getLookAndFeel().getDisabledIcon(jComponent, icon);
            }
        }
        if (icon2 != null) {
            return icon2;
        }
        return icon;
    }

    public static Image iconImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return null;
    }

    public static Map<String, Icon> loadIcons(String string, String string2, ClassLoader classLoader) {
        return DockUtilities.loadIcons(string, string2, null, classLoader);
    }

    public static Map<String, Icon> loadIcons(String string, String string2, Set<String> set, ClassLoader classLoader) {
        try {
            InputStream inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) {
                return new HashMap<String, Icon>();
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            int n = string.lastIndexOf(47);
            if (n > 0) {
                string2 = string2 == null ? string.substring(0, n + 1) : String.valueOf(string.substring(0, n + 1)) + string2;
            }
            HashMap<String, Icon> hashMap = new HashMap<String, Icon>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                URL uRL;
                String string3 = (String)entry.getKey();
                if (set != null && set.contains(string3)) continue;
                String string4 = (String)entry.getValue();
                if (string2 != null) {
                    string4 = String.valueOf(string2) + string4;
                }
                if ((uRL = classLoader.getResource(string4)) == null) {
                    System.err.println("Missing file: " + string4);
                    continue;
                }
                ImageIcon imageIcon = new ImageIcon(uRL);
                hashMap.put(string3, imageIcon);
            }
            return hashMap;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new HashMap<String, Icon>();
        }
    }

    public static Path[] mergePlaceholders(Path[] pathArray, Dockable dockable, PlaceholderStrategy placeholderStrategy) {
        Path[] pathArray2;
        if (dockable == null || placeholderStrategy == null) {
            return pathArray;
        }
        Path path = placeholderStrategy.getPlaceholderFor(dockable);
        if (path == null) {
            return pathArray;
        }
        if (pathArray == null) {
            return new Path[]{path};
        }
        Path[] pathArray3 = pathArray;
        int n = pathArray.length;
        int n2 = 0;
        while (n2 < n) {
            pathArray2 = pathArray3[n2];
            if (path.equals(pathArray2)) {
                return pathArray;
            }
            ++n2;
        }
        pathArray2 = new Path[pathArray.length + 1];
        System.arraycopy(pathArray, 0, pathArray2, 0, pathArray.length);
        pathArray2[pathArray.length] = path;
        return pathArray2;
    }

    public static boolean acceptable(DockStation dockStation, Dockable dockable) {
        if (!dockStation.accept(dockable)) {
            return false;
        }
        if (!dockable.accept(dockStation)) {
            return false;
        }
        DockController dockController = dockStation.getController();
        if (dockController == null) {
            dockController = dockable.getController();
        }
        if (dockController != null) {
            return dockController.getAcceptance().accept(dockStation, dockable);
        }
        return true;
    }

    public static boolean acceptable(DockStation dockStation, Dockable dockable, Dockable dockable2) {
        if (!dockable.accept(dockStation, dockable2)) {
            return false;
        }
        if (!dockable2.accept(dockStation)) {
            return false;
        }
        DockController dockController = dockStation.getController();
        if (dockController == null) {
            dockController = dockable.getController();
        }
        if (dockController == null) {
            dockController = dockable2.getController();
        }
        if (dockController != null) {
            return dockController.getAcceptance().accept(dockStation, dockable, dockable2);
        }
        return true;
    }

    public static void disableCheckLayoutLocked() {
        checkLayoutLock = false;
    }

    public static void checkLayoutLocked() {
        if (checkLayoutLock) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            HashSet hashSet = new HashSet();
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[n2];
                try {
                    Class<?> clazz = Class.forName(stackTraceElement.getClassName());
                    if (DockUtilities.checkLayoutLocked(clazz, hashSet)) {
                        return;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (SecurityException securityException) {
                }
                catch (RuntimeException runtimeException) {
                }
                catch (Error error) {}
                ++n2;
            }
        }
    }

    private static boolean checkLayoutLocked(Class<?> clazz, Set<Class<?>> set) {
        if (clazz != null && set.add(clazz)) {
            LayoutLocked layoutLocked = clazz.getAnnotation(LayoutLocked.class);
            if (layoutLocked != null) {
                if (layoutLocked.locked()) {
                    System.err.println("Warning: layout should not be modified by subclasses of " + clazz.getName());
                    System.err.println(" This is only an information, not an exception. If your code is actually safe you can:");
                    System.err.println(" - disabled the warning by calling DockUtilities.disableCheckLayoutLocked() )");
                    System.err.println(" - mark your code as safe by setting the annotation 'LayoutLocked'");
                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                    int n = stackTraceElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                        System.err.println(stackTraceElement);
                        ++n2;
                    }
                }
                return true;
            }
            boolean bl = DockUtilities.checkLayoutLocked(clazz.getSuperclass(), set);
            if (bl) {
                return bl;
            }
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n3 = 0;
            while (n3 < n) {
                Class<?> clazz2 = classArray[n3];
                bl = DockUtilities.checkLayoutLocked(clazz2, set);
                if (bl) {
                    return bl;
                }
                ++n3;
            }
        }
        return false;
    }

    public static abstract class DockVisitor {
        public void handleDockable(Dockable dockable) {
        }

        public void handleDockStation(DockStation dockStation) {
        }
    }
}

