/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.DockPropertyListener;
import bibliothek.gui.dock.util.NullPriorityValue;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DockProperties {
    private Map<PropertyKey<?>, Entry<?>> map = new HashMap();
    private DockController controller;

    public DockProperties(DockController dockController) {
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
    }

    public DockController getController() {
        return this.controller;
    }

    public <A> void set(PropertyKey<A> propertyKey, A a) {
        this.set(propertyKey, a, Priority.CLIENT);
    }

    public <A> void set(PropertyKey<A> propertyKey, A a, Priority priority) {
        Entry<A> entry = this.getEntry(propertyKey, true);
        entry.setValue(a, priority);
        this.check(entry);
    }

    public <A> void finalize(PropertyKey<A> propertyKey) {
        Entry<A> entry = this.getEntry(propertyKey, true);
        entry.lock();
    }

    public <A> void setOrRemove(PropertyKey<A> propertyKey, A a, Priority priority) {
        if (a == null) {
            this.unset(propertyKey, priority);
        } else {
            this.set(propertyKey, a, priority);
        }
    }

    public void unset(PropertyKey<?> propertyKey) {
        this.unset(propertyKey, Priority.CLIENT);
    }

    public void unset(PropertyKey<?> propertyKey, Priority priority) {
        Entry<?> entry = this.getEntry(propertyKey, true);
        entry.unsetValue(priority);
        this.check(entry);
    }

    public <A> A get(PropertyKey<A> propertyKey) {
        Entry<A> entry = this.getEntry(propertyKey, true);
        return entry.getValue();
    }

    public <A> A get(PropertyKey<A> propertyKey, Priority priority) {
        Entry<A> entry = this.getEntry(propertyKey, false);
        if (entry == null) {
            return null;
        }
        return entry.getValue(priority);
    }

    public <A> boolean isSet(PropertyKey<A> propertyKey, Priority priority) {
        Entry<A> entry = this.getEntry(propertyKey, false);
        if (entry == null) {
            return false;
        }
        return ((Entry)entry).value.isSet(priority);
    }

    public <A> boolean isSet(PropertyKey<A> propertyKey) {
        Entry<A> entry = this.getEntry(propertyKey, false);
        if (entry == null) {
            return false;
        }
        return ((Entry)entry).value.isSomethingSet();
    }

    public <A> void addListener(PropertyKey<A> propertyKey, DockPropertyListener<A> dockPropertyListener) {
        if (dockPropertyListener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        this.getEntry(propertyKey, true).addListener(dockPropertyListener);
    }

    public <A> void removeListener(PropertyKey<A> propertyKey, DockPropertyListener<A> dockPropertyListener) {
        Entry<A> entry = this.getEntry(propertyKey, false);
        if (entry != null) {
            entry.removeListener(dockPropertyListener);
            this.check(entry);
        }
    }

    private <A> Entry<A> getEntry(PropertyKey<A> propertyKey, boolean bl) {
        Entry<Object> entry = this.map.get(propertyKey);
        if (entry == null && bl) {
            entry = new Entry<A>(propertyKey);
            this.map.put(propertyKey, entry);
        }
        return entry;
    }

    private void check(Entry<?> entry) {
        if (entry.removeable()) {
            this.map.remove(entry.getKey());
        }
    }

    private class Entry<A> {
        private PropertyKey<A> key;
        private List<DockPropertyListener<A>> listeners = new ArrayList<DockPropertyListener<A>>();
        private NullPriorityValue<A> value = new NullPriorityValue();
        private A defaultValue;
        private boolean defaultValueSet = false;
        private boolean locked = false;

        public Entry(PropertyKey<A> propertyKey) {
            this.key = propertyKey;
        }

        public void lock() {
            this.locked = true;
        }

        public void setValue(A a, Priority priority) {
            if (this.locked) {
                throw new IllegalStateException("this entry is immutable");
            }
            A a2 = this.getValue();
            this.value.set(priority, a);
            A a3 = this.getValue();
            if (a2 == null && a3 != null || a2 != null && a3 == null || a2 != null && !a2.equals(a3)) {
                DockPropertyListener[] dockPropertyListenerArray = this.listeners.toArray(new DockPropertyListener[this.listeners.size()]);
                int n = dockPropertyListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DockPropertyListener dockPropertyListener = dockPropertyListenerArray[n2];
                    dockPropertyListener.propertyChanged(DockProperties.this, this.key, a2, a3);
                    ++n2;
                }
            }
        }

        public void unsetValue(Priority priority) {
            if (this.locked) {
                throw new IllegalStateException("this entry is immutable");
            }
            A a = this.getValue();
            this.value.unset(priority);
            A a2 = this.getValue();
            if (a == null && a2 != null || a != null && a2 == null || a != null && !a.equals(a2)) {
                DockPropertyListener[] dockPropertyListenerArray = this.listeners.toArray(new DockPropertyListener[this.listeners.size()]);
                int n = dockPropertyListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DockPropertyListener dockPropertyListener = dockPropertyListenerArray[n2];
                    dockPropertyListener.propertyChanged(DockProperties.this, this.key, a, a2);
                    ++n2;
                }
            }
        }

        public A getValue() {
            A a = this.value.get();
            if (a == null && (!this.value.isSomethingSet() || this.key.isNullValueReplacedByDefault())) {
                return this.getDefault();
            }
            return a;
        }

        public A getValue(Priority priority) {
            return this.value.get(priority);
        }

        public A getDefault() {
            if (!this.defaultValueSet) {
                this.defaultValue = this.key.getDefault(DockProperties.this);
                this.defaultValueSet = true;
            }
            return this.defaultValue;
        }

        public PropertyKey<A> getKey() {
            return this.key;
        }

        public void addListener(DockPropertyListener<A> dockPropertyListener) {
            this.listeners.add(dockPropertyListener);
        }

        public void removeListener(DockPropertyListener<A> dockPropertyListener) {
            this.listeners.remove(dockPropertyListener);
        }

        public boolean removeable() {
            if (this.locked) {
                return false;
            }
            if (!this.listeners.isEmpty()) {
                return false;
            }
            return !this.defaultValueSet && !this.value.isSomethingSet();
        }
    }
}

