/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundAlgorithmListener;
import bibliothek.gui.dock.util.PaintableComponent;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public abstract class BackgroundPanel
extends JPanel
implements PaintableComponent {
    private BackgroundAlgorithm background;
    private Transparency transparency;
    private BackgroundAlgorithmListener listener = new BackgroundAlgorithmListener(){

        @Override
        public void transparencyChanged(BackgroundAlgorithm backgroundAlgorithm, Transparency transparency) {
            BackgroundPanel.this.configure(transparency);
        }
    };

    public BackgroundPanel(Transparency transparency) {
        this.setTransparency(transparency);
    }

    public BackgroundPanel(LayoutManager layoutManager, Transparency transparency) {
        super(layoutManager);
        this.setTransparency(transparency);
    }

    public void setBackground(BackgroundAlgorithm backgroundAlgorithm) {
        if (this.background != null) {
            this.background.removeListener(this.listener);
        }
        this.background = backgroundAlgorithm;
        if (backgroundAlgorithm != null) {
            backgroundAlgorithm.addListener(this.listener);
            this.configure(backgroundAlgorithm.getTransparency());
        }
    }

    protected abstract void configure(Transparency var1);

    public BackgroundAlgorithm getBackgroundAlgorithm() {
        return this.background;
    }

    @Override
    public void paint(Graphics graphics) {
        this.setupRenderingHints(graphics);
        if (this.background == null || this.background.getPaint() == null) {
            super.paint(graphics);
            this.paintOverlay(graphics);
        } else {
            this.background.paint(this, graphics);
        }
    }

    protected abstract void setupRenderingHints(Graphics var1);

    @Override
    protected void paintComponent(Graphics graphics) {
        this.paintBackground(graphics);
        this.paintForeground(graphics);
    }

    public void setTransparency(Transparency transparency) {
        this.transparency = transparency;
        this.setOpaque(transparency == Transparency.SOLID);
    }

    @Override
    public Transparency getTransparency() {
        return this.transparency;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void paintBackground(Graphics graphics) {
        if (this.transparency != Transparency.TRANSPARENT) {
            super.paintComponent(graphics);
        }
    }

    @Override
    public void paintForeground(Graphics graphics) {
    }

    @Override
    public void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
    }

    @Override
    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
    }

    @Override
    public void paintOverlay(Graphics graphics) {
    }
}

