/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.util.BackgroundAlgorithmListener;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.PaintableComponent;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public abstract class BackgroundAlgorithm
implements BackgroundComponent {
    private Path kind;
    private String id;
    private DockController controller;
    private BackgroundPaint paint;
    private List<BackgroundAlgorithmListener> listeners = new ArrayList<BackgroundAlgorithmListener>(2);
    private Transparency transparency = Transparency.DEFAULT;

    public BackgroundAlgorithm(Path path, String string) {
        this.kind = path;
        this.id = string;
    }

    public void addListener(BackgroundAlgorithmListener backgroundAlgorithmListener) {
        this.listeners.add(backgroundAlgorithmListener);
    }

    public void removeListener(BackgroundAlgorithmListener backgroundAlgorithmListener) {
        this.listeners.remove(backgroundAlgorithmListener);
    }

    public void setController(DockController dockController) {
        if (this.controller != null) {
            this.controller.getThemeManager().remove(this);
        }
        this.controller = dockController;
        if (this.controller != null) {
            this.controller.getThemeManager().add(this.id, this.kind, ThemeManager.BACKGROUND_PAINT_TYPE, this);
        } else {
            this.set(null);
        }
    }

    @Override
    public void repaint() {
        this.getComponent().repaint();
    }

    @Override
    public void set(BackgroundPaint backgroundPaint) {
        if (this.paint != null) {
            this.paint.uninstall(this);
        }
        this.paint = backgroundPaint;
        if (this.paint != null) {
            this.paint.install(this);
        }
    }

    @Override
    public void setTransparency(Transparency transparency) {
        if (transparency == null) {
            throw new IllegalArgumentException("transparency must not be null");
        }
        if (this.transparency != transparency) {
            this.transparency = transparency;
            BackgroundAlgorithmListener[] backgroundAlgorithmListenerArray = this.listeners.toArray(new BackgroundAlgorithmListener[this.listeners.size()]);
            int n = backgroundAlgorithmListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BackgroundAlgorithmListener backgroundAlgorithmListener = backgroundAlgorithmListenerArray[n2];
                backgroundAlgorithmListener.transparencyChanged(this, this.transparency);
                ++n2;
            }
        }
    }

    @Override
    public Transparency getTransparency() {
        return this.transparency;
    }

    public BackgroundPaint getPaint() {
        return this.paint;
    }

    public void paint(PaintableComponent paintableComponent, Graphics graphics) {
        if (this.paint == null) {
            paintableComponent.paintBackground(graphics);
            paintableComponent.paintForeground(graphics);
            paintableComponent.paintBorder(graphics);
            paintableComponent.paintChildren(graphics);
            paintableComponent.paintOverlay(graphics);
        } else {
            Paintable paintable = new Paintable(paintableComponent);
            paintable.paint(graphics);
        }
    }

    private class Paintable
    implements PaintableComponent {
        private PaintableComponent delegate;
        private boolean backgroundPainted = false;
        private boolean foregroundPainted = false;
        private boolean borderPainted = false;
        private boolean childrenPainted = false;
        private boolean overlayPainted = false;

        public Paintable(PaintableComponent paintableComponent) {
            this.delegate = paintableComponent;
        }

        @Override
        public Component getComponent() {
            return this.delegate.getComponent();
        }

        @Override
        public void paintBackground(Graphics graphics) {
            this.backgroundPainted = true;
            if (graphics != null) {
                this.delegate.paintBackground(graphics);
            }
        }

        @Override
        public void paintForeground(Graphics graphics) {
            this.foregroundPainted = true;
            if (graphics != null) {
                this.delegate.paintForeground(graphics);
            }
        }

        @Override
        public void paintBorder(Graphics graphics) {
            this.borderPainted = true;
            if (graphics != null) {
                this.delegate.paintBorder(graphics);
            }
        }

        @Override
        public void paintChildren(Graphics graphics) {
            this.childrenPainted = true;
            if (graphics != null) {
                this.delegate.paintChildren(graphics);
            }
        }

        @Override
        public void paintOverlay(Graphics graphics) {
            this.overlayPainted = true;
            if (graphics != null) {
                this.delegate.paintOverlay(graphics);
            }
        }

        @Override
        public Transparency getTransparency() {
            return this.delegate.getTransparency();
        }

        public void paint(Graphics graphics) {
            BackgroundAlgorithm.this.paint.paint(BackgroundAlgorithm.this, this, graphics);
            if (!this.backgroundPainted) {
                this.paintBackground(graphics);
            }
            if (!this.foregroundPainted) {
                this.paintForeground(graphics);
            }
            if (!this.borderPainted) {
                this.paintBorder(graphics);
            }
            if (!this.childrenPainted) {
                this.paintChildren(graphics);
            }
            if (!this.overlayPainted) {
                this.paintOverlay(graphics);
            }
        }
    }
}

