/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.WindowProviderListener;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractWindowProvider
implements WindowProvider {
    protected List<WindowProviderListener> listeners = new ArrayList<WindowProviderListener>();
    private Window window = null;
    private boolean windowShowing = false;
    private ComponentListener windowListener = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            AbstractWindowProvider.this.updateVisibility();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            AbstractWindowProvider.this.updateVisibility();
        }
    };

    protected void updateVisibility() {
        boolean bl;
        Window window = this.searchWindow();
        if (this.window != window) {
            if (this.listeners.size() > 0) {
                if (this.window != null) {
                    this.window.removeComponentListener(this.windowListener);
                }
                if (window != null) {
                    window.addComponentListener(this.windowListener);
                }
            }
            this.window = window;
        }
        if (this.windowShowing != (bl = this.isShowing())) {
            this.windowShowing = bl;
            this.fireVisibilityChanged(bl);
        }
    }

    protected void fireWindowChanged(Window window) {
        this.updateVisibility();
        WindowProviderListener[] windowProviderListenerArray = this.listeners();
        int n = windowProviderListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WindowProviderListener windowProviderListener = windowProviderListenerArray[n2];
            windowProviderListener.windowChanged(this, window);
            ++n2;
        }
    }

    protected void fireVisibilityChanged(boolean bl) {
        WindowProviderListener[] windowProviderListenerArray = this.listeners();
        int n = windowProviderListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WindowProviderListener windowProviderListener = windowProviderListenerArray[n2];
            windowProviderListener.visibilityChanged(this, bl);
            ++n2;
        }
    }

    protected WindowProviderListener[] listeners() {
        return this.listeners.toArray(new WindowProviderListener[this.listeners.size()]);
    }

    protected boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    @Override
    public void addWindowProviderListener(WindowProviderListener windowProviderListener) {
        if (windowProviderListener == null) {
            throw new IllegalArgumentException("null is not allowed as listener");
        }
        if (this.listeners.size() == 0) {
            this.updateVisibility();
            if (this.window != null) {
                this.window.addComponentListener(this.windowListener);
            }
        }
        this.listeners.add(windowProviderListener);
    }

    @Override
    public void removeWindowProviderListener(WindowProviderListener windowProviderListener) {
        this.listeners.remove(windowProviderListener);
        if (this.listeners.size() == 0 && this.window != null) {
            this.window.removeComponentListener(this.windowListener);
        }
    }

    @Override
    public boolean isShowing() {
        Window window = this.searchWindow();
        if (window == null) {
            return false;
        }
        return window.isShowing();
    }
}

