/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.PaintableComponent;
import java.awt.Component;
import java.awt.Graphics;

public abstract class AbstractPaintableComponent
implements PaintableComponent {
    private BackgroundComponent background;
    private Component component;
    private BackgroundPaint paint;
    private boolean backgroundPainted = false;
    private boolean foregroundPainted = false;
    private boolean borderPainted = false;
    private boolean childrenPainted = false;
    private boolean overlayPainted = false;

    public AbstractPaintableComponent(BackgroundComponent backgroundComponent, Component component, BackgroundPaint backgroundPaint) {
        if (component == null) {
            throw new IllegalArgumentException("component must not be null");
        }
        this.background = backgroundComponent;
        this.component = component;
        this.paint = backgroundPaint;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    public void paint(Graphics graphics) {
        this.backgroundPainted = false;
        this.foregroundPainted = false;
        if (this.paint != null && this.background != null) {
            this.paint.paint(this.background, this, graphics);
        }
        if (!this.backgroundPainted) {
            this.background(graphics);
        }
        if (!this.foregroundPainted) {
            this.foreground(graphics);
        }
        if (!this.borderPainted) {
            this.border(graphics);
        }
        if (!this.childrenPainted) {
            this.children(graphics);
        }
        if (!this.overlayPainted) {
            this.overlay(graphics);
        }
    }

    @Override
    public void paintBackground(Graphics graphics) {
        this.backgroundPainted = true;
        if (graphics != null) {
            this.background(graphics);
        }
    }

    @Override
    public void paintForeground(Graphics graphics) {
        this.foregroundPainted = true;
        if (graphics != null) {
            this.foreground(graphics);
        }
    }

    @Override
    public void paintBorder(Graphics graphics) {
        this.borderPainted = true;
        if (graphics != null) {
            this.border(graphics);
        }
    }

    @Override
    public void paintChildren(Graphics graphics) {
        this.childrenPainted = true;
        if (graphics != null) {
            this.children(graphics);
        }
    }

    @Override
    public void paintOverlay(Graphics graphics) {
        this.overlayPainted = true;
        if (graphics != null) {
            this.overlay(graphics);
        }
    }

    protected abstract void background(Graphics var1);

    protected abstract void foreground(Graphics var1);

    protected abstract void border(Graphics var1);

    protected abstract void children(Graphics var1);

    protected abstract void overlay(Graphics var1);
}

