/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.event.UIListener;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.util.Priority;
import java.util.ArrayList;
import java.util.List;

public class DockTitleVersion
implements DockTitleFactory {
    private DockTitleFactory[] factories = new DockTitleFactory[3];
    private String id;
    private DockController controller;
    private List<DockTitleRequest> requests = new ArrayList<DockTitleRequest>();
    private boolean onThemeChange = false;

    public DockTitleVersion(DockController dockController, String string) {
        if (dockController == null) {
            throw new NullPointerException("Controller must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("The ID must not be null");
        }
        this.controller = dockController;
        this.id = string;
        dockController.getThemeManager().addUIListener(new UIListener(){

            @Override
            public void updateUI(DockController dockController) {
            }

            @Override
            public void themeWillChange(DockController dockController, DockTheme dockTheme, DockTheme dockTheme2) {
                DockTitleVersion.this.onThemeChange = true;
            }

            @Override
            public void themeChanged(DockController dockController, DockTheme dockTheme, DockTheme dockTheme2) {
                DockTitleVersion.this.onThemeChange = false;
            }
        });
    }

    @Override
    public void install(DockTitleRequest dockTitleRequest) {
        if (dockTitleRequest == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        this.requests.add(dockTitleRequest);
        DockTitleFactory dockTitleFactory = this.getFactory();
        if (dockTitleFactory != null) {
            dockTitleFactory.install(dockTitleRequest);
        }
    }

    @Override
    public void uninstall(DockTitleRequest dockTitleRequest) {
        this.requests.remove(dockTitleRequest);
        DockTitleFactory dockTitleFactory = this.getFactory();
        if (dockTitleFactory != null) {
            dockTitleFactory.uninstall(dockTitleRequest);
        }
    }

    @Override
    public void request(DockTitleRequest dockTitleRequest) {
        DockTitleFactory dockTitleFactory = this.getFactory(Priority.CLIENT);
        if (dockTitleFactory != null) {
            dockTitleFactory.request(dockTitleRequest);
            return;
        }
        DockTitleFactory dockTitleFactory2 = this.getFactory();
        if (dockTitleFactory2 != null) {
            dockTitleFactory2.request(dockTitleRequest);
        }
    }

    public void request() {
        for (DockTitleRequest dockTitleRequest : this.requests) {
            dockTitleRequest.request();
        }
    }

    private int map(Priority priority) {
        switch (priority) {
            case CLIENT: {
                return 0;
            }
            case THEME: {
                return 1;
            }
        }
        return 2;
    }

    public DockTitleFactory getFactory() {
        int n = 0;
        while (n < this.factories.length) {
            if (this.factories[n] != null) {
                return this.factories[n];
            }
            ++n;
        }
        return null;
    }

    public void setFactory(DockTitleFactory dockTitleFactory, Priority priority) {
        DockTitleFactory dockTitleFactory2 = this.getFactory();
        this.factories[this.map((Priority)priority)] = dockTitleFactory;
        DockTitleFactory dockTitleFactory3 = this.getFactory();
        if (dockTitleFactory2 != dockTitleFactory3) {
            if (dockTitleFactory2 != null) {
                for (DockTitleRequest dockTitleRequest : this.requests) {
                    dockTitleFactory2.uninstall(dockTitleRequest);
                }
            }
            if (dockTitleFactory3 != null) {
                for (DockTitleRequest dockTitleRequest : this.requests) {
                    dockTitleFactory3.install(dockTitleRequest);
                    if (this.onThemeChange) continue;
                    dockTitleRequest.request();
                }
            }
        }
    }

    public DockTitleFactory getFactory(Priority priority) {
        return this.factories[this.map(priority)];
    }

    public boolean isSet(Priority priority) {
        return this.factories[this.map(priority)] != null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof DockTitleVersion && ((DockTitleVersion)object).id.equals(this.id);
    }

    public String getID() {
        return this.id;
    }

    public DockController getController() {
        return this.controller;
    }
}

