/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.ResourceRequest;

public abstract class DockTitleRequest
extends ResourceRequest<DockTitle> {
    private Dockable target;
    private DockStation parent;
    private DockTitleVersion version;
    private boolean installed = false;

    public DockTitleRequest(DockStation dockStation, Dockable dockable, DockTitleVersion dockTitleVersion) {
        if (dockable == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        if (dockTitleVersion == null) {
            throw new IllegalArgumentException("version must not be null");
        }
        this.target = dockable;
        this.parent = dockStation;
        this.version = dockTitleVersion;
    }

    @Override
    public void request() {
        super.request();
    }

    public void install() {
        if (!this.installed) {
            this.installed = true;
            this.version.install(this);
        }
    }

    public void uninstall() {
        if (this.installed) {
            this.installed = false;
            this.version.uninstall(this);
        }
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public Dockable getTarget() {
        return this.target;
    }

    public DockStation getParent() {
        return this.parent;
    }

    public DockTitleVersion getVersion() {
        return this.version;
    }

    @Override
    protected void executeRequestList() {
        this.requestDockTitle(this);
        if (this.isAnswered()) {
            return;
        }
        this.target.requestDockTitle(this);
        if (this.isAnswered()) {
            return;
        }
        if (this.parent != null) {
            this.parent.requestChildDockTitle(this);
            if (this.isAnswered()) {
                return;
            }
        }
        this.version.request(this);
    }

    public void requestDockTitle(DockTitleRequest dockTitleRequest) {
    }

    @Override
    public void answer(DockTitle dockTitle) {
        super.answer(dockTitle);
    }

    @Override
    protected void validate(DockTitle dockTitle) {
        if (dockTitle != null) {
            if (dockTitle.getDockable() != this.getTarget()) {
                throw new IllegalArgumentException("title.getDockable() does not return target");
            }
            if (dockTitle.getOrigin() != this.getVersion()) {
                throw new IllegalArgumentException("title.getOrigin() does not return version");
            }
        }
    }
}

