/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleBackgroundComponent;
import bibliothek.gui.dock.title.DockTitleEvent;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.title.OrientationToRotationStrategy;
import bibliothek.gui.dock.title.OrientationToRotationStrategyListener;
import bibliothek.gui.dock.title.TitleDockBorder;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.color.AbstractDockColor;
import bibliothek.gui.dock.util.render.DockRenderingHints;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public abstract class AbstractMultiDockTitle
extends ConfiguredBackgroundPanel
implements DockTitle {
    private static final Insets DEFAULT_INSETS_HORIZONTAL = new Insets(0, 1, 0, 1);
    private static final Insets DEFAULT_INSETS_VERTICAL = new Insets(1, 0, 1, 0);
    private Dockable dockable;
    private DockComponentRootHandler rootHandler;
    private OrientedLabel label = new OrientedLabel();
    private Listener listener = new Listener();
    private DockTitleVersion origin;
    private boolean active = false;
    private boolean bound = false;
    private DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;
    private Icon icon;
    private Icon disabledIcon;
    private int iconTextGap = 0;
    private List<AbstractDockColor> colors = new ArrayList<AbstractDockColor>();
    private Background background = new Background();
    private TitleBorder border;
    private boolean disabled = false;
    private List<MouseInputListener> mouseInputListeners = new ArrayList<MouseInputListener>();
    private PropertyValue<OrientationToRotationStrategy> orientationConverter = new PropertyValue<OrientationToRotationStrategy>(DockTitle.ORIENTATION_STRATEGY){

        @Override
        protected void valueChanged(OrientationToRotationStrategy orientationToRotationStrategy, OrientationToRotationStrategy orientationToRotationStrategy2) {
            if (orientationToRotationStrategy != null) {
                orientationToRotationStrategy.removeListener(AbstractMultiDockTitle.this.orientationListener);
                orientationToRotationStrategy.uninstall(AbstractMultiDockTitle.this);
            }
            if (orientationToRotationStrategy2 != null) {
                orientationToRotationStrategy2.install(AbstractMultiDockTitle.this);
                orientationToRotationStrategy2.addListener(AbstractMultiDockTitle.this.orientationListener);
            }
            AbstractMultiDockTitle.this.updateLabelRotation();
        }
    };
    private OrientationToRotationStrategyListener orientationListener = new OrientationToRotationStrategyListener(){

        @Override
        public void rotationChanged(Dockable dockable, DockTitle dockTitle) {
            if (!(dockTitle != AbstractMultiDockTitle.this && dockTitle != null || dockable != AbstractMultiDockTitle.this.dockable && dockable != null)) {
                AbstractMultiDockTitle.this.updateLabelRotation();
            }
        }
    };

    public AbstractMultiDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        super(Transparency.SOLID);
        this.init(dockable, dockTitleVersion);
    }

    protected AbstractMultiDockTitle() {
        super(Transparency.SOLID);
    }

    protected void init(Dockable dockable, DockTitleVersion dockTitleVersion) {
        this.dockable = dockable;
        this.origin = dockTitleVersion;
        this.label.setBackground(this.background);
        this.setBackground(this.background);
        this.setLayout(null);
        this.add(this.label);
        this.setActive(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component component) {
                return component != AbstractMultiDockTitle.this && super.accept(component);
            }
        });
        this.setOpaque(false);
        this.rootHandler = this.createRootHandler();
        this.rootHandler.addRoot(this.getComponent());
    }

    protected DockComponentRootHandler createRootHandler() {
        return new DockComponentRootHandler(this){

            @Override
            protected DockComponentRootHandler.TraverseResult shouldTraverse(Component component) {
                return DockComponentRootHandler.TraverseResult.INCLUDE_CHILDREN;
            }
        };
    }

    public void setIconTextGap(int n) {
        this.iconTextGap = n;
        this.revalidate();
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    protected void addColor(AbstractDockColor abstractDockColor) {
        this.colors.add(abstractDockColor);
        if (this.bound) {
            abstractDockColor.connect(this.getDockable().getController());
        }
    }

    protected void removeColor(AbstractDockColor abstractDockColor) {
        this.colors.remove(abstractDockColor);
        abstractDockColor.connect(null);
    }

    public Rectangle getIconBounds() {
        if (this.icon == null) {
            return null;
        }
        Insets insets = this.titleInsets();
        if (this.orientation.isVertical()) {
            int n = this.getWidth() - insets.left - insets.right;
            return new Rectangle(insets.left + (n - this.icon.getIconWidth()) / 2, insets.top, this.icon.getIconWidth(), this.icon.getIconHeight());
        }
        int n = this.getHeight() - insets.top - insets.bottom;
        return new Rectangle(insets.left, insets.top + (n - this.icon.getIconHeight()) / 2, this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    protected void setDisabled(boolean bl) {
        block4: {
            if (this.disabled == bl) break block4;
            this.disabled = bl;
            this.label.setEnabled(!bl);
            this.setEnabled(!bl);
            if (bl) {
                for (MouseInputListener mouseInputListener : this.mouseInputListeners) {
                    this.doRemoveMouseInputListener(mouseInputListener);
                }
            } else {
                for (MouseInputListener mouseInputListener : this.mouseInputListeners) {
                    this.doAddMouseInputListener(mouseInputListener);
                }
            }
        }
    }

    protected boolean isDisabled() {
        return this.disabled;
    }

    @Override
    protected void setupRenderingHints(Graphics graphics) {
        DockController dockController;
        Dockable dockable = this.getDockable();
        if (dockable != null && (dockController = dockable.getController()) != null) {
            DockRenderingHints dockRenderingHints = dockController.getProperties().get(DockRenderingHints.RENDERING_HINTS);
            dockRenderingHints.setupGraphics(graphics);
        }
    }

    @Override
    public void paintBackground(Graphics graphics) {
        if (this.getTransparency() != Transparency.TRANSPARENT) {
            this.paintBackground(graphics, this);
        }
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    @Override
    public void paintForeground(Graphics graphics) {
        this.paintForeground(graphics, this);
    }

    protected void paintForeground(Graphics graphics, JComponent jComponent) {
        this.paintIcon(graphics, jComponent);
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent) {
        Icon icon = this.icon;
        if (icon != null) {
            if (this.isDisabled()) {
                if (this.disabledIcon == null) {
                    this.disabledIcon = DockUtilities.disabledIcon(jComponent, icon);
                }
                icon = this.disabledIcon;
            }
            if (icon != null) {
                Insets insets = this.titleInsets();
                if (this.orientation.isVertical()) {
                    int n = this.getWidth() - insets.left - insets.right;
                    icon.paintIcon(this, graphics, insets.left + (n - icon.getIconWidth()) / 2, insets.top);
                } else {
                    int n = this.getHeight() - insets.top - insets.bottom;
                    icon.paintIcon(this, graphics, insets.left, insets.top + (n - icon.getIconHeight()) / 2);
                }
            }
        }
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
        this.disabledIcon = null;
        this.revalidate();
        this.repaint();
    }

    protected Icon getIcon() {
        return this.icon;
    }

    protected OrientedLabel getLabel() {
        return this.label;
    }

    protected void setText(String string) {
        this.label.setText(string);
        this.repaint();
    }

    protected String getText() {
        return this.label.getText();
    }

    protected void setTooltip(String string) {
        this.setToolTipText(string);
        this.label.setToolTipText(string);
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        this.orientation = orientation;
        this.updateLabelRotation();
        this.revalidate();
    }

    private void updateLabelRotation() {
        this.label.setRotation(this.orientationConverter.getValue().convert(this.getOrientation(), this));
    }

    @Override
    public DockTitle.Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public DockTitleVersion getOrigin() {
        return this.origin;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.label != null) {
            this.label.setBackground(color);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.icon != null) {
            return new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
        }
        Dimension dimension = this.getPreferredSize();
        int n = Math.min(dimension.width, dimension.height);
        return new Dimension(n, n);
    }

    public void setBorder(String string, Border border) {
        if (!(this.border == null || string != null && this.border.id.equals(string))) {
            this.border.setController(null);
            this.border = null;
        }
        if (this.border == null && string != null) {
            this.border = new TitleBorder(string);
            if (this.bound) {
                this.border.setController(this.getOrigin().getController());
            }
        }
        if (this.border == null) {
            this.setBorder(border);
        } else {
            this.border.setBorder(border);
        }
    }

    protected Insets getInnerInsets() {
        if (this.getOrientation().isHorizontal()) {
            return DEFAULT_INSETS_HORIZONTAL;
        }
        return DEFAULT_INSETS_VERTICAL;
    }

    protected Insets titleInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            return this.getInnerInsets();
        }
        insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        Insets insets2 = this.getInnerInsets();
        insets.top += insets2.top;
        insets.bottom += insets2.bottom;
        insets.left += insets2.left;
        insets.right += insets2.right;
        return insets;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.doTitleLayout();
    }

    protected void doTitleLayout() {
        Insets insets = this.titleInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        if (this.orientation.isHorizontal()) {
            if (this.icon != null) {
                n += this.icon.getIconWidth() + this.iconTextGap;
                n3 -= this.icon.getIconWidth() + this.iconTextGap;
            }
            this.label.setBounds(n, n2, n3, n4);
        } else {
            if (this.icon != null) {
                n2 += this.icon.getIconWidth() + this.iconTextGap;
                n4 -= this.icon.getIconWidth() + this.iconTextGap;
            }
            this.label.setBounds(n, n2, n3, n4);
        }
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseInputListeners.add(mouseInputListener);
        if (!this.isDisabled()) {
            this.doAddMouseInputListener(mouseInputListener);
        }
    }

    private void doAddMouseInputListener(MouseInputListener mouseInputListener) {
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
        this.label.addMouseListener(mouseInputListener);
        this.label.addMouseMotionListener(mouseInputListener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseInputListeners.remove(mouseInputListener);
        if (!this.isDisabled()) {
            this.doRemoveMouseInputListener(mouseInputListener);
        }
    }

    private void doRemoveMouseInputListener(MouseInputListener mouseInputListener) {
        this.removeMouseListener(mouseInputListener);
        this.removeMouseMotionListener(mouseInputListener);
        this.label.removeMouseListener(mouseInputListener);
        this.label.removeMouseMotionListener(mouseInputListener);
    }

    @Override
    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        Rectangle rectangle = this.getIconBounds();
        if (rectangle != null && rectangle.contains(point)) {
            if (this.getOrientation().isHorizontal()) {
                return new Point(rectangle.x, rectangle.y + rectangle.height);
            }
            return new Point(rectangle.x + rectangle.width, rectangle.y);
        }
        return null;
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public DockElement getElement() {
        return this.getDockable();
    }

    @Override
    public boolean isUsedAsTitle() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return true;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public void changed(DockTitleEvent dockTitleEvent) {
        if (dockTitleEvent instanceof ActivityDockTitleEvent) {
            this.setActive(((ActivityDockTitleEvent)dockTitleEvent).isActive());
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getText() == null || this.getText().length() == 0 ? new Dimension(5, 5) : this.label.getPreferredSize();
        Insets insets = this.titleInsets();
        if (this.orientation.isHorizontal()) {
            int n = 0;
            int n2 = 0;
            if (this.icon != null) {
                n = this.icon.getIconWidth();
                n2 = this.icon.getIconHeight();
            }
            n2 = Math.max(n2, dimension.height);
            n += dimension.width;
            if (this.icon == null) {
                n = Math.max(n, 2 * n2);
            }
            dimension = new Dimension(n + this.iconTextGap + insets.left + insets.right, n2 + insets.top + insets.bottom);
        } else {
            int n = 0;
            int n3 = 0;
            if (this.icon != null) {
                n = this.icon.getIconWidth();
                n3 = this.icon.getIconHeight();
            }
            n = Math.max(n, dimension.width);
            n3 += dimension.height;
            if (this.icon == null) {
                n3 = Math.max(n3, 2 * n);
            }
            dimension = new Dimension(n + insets.left + insets.right, n3 + this.iconTextGap + insets.top + insets.bottom);
        }
        return dimension;
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(dockAction, ViewTarget.TITLE, dockable);
    }

    @Override
    public void bind() {
        if (this.bound) {
            throw new IllegalArgumentException("Do not call bound twice!");
        }
        this.bound = true;
        DockController dockController = this.getDockable().getController();
        this.dockable.addDockableListener(this.listener);
        if (dockController != null) {
            for (AbstractDockColor abstractDockColor : this.colors) {
                abstractDockColor.connect(dockController);
            }
            this.orientationConverter.setProperties(dockController);
        }
        this.background.setController(dockController);
        if (this.border != null) {
            this.border.setController(dockController);
        }
        this.updateText();
        this.updateIcon();
        this.updateTooltip();
        this.rootHandler.setController(dockController);
        this.revalidate();
    }

    @Override
    public void unbind() {
        if (!this.bound) {
            throw new IllegalArgumentException("Do not call unbind twice");
        }
        this.bound = false;
        this.dockable.removeDockableListener(this.listener);
        this.rootHandler.setController(null);
        for (AbstractDockColor abstractDockColor : this.colors) {
            abstractDockColor.connect(null);
        }
        this.orientationConverter.setProperties((DockProperties)null);
        if (this.border != null) {
            this.border.setController(null);
        }
        this.setText("");
        this.setIcon(null);
        this.setTooltip(null);
        this.background.setController(null);
    }

    @Override
    public void setComponentConfiguration(DockComponentConfiguration dockComponentConfiguration) {
        this.rootHandler.setConfiguration(dockComponentConfiguration);
    }

    @Override
    public DockComponentConfiguration getComponentConfiguration() {
        return this.rootHandler.getConfiguration();
    }

    protected void updateIcon() {
        this.setIcon(this.dockable.getTitleIcon());
    }

    protected void updateText() {
        this.setText(this.dockable.getTitleText());
    }

    protected void updateTooltip() {
        this.setTooltip(this.dockable.getTitleToolTip());
    }

    public boolean isBound() {
        return this.bound;
    }

    private class Background
    extends BackgroundAlgorithm
    implements DockTitleBackgroundComponent {
        public Background() {
            super(DockTitleBackgroundComponent.KIND, "dock.background.title");
        }

        @Override
        public DockTitle getTitle() {
            return AbstractMultiDockTitle.this;
        }

        @Override
        public Component getComponent() {
            return this.getTitle().getComponent();
        }
    }

    private class Listener
    implements DockableListener,
    DockHierarchyListener {
        private Listener() {
        }

        @Override
        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            AbstractMultiDockTitle.this.updateIcon();
            AbstractMultiDockTitle.this.updateText();
        }

        @Override
        public void titleTextChanged(Dockable dockable, String string, String string2) {
            AbstractMultiDockTitle.this.updateIcon();
            AbstractMultiDockTitle.this.updateText();
        }

        @Override
        public void titleToolTipChanged(Dockable dockable, String string, String string2) {
            AbstractMultiDockTitle.this.updateTooltip();
        }

        @Override
        public void titleUnbound(Dockable dockable, DockTitle dockTitle) {
        }

        @Override
        public void titleBound(Dockable dockable, DockTitle dockTitle) {
        }

        @Override
        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            DockController dockController = dockHierarchyEvent.getDockable().getController();
            for (AbstractDockColor abstractDockColor : AbstractMultiDockTitle.this.colors) {
                abstractDockColor.connect(dockController);
            }
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        }
    }

    private class TitleBorder
    implements TitleDockBorder {
        private String id;
        private BorderModifier modifier;
        private DockController controller;
        private Border border;

        public TitleBorder(String string) {
            this.id = string;
        }

        @Override
        public DockTitle getTitle() {
            return AbstractMultiDockTitle.this;
        }

        @Override
        public void set(BorderModifier borderModifier) {
            if (borderModifier != this.modifier) {
                this.modifier = borderModifier;
                this.update();
            }
        }

        public void setBorder(Border border) {
            if (this.border != border) {
                this.border = border;
                this.update();
            }
        }

        private void update() {
            if (this.modifier == null) {
                AbstractMultiDockTitle.this.setBorder(this.border);
            } else {
                AbstractMultiDockTitle.this.setBorder(this.modifier.modify(this.border));
            }
        }

        public void setController(DockController dockController) {
            if (this.controller != null) {
                this.controller.getThemeManager().remove(this);
            }
            this.controller = dockController;
            if (this.controller == null) {
                this.set(null);
            } else {
                this.controller.getThemeManager().add(this.id, TitleDockBorder.KIND, ThemeManager.BORDER_MODIFIER_TYPE, this);
            }
        }
    }
}

