/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.title.AbstractMultiDockTitle;
import bibliothek.gui.dock.title.ActionsDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleEvent;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;

public class AbstractDockTitle
extends AbstractMultiDockTitle {
    private ButtonPanel itemPanel;
    private DockActionSource suggestedSource;

    public AbstractDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        this.init(dockable, dockTitleVersion, true);
    }

    public AbstractDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion, boolean bl) {
        this.init(dockable, dockTitleVersion, bl);
    }

    protected AbstractDockTitle() {
    }

    protected void init(Dockable dockable, DockTitleVersion dockTitleVersion, boolean bl) {
        super.init(dockable, dockTitleVersion);
        this.setShowMiniButtons(bl);
    }

    public boolean isShowMiniButtons() {
        return this.itemPanel != null;
    }

    public void setShowMiniButtons(boolean bl) {
        if (bl) {
            if (this.itemPanel == null) {
                this.itemPanel = new ButtonPanel(true){

                    @Override
                    protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
                        return AbstractDockTitle.this.createItemFor(dockAction, dockable);
                    }
                };
                this.itemPanel.setOpaque(false);
                this.itemPanel.setOrientation(this.getOrientation());
                this.itemPanel.setToolTipText(this.getToolTipText());
                this.add(this.itemPanel);
                if (this.isBound()) {
                    this.itemPanel.setController(this.getDockable().getController());
                    this.itemPanel.set(this.getDockable(), this.getActionSourceFor(this.getDockable()));
                }
            }
        } else if (this.itemPanel != null) {
            this.itemPanel.set(null);
            this.remove(this.itemPanel);
        }
    }

    @Override
    protected void setTooltip(String string) {
        super.setToolTipText(string);
        if (this.itemPanel != null) {
            this.itemPanel.setToolTipText(string);
        }
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        if (this.itemPanel != null) {
            this.itemPanel.setOrientation(orientation);
        }
        super.setOrientation(orientation);
    }

    @Override
    protected void doTitleLayout() {
        Insets insets = this.titleInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        OrientedLabel orientedLabel = this.getLabel();
        DockTitle.Orientation orientation = this.getOrientation();
        Icon icon = this.getIcon();
        int n5 = this.getIconTextGap();
        String string = this.getText();
        Dimension dimension = string == null || string.length() == 0 ? new Dimension(5, 5) : orientedLabel.getPreferredSize();
        if (orientation.isHorizontal()) {
            if (icon != null) {
                n += icon.getIconWidth() + n5;
                n3 -= icon.getIconWidth() + n5;
            }
            if (this.itemPanel != null && this.itemPanel.getItemCount() > 0) {
                Dimension[] dimensionArray = this.itemPanel.getPreferredSizes();
                int n6 = n3 - dimension.width;
                int n7 = dimensionArray.length - 1;
                while (n7 > 0 && dimensionArray[n7].width > n6) {
                    --n7;
                }
                this.itemPanel.setVisibleActions(n7);
                int n8 = dimensionArray[n7].width;
                int n9 = n3 - n8;
                orientedLabel.setBounds(n, n2, n9, n4);
                this.itemPanel.setBounds(n + n9, n2, n3 - n9, n4);
            } else {
                orientedLabel.setBounds(n, n2, n3, n4);
            }
        } else {
            if (icon != null) {
                n2 += icon.getIconWidth() + n5;
                n4 -= icon.getIconWidth() + n5;
            }
            if (this.itemPanel != null && this.itemPanel.getItemCount() > 0) {
                Dimension[] dimensionArray = this.itemPanel.getPreferredSizes();
                int n10 = n4 - dimension.height;
                int n11 = dimensionArray.length - 1;
                while (n11 > 0 && dimensionArray[n11].height > n10) {
                    --n11;
                }
                this.itemPanel.setVisibleActions(n11);
                int n12 = dimensionArray[n11].height;
                int n13 = n4 - n12;
                orientedLabel.setBounds(n, n2, n3, n13);
                this.itemPanel.setBounds(n, n2 + n13, n3, n4 - n13);
            } else {
                orientedLabel.setBounds(n, n2, n3, n4);
            }
        }
    }

    @Override
    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        boolean bl2 = this.getText() == null || this.getText().length() == 0;
        Rectangle rectangle = this.getIconBounds();
        if (rectangle != null && rectangle.contains(point)) {
            if (bl2) {
                int n = this.getWidth() * this.getHeight();
                if (this.itemPanel != null) {
                    n -= this.itemPanel.getWidth() * this.itemPanel.getHeight();
                }
                if (n <= 2 * rectangle.width * rectangle.height) {
                    return null;
                }
            }
            if (this.getOrientation().isHorizontal()) {
                return new Point(rectangle.x, rectangle.y + rectangle.height);
            }
            return new Point(rectangle.x + rectangle.width, rectangle.y);
        }
        return null;
    }

    @Override
    public void changed(DockTitleEvent dockTitleEvent) {
        super.changed(dockTitleEvent);
        if (dockTitleEvent instanceof ActionsDockTitleEvent) {
            this.suggestActions(((ActionsDockTitleEvent)dockTitleEvent).getSuggestions());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.itemPanel != null) {
            Dimension dimension2 = this.itemPanel.getPreferredSize();
            Insets insets = this.titleInsets();
            if (this.getOrientation().isHorizontal()) {
                dimension.width += dimension2.width;
                dimension.height = Math.max(dimension.height, dimension2.height + insets.top + insets.bottom);
            } else {
                dimension.height += dimension2.height;
                dimension.width = Math.max(dimension.width, dimension2.width + insets.left + insets.right);
            }
        }
        if (dimension.width < 10) {
            dimension.width = 10;
        }
        if (dimension.height < 10) {
            dimension.height = 10;
        }
        return dimension;
    }

    protected DockActionSource getActionSourceFor(Dockable dockable) {
        if (this.suggestedSource != null) {
            return this.suggestedSource;
        }
        return dockable.getGlobalActionOffers();
    }

    protected void suggestActions(DockActionSource dockActionSource) {
        if (this.suggestedSource != dockActionSource) {
            this.suggestedSource = dockActionSource;
            if (this.isShowMiniButtons()) {
                Dockable dockable = this.getDockable();
                this.itemPanel.set(dockable, this.getActionSourceFor(dockable));
            }
        }
    }

    protected DockActionSource getSuggestedSource() {
        return this.suggestedSource;
    }

    @Override
    public void bind() {
        DockController dockController = this.getDockable().getController();
        if (this.itemPanel != null) {
            Dockable dockable = this.getDockable();
            this.itemPanel.set(dockable, this.getActionSourceFor(dockable));
            this.itemPanel.setController(dockController);
        }
        super.bind();
    }

    @Override
    public void unbind() {
        if (this.itemPanel != null) {
            this.itemPanel.set(null);
            this.itemPanel.setController(null);
        }
        super.unbind();
    }
}

