/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.icon;

import bibliothek.gui.dock.station.stack.tab.TabMenu;
import bibliothek.gui.dock.station.stack.tab.TabMenuDockIcon;
import bibliothek.gui.dock.station.stack.tab.TabMenuListener;
import bibliothek.gui.dock.themes.icon.TabMenuOverflowIcon;
import bibliothek.gui.dock.util.icon.DockIcon;
import bibliothek.gui.dock.util.icon.DockIconBridge;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;

public class TabMenuOverflowIconBridge
implements DockIconBridge {
    public static final String ICON_KEY = "dock.menu.overflow";
    private Set<TabMenuDockIcon> menus = new HashSet<TabMenuDockIcon>();
    private Set<TabMenuDockIcon> protectedMenus = new HashSet<TabMenuDockIcon>();
    private TabMenuListener listener = new Listener();

    @Override
    public void add(String string, DockIcon dockIcon) {
        if (string.equals(ICON_KEY)) {
            TabMenuDockIcon tabMenuDockIcon = (TabMenuDockIcon)dockIcon;
            this.menus.add(tabMenuDockIcon);
            tabMenuDockIcon.getMenu().addTabMenuListener(this.listener);
        }
    }

    @Override
    public void remove(String string, DockIcon dockIcon) {
        if (string.equals(ICON_KEY)) {
            TabMenuDockIcon tabMenuDockIcon = (TabMenuDockIcon)dockIcon;
            this.menus.remove(tabMenuDockIcon);
            this.protectedMenus.remove(tabMenuDockIcon);
            tabMenuDockIcon.getMenu().removeTabMenuListener(this.listener);
            dockIcon.set(null);
        }
    }

    @Override
    public void set(String string, Icon icon, DockIcon dockIcon) {
        if (string.equals(ICON_KEY)) {
            if (icon == null) {
                icon = this.createIcon(((TabMenuDockIcon)dockIcon).getMenu());
                this.protectedMenus.remove(dockIcon);
            } else {
                this.protectedMenus.add((TabMenuDockIcon)dockIcon);
            }
            dockIcon.set(icon);
        }
    }

    private void update(TabMenu tabMenu) {
        for (TabMenuDockIcon tabMenuDockIcon : this.menus) {
            if (tabMenuDockIcon.getMenu() != tabMenu || this.protectedMenus.contains(tabMenuDockIcon)) continue;
            tabMenuDockIcon.set(this.createIcon(tabMenu));
            return;
        }
    }

    protected Icon createIcon(TabMenu tabMenu) {
        return new TabMenuOverflowIcon(tabMenu.getDockableCount());
    }

    private class Listener
    implements TabMenuListener {
        private Listener() {
        }

        @Override
        public void dockablesAdded(TabMenu tabMenu, int n, int n2) {
            TabMenuOverflowIconBridge.this.update(tabMenu);
        }

        @Override
        public void dockablesRemoved(TabMenu tabMenu, int n, int n2) {
            TabMenuOverflowIconBridge.this.update(tabMenu);
        }
    }
}

