/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.color;

import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.color.AbstractColorScheme;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import bibliothek.util.Path;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultColorScheme
extends AbstractColorScheme {
    private Map<String, Color> colors = new HashMap<String, Color>();
    private Map<Path, ColorBridgeFactory> bridges = new HashMap<Path, ColorBridgeFactory>();

    @Override
    public ColorBridge getBridge(Path path, UIProperties<Color, DockColor, ColorBridge> uIProperties) {
        ColorBridgeFactory colorBridgeFactory = this.getBridgeFactory(path);
        if (colorBridgeFactory == null) {
            return null;
        }
        return colorBridgeFactory.create((ColorManager)uIProperties);
    }

    @Override
    protected void updateUI() {
    }

    public void setBridgeFactory(final Path path, ColorBridgeFactory colorBridgeFactory) {
        if (colorBridgeFactory == null) {
            this.bridges.remove(path);
        } else {
            this.bridges.put(path, colorBridgeFactory);
        }
        UISchemeEvent<Color, DockColor, ColorBridge> uISchemeEvent = new UISchemeEvent<Color, DockColor, ColorBridge>(){

            @Override
            public UIScheme<Color, DockColor, ColorBridge> getScheme() {
                return DefaultColorScheme.this;
            }

            @Override
            public Collection<String> changedResources(Set<String> set) {
                return Collections.emptySet();
            }

            @Override
            public Collection<Path> changedBridges(Set<Path> set) {
                ArrayList<Path> arrayList = new ArrayList<Path>();
                for (Path path2 : set) {
                    if (!path2.startsWith(path)) continue;
                    arrayList.add(path2);
                }
                return arrayList;
            }
        };
        this.fire(uISchemeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(String string, Color color) {
        Map<String, Color> map = this.colors;
        synchronized (map) {
            if (color == null) {
                this.colors.remove(string);
            } else {
                this.colors.put(string, color);
            }
        }
        this.fire(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNullColor(String string) {
        Map<String, Color> map = this.colors;
        synchronized (map) {
            this.colors.put(string, null);
        }
        this.fire(string);
    }

    private void fire(final String string) {
        UISchemeEvent<Color, DockColor, ColorBridge> uISchemeEvent = new UISchemeEvent<Color, DockColor, ColorBridge>(){

            @Override
            public UIScheme<Color, DockColor, ColorBridge> getScheme() {
                return DefaultColorScheme.this;
            }

            @Override
            public Collection<String> changedResources(Set<String> set) {
                if (set == null) {
                    return null;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string2 : set) {
                    if (!string2.startsWith(string)) continue;
                    arrayList.add(string);
                }
                return arrayList;
            }

            @Override
            public Collection<Path> changedBridges(Set<Path> set) {
                return Collections.emptySet();
            }
        };
        this.fire(uISchemeEvent);
    }

    @Override
    public Color getResource(String string, UIProperties<Color, DockColor, ColorBridge> uIProperties) {
        return this.getColor(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getColor(String string) {
        Color color;
        Map<String, Color> map = this.colors;
        synchronized (map) {
            color = this.colors.get(string);
            if (color != null || this.colors.containsKey(string)) {
                return color;
            }
            int n = -1;
            for (Map.Entry<String, Color> entry : this.colors.entrySet()) {
                if (!string.startsWith(entry.getKey()) || entry.getKey().length() <= n) continue;
                n = entry.getKey().length();
                color = entry.getValue();
            }
        }
        return color;
    }

    public ColorBridgeFactory getBridgeFactory(Path path) {
        while (path != null) {
            ColorBridgeFactory colorBridgeFactory = this.bridges.get(path);
            if (colorBridgeFactory != null) {
                return colorBridgeFactory;
            }
            path = path.getParent();
        }
        return null;
    }
}

