/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.border;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.themes.border.DockBorder;
import bibliothek.util.Path;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class BorderForwarder
implements DockBorder {
    private JComponent target;
    private Border border;
    private BorderModifier modifier;
    private boolean forwarding = false;
    private DockController controller;
    private Path kind;
    private String id;

    public BorderForwarder(Path path, String string, JComponent jComponent) {
        if (path == null) {
            throw new IllegalArgumentException("kind must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (jComponent == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        this.kind = path;
        this.id = string;
        this.target = jComponent;
    }

    public void setBorder(Border border) {
        if (this.border != border) {
            this.border = border;
            if (this.modifier == null) {
                this.forward(border);
            } else {
                this.forward(this.modifier.modify(border));
            }
        }
    }

    @Override
    public void set(BorderModifier borderModifier) {
        if (this.modifier != borderModifier) {
            this.modifier = borderModifier;
            if (this.modifier == null) {
                this.forward(this.border);
            } else {
                this.forward(this.modifier.modify(this.border));
            }
        }
    }

    public BorderModifier get() {
        return this.modifier;
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.controller != null) {
                this.controller.getThemeManager().remove(this);
            }
            this.controller = dockController;
            if (this.controller != null) {
                this.controller.getThemeManager().add(this.id, this.kind, ThemeManager.BORDER_MODIFIER_TYPE, this);
            } else {
                this.set(null);
            }
        }
    }

    protected void forward(Border border) {
        try {
            this.forwarding = true;
            this.target.setBorder(border);
        }
        finally {
            this.forwarding = false;
        }
    }

    public boolean isForwarding() {
        return this.forwarding;
    }
}

