/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.menu;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.themes.basic.action.menu.AbstractMenuHandler;
import bibliothek.gui.dock.themes.basic.action.menu.MenuViewItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MenuMenuHandler
extends AbstractMenuHandler<JMenu, MenuDockAction> {
    private DockActionSource source;
    private Menu menu;
    private List<ActionItem> actions = new ArrayList<ActionItem>();
    private Listener sourceListener = new Listener();
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private ViewTarget<? extends MenuViewItem<JComponent>> target = ViewTarget.MENU;

    public MenuMenuHandler(MenuDockAction menuDockAction, Dockable dockable) {
        this(menuDockAction, dockable, ViewTarget.MENU);
    }

    public MenuMenuHandler(MenuDockAction menuDockAction, Dockable dockable, ViewTarget<? extends MenuViewItem<JComponent>> viewTarget) {
        super(menuDockAction, dockable, new JMenu());
        if (viewTarget == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        this.target = viewTarget;
        this.setup(menuDockAction.getMenu(dockable), new JMenuWrapper((JMenu)this.item));
    }

    public MenuMenuHandler(DockActionSource dockActionSource, Dockable dockable, JPopupMenu jPopupMenu) {
        super(null, dockable, null);
        this.setup(dockActionSource, new JPopupMenuWrapper(jPopupMenu));
    }

    private void setup(DockActionSource dockActionSource, Menu menu) {
        this.source = dockActionSource;
        this.menu = menu;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
    }

    public void addChildrenActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeChildrenActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    protected void fireActionEvent(ActionEvent actionEvent) {
        ActionListener[] actionListenerArray = this.listeners.toArray(new ActionListener[this.listeners.size()]);
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener actionListener = actionListenerArray[n2];
            actionListener.actionPerformed(actionEvent);
            ++n2;
        }
    }

    @Override
    public void bind() {
        super.bind();
        this.source.addDockActionSourceListener(this.sourceListener);
        int n = 0;
        int n2 = this.source.getDockActionCount();
        while (n < n2) {
            DockAction dockAction = this.source.getDockAction(n);
            ActionItem actionItem = new ActionItem();
            actionItem.action = dockAction;
            this.actions.add(actionItem);
            MenuViewItem<JComponent> menuViewItem = this.handlerFor(dockAction);
            if (menuViewItem != null) {
                actionItem.handler = menuViewItem;
                actionItem.bind();
                actionItem.action.bind(this.dockable);
                menuViewItem.bind();
                if (menuViewItem.getItem() != null) {
                    this.menu.add((JComponent)menuViewItem.getItem());
                }
            }
            ++n;
        }
    }

    protected MenuViewItem<JComponent> handlerFor(DockAction dockAction) {
        Dockable dockable = this.getDockable();
        MenuViewItem<JComponent> menuViewItem = dockable.getController().getActionViewConverter().createView(dockAction, this.target, dockable);
        return menuViewItem;
    }

    public MenuViewItem<JComponent> getViewFor(DockAction dockAction) {
        for (ActionItem actionItem : this.actions) {
            if (actionItem.action != dockAction) continue;
            return actionItem.handler;
        }
        return null;
    }

    @Override
    public void unbind() {
        super.unbind();
        this.source.removeDockActionSourceListener(this.sourceListener);
        this.menu.removeAll();
        for (ActionItem actionItem : this.actions) {
            actionItem.unbind();
            if (actionItem.handler == null) continue;
            actionItem.handler.unbind();
            actionItem.action.unbind(this.dockable);
        }
        this.actions.clear();
    }

    private class ActionItem
    implements ActionListener {
        public DockAction action;
        public MenuViewItem<JComponent> handler;

        private ActionItem() {
        }

        public void bind() {
            if (this.handler != null) {
                this.handler.addActionListener(this);
            }
        }

        public void unbind() {
            if (this.handler != null) {
                this.handler.removeActionListener(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuMenuHandler.this.fireActionEvent(new ActionEvent(this.action, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
        }
    }

    private static class JMenuWrapper
    implements Menu {
        private JMenu menu;

        public JMenuWrapper(JMenu jMenu) {
            this.menu = jMenu;
        }

        @Override
        public void add(JComponent jComponent) {
            this.menu.add(jComponent);
        }

        @Override
        public JMenuItem getItem() {
            return this.menu;
        }

        @Override
        public void removeAll() {
            this.menu.removeAll();
        }
    }

    private static class JPopupMenuWrapper
    implements Menu {
        private JPopupMenu menu;

        public JPopupMenuWrapper(JPopupMenu jPopupMenu) {
            this.menu = jPopupMenu;
        }

        @Override
        public void add(JComponent jComponent) {
            this.menu.add(jComponent);
        }

        @Override
        public JMenuItem getItem() {
            return null;
        }

        @Override
        public void removeAll() {
            this.menu.removeAll();
        }
    }

    private class Listener
    implements DockActionSourceListener {
        private Listener() {
        }

        private void reput() {
            MenuMenuHandler.this.menu.removeAll();
            for (ActionItem actionItem : MenuMenuHandler.this.actions) {
                if (actionItem.handler == null || actionItem.handler.getItem() == null) continue;
                MenuMenuHandler.this.menu.add((JComponent)actionItem.handler.getItem());
            }
        }

        @Override
        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            int n3 = n;
            while (n3 <= n2) {
                DockAction dockAction = dockActionSource.getDockAction(n3);
                ActionItem actionItem = new ActionItem();
                actionItem.action = dockAction;
                MenuMenuHandler.this.actions.add(n3, actionItem);
                MenuViewItem<JComponent> menuViewItem = MenuMenuHandler.this.handlerFor(dockAction);
                if (menuViewItem != null) {
                    dockAction.bind(MenuMenuHandler.this.dockable);
                    menuViewItem.bind();
                    actionItem.handler = menuViewItem;
                    actionItem.bind();
                }
                ++n3;
            }
            this.reput();
        }

        @Override
        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            int n3 = n2;
            while (n3 >= n) {
                ActionItem actionItem = (ActionItem)MenuMenuHandler.this.actions.remove(n3);
                actionItem.unbind();
                if (actionItem.handler != null) {
                    actionItem.handler.unbind();
                    actionItem.action.unbind(MenuMenuHandler.this.dockable);
                }
                --n3;
            }
            this.reput();
        }
    }

    private static interface Menu {
        public void add(JComponent var1);

        public void removeAll();

        public JMenuItem getItem();
    }
}

