/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.menu;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.action.actions.SimpleMenuAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;
import bibliothek.gui.dock.themes.basic.action.menu.MenuMenuHandler;
import bibliothek.gui.dock.themes.basic.action.menu.MenuViewItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JComponent;

public class DropDownMenuHandler
implements MenuViewItem<JComponent> {
    private SimpleMenuAction menuAction;
    private MenuMenuHandler handler;
    private DropDownAction action;
    private Listener listener = new Listener();
    private Dockable dockable;
    private ActionListener menuListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DockAction dockAction = (DockAction)actionEvent.getSource();
            DropDownViewItem dropDownViewItem = (DropDownViewItem)DropDownMenuHandler.this.handler.getViewFor(dockAction);
            if (dropDownViewItem != null && dropDownViewItem.isSelectable()) {
                DropDownMenuHandler.this.action.setSelection(DropDownMenuHandler.this.dockable, dockAction);
            }
        }
    };

    public DropDownMenuHandler(DropDownAction dropDownAction, Dockable dockable) {
        this.action = dropDownAction;
        this.dockable = dockable;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
    }

    @Override
    public void bind() {
        this.action.bind(this.dockable);
        DockActionSource dockActionSource = this.action.getSubActions(this.dockable);
        this.menuAction = new SimpleMenuAction(dockActionSource);
        this.handler = new MenuMenuHandler(this.menuAction, this.dockable, (ViewTarget<? extends MenuViewItem<JComponent>>)ViewTarget.DROP_DOWN);
        this.menuAction.setText(this.action.getText(this.dockable));
        this.menuAction.setTooltip(this.action.getTooltipText(this.dockable));
        this.menuAction.setEnabled(this.action.isEnabled(this.dockable));
        ActionContentModifier[] actionContentModifierArray = this.action.getIconContexts(this.dockable);
        int n = actionContentModifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContentModifier actionContentModifier = actionContentModifierArray[n2];
            this.menuAction.setIcon(actionContentModifier, this.action.getIcon(this.dockable, actionContentModifier));
            ++n2;
        }
        this.handler.bind();
        this.handler.addChildrenActionListener(this.menuListener);
        this.action.addDockActionListener(this.listener);
    }

    @Override
    public void unbind() {
        this.handler.removeChildrenActionListener(this.menuListener);
        this.handler.unbind();
        this.action.removeDockActionListener(this.listener);
        this.action.unbind(this.dockable);
        this.menuAction = null;
        this.handler = null;
    }

    @Override
    public DockAction getAction() {
        return this.action;
    }

    @Override
    public JComponent getItem() {
        return this.handler.getItem();
    }

    private class Listener
    implements StandardDockActionListener {
        private Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(DropDownMenuHandler.this.dockable)) {
                DropDownMenuHandler.this.menuAction.setEnabled(standardDockAction.isEnabled(DropDownMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction standardDockAction, ActionContentModifier actionContentModifier, Set<Dockable> set) {
            if (set.contains(DropDownMenuHandler.this.dockable)) {
                if (actionContentModifier == null) {
                    ActionContentModifier[] actionContentModifierArray = standardDockAction.getIconContexts(DropDownMenuHandler.this.dockable);
                    int n = actionContentModifierArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ActionContentModifier actionContentModifier2 = actionContentModifierArray[n2];
                        DropDownMenuHandler.this.menuAction.setIcon(actionContentModifier2, standardDockAction.getIcon(DropDownMenuHandler.this.dockable, actionContentModifier2));
                        ++n2;
                    }
                } else {
                    DropDownMenuHandler.this.menuAction.setIcon(actionContentModifier, standardDockAction.getIcon(DropDownMenuHandler.this.dockable, actionContentModifier));
                }
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(DropDownMenuHandler.this.dockable)) {
                DropDownMenuHandler.this.menuAction.setText(standardDockAction.getText(DropDownMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(DropDownMenuHandler.this.dockable)) {
                DropDownMenuHandler.this.menuAction.setTooltip(standardDockAction.getTooltipText(DropDownMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(set)) {
                DropDownMenuHandler.this.menuAction.setDockableRepresentation(standardDockAction.getDockableRepresentation(DropDownMenuHandler.this.dockable));
            }
        }
    }
}

