/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.menu;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.menu.MenuViewItem;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public abstract class AbstractMenuHandler<I extends JMenuItem, D extends StandardDockAction>
implements MenuViewItem<JComponent> {
    protected I item;
    protected Dockable dockable;
    protected D action;
    private Listener listener;

    public AbstractMenuHandler(D d, Dockable dockable, I i) {
        this.action = d;
        this.dockable = dockable;
        this.item = i;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public D getAction() {
        return this.action;
    }

    @Override
    public JMenuItem getItem() {
        return this.item;
    }

    @Override
    public void bind() {
        if (this.action != null) {
            if (this.listener == null) {
                this.action.bind(this.dockable);
                this.listener = new Listener();
                this.action.addDockActionListener(this.listener);
                if (this.item != null) {
                    ((JMenuItem)this.item).setEnabled(this.action.isEnabled(this.dockable));
                    ((AbstractButton)this.item).setIcon(this.getIcon(ActionContentModifier.NONE_HORIZONTAL));
                    ((AbstractButton)this.item).setDisabledIcon(this.action.getIcon(this.dockable, ActionContentModifier.DISABLED));
                    ((AbstractButton)this.item).setText(this.action.getText(this.dockable));
                    ((JComponent)this.item).setToolTipText(this.action.getTooltipText(this.dockable));
                }
            } else {
                throw new IllegalStateException("Handler is already bound");
            }
        }
    }

    private Icon getIcon(ActionContentModifier actionContentModifier) {
        while (actionContentModifier != null) {
            Icon icon = this.action.getIcon(this.dockable, actionContentModifier);
            if (icon != null) {
                return icon;
            }
            actionContentModifier = actionContentModifier.getBackup();
        }
        return null;
    }

    @Override
    public void unbind() {
        if (this.action != null) {
            if (this.listener != null) {
                this.action.unbind(this.dockable);
                this.action.removeDockActionListener(this.listener);
                this.listener = null;
            } else {
                throw new IllegalStateException("Handler is already unbound");
            }
        }
    }

    private class Listener
    implements StandardDockActionListener {
        private Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (AbstractMenuHandler.this.item != null) {
                ((JMenuItem)AbstractMenuHandler.this.item).setEnabled(standardDockAction.isEnabled(AbstractMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction standardDockAction, ActionContentModifier actionContentModifier, Set<Dockable> set) {
            if (AbstractMenuHandler.this.item != null) {
                if (actionContentModifier == null || actionContentModifier == ActionContentModifier.NONE_HORIZONTAL) {
                    ((AbstractButton)AbstractMenuHandler.this.item).setIcon(AbstractMenuHandler.this.getIcon(ActionContentModifier.NONE_HORIZONTAL));
                } else if (actionContentModifier == null || actionContentModifier == ActionContentModifier.NONE) {
                    ((AbstractButton)AbstractMenuHandler.this.item).setIcon(AbstractMenuHandler.this.getIcon(ActionContentModifier.NONE_HORIZONTAL));
                }
                if (actionContentModifier == null || actionContentModifier == ActionContentModifier.DISABLED) {
                    ((AbstractButton)AbstractMenuHandler.this.item).setDisabledIcon(standardDockAction.getIcon(AbstractMenuHandler.this.dockable, ActionContentModifier.DISABLED));
                }
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (AbstractMenuHandler.this.item != null) {
                ((AbstractButton)AbstractMenuHandler.this.item).setText(standardDockAction.getText(AbstractMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (AbstractMenuHandler.this.item != null) {
                ((JComponent)AbstractMenuHandler.this.item).setToolTipText(standardDockAction.getTooltipText(AbstractMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
        }
    }
}

