/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.dropdown;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.view.ViewItem;
import bibliothek.gui.dock.themes.color.ActionColor;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DropDownIcon
implements Icon {
    public static final String ICON_KEY = "dock.dropdown.icon";
    private Icon icon;
    private Icon disabledIcon;
    private boolean disabledIconInvalid = true;
    private Dockable dockable;
    private DropDownAction action;
    private ViewItem<? extends JComponent> parent;
    private IconColor color;
    private IconValue replacingIcon;
    private PropertyValue<Dimension> minimumSize = new PropertyValue<Dimension>(IconManager.MINIMUM_ICON_SIZE){

        @Override
        protected void valueChanged(Dimension dimension, Dimension dimension2) {
            DropDownIcon.this.resetIcon();
        }
    };

    public DropDownIcon() {
        this.resetIcon();
    }

    public void init(Dockable dockable, DropDownAction dropDownAction, ViewItem<? extends JComponent> viewItem) {
        if (this.isInitialized()) {
            throw new IllegalStateException("this icon is already initialized");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (dropDownAction == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        if (viewItem == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        this.dockable = dockable;
        this.action = dropDownAction;
        this.parent = viewItem;
        this.color = new IconColor();
        this.replacingIcon = new IconValue();
        this.resetIcon();
    }

    public boolean isInitialized() {
        return this.dockable != null;
    }

    public DropDownAction getAction() {
        return this.action;
    }

    public JComponent getParent() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getItem();
    }

    public void setController(DockController dockController) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("this icon must be initialized first");
        }
        this.color.connect(dockController);
        this.minimumSize.setProperties(dockController);
        this.replacingIcon.setController(dockController);
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null) {
            this.disabledIcon = new DisabledIcon();
        }
        return this.disabledIcon;
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.icon.paintIcon(component, graphics, n, n2);
    }

    protected void resetIcon() {
        Serializable serializable;
        this.disabledIconInvalid = true;
        int n = -1;
        int n2 = -1;
        if (this.icon != null) {
            n = this.icon.getIconWidth();
            n2 = this.icon.getIconHeight();
        }
        Icon icon = null;
        if (this.replacingIcon != null) {
            icon = (Icon)this.replacingIcon.value();
        }
        if (icon == null) {
            serializable = this.minimumSize.getValue();
            int n3 = ((Dimension)serializable).width / 2 - ((Dimension)serializable).width / 16;
            int n4 = ((Dimension)serializable).height / 2 - ((Dimension)serializable).height / 16;
            n3 = Math.max(1, n3);
            n4 = Math.max(1, n4);
            Color color = null;
            if (this.color != null) {
                color = (Color)this.color.value();
            }
            icon = new DefaultIcon(n3, n4, color);
        }
        this.icon = icon;
        serializable = this.getParent();
        if (serializable != null) {
            if (n != this.icon.getIconHeight() || n2 != this.icon.getIconHeight()) {
                ((Container)serializable).invalidate();
            }
            ((Component)serializable).repaint();
        }
    }

    private class DefaultIcon
    implements Icon {
        private Color color;
        private int width;
        private int height;

        public DefaultIcon(int n, int n2, Color color) {
            this.width = n;
            this.height = n2;
            this.color = color;
        }

        @Override
        public int getIconHeight() {
            return this.width;
        }

        @Override
        public int getIconWidth() {
            return this.height;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.color == null) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(this.color);
            }
            int n3 = Math.min(this.width, this.height);
            if (n3 == 7) {
                graphics.drawLine(++n, n2 + 1, n + 4, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + 3, n2 + 2);
                graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
            } else {
                float f = Math.max(1.0f, (float)n3 / 7.0f);
                float f2 = (float)n + f;
                int[] nArray = new int[3];
                int[] nArray2 = new int[3];
                nArray[0] = (int)(f2 + f);
                nArray2[0] = (int)((float)n2 + 1.0f * f);
                nArray[1] = (int)(f2 + 4.0f * f);
                nArray2[1] = (int)((float)n2 + 1.0f * f);
                nArray[2] = (int)(f2 + 2.5f * f);
                nArray2[2] = (int)((float)n2 + 3.0f * f);
                graphics.fillPolygon(nArray, nArray2, 3);
            }
        }
    }

    private class DisabledIcon
    implements Icon {
        private Icon disabled;
        private Color lastForeground;

        private DisabledIcon() {
        }

        @Override
        public int getIconWidth() {
            return DropDownIcon.this.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return DropDownIcon.this.getIconHeight();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getForeground();
            if (DropDownIcon.this.disabledIconInvalid || this.disabled == null || this.lastForeground == null || !this.lastForeground.equals(color)) {
                DropDownIcon.this.disabledIconInvalid = false;
                this.lastForeground = color;
                this.disabled = DockUtilities.disabledIcon(DropDownIcon.this.getParent(), DropDownIcon.this.icon);
            }
            this.disabled.paintIcon(component, graphics, n, n2);
        }
    }

    private class IconColor
    extends ActionColor {
        public IconColor() {
            super("action.dropdown.arrow", DropDownIcon.this.dockable, DropDownIcon.this.action, null);
        }

        @Override
        protected void changed(Color color, Color color2) {
            DropDownIcon.this.resetIcon();
        }
    }

    private class IconValue
    extends DockActionIcon {
        public IconValue() {
            super(DropDownIcon.ICON_KEY, DropDownIcon.this.getAction());
        }

        @Override
        protected void changed(Icon icon, Icon icon2) {
            DropDownIcon.this.resetIcon();
        }
    }
}

