/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelListener;
import bibliothek.gui.dock.themes.color.ActionColor;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;

public class MiniButtonContent
extends JComponent {
    private BasicButtonModel model;
    private OrientedLabel label;
    private Color labelOriginalColor;
    private ActionColor textColor;
    private ActionColor textColorDisabled;
    private boolean foregroundColorSet = false;
    private PropertyValue<Dimension> minimumIconSize = new PropertyValue<Dimension>(IconManager.MINIMUM_ICON_SIZE){

        @Override
        protected void valueChanged(Dimension dimension, Dimension dimension2) {
            MiniButtonContent.this.revalidate();
        }
    };
    private BasicButtonModelListener listener = new BasicButtonModelAdapter(){

        @Override
        public void orientationChanged(BasicButtonModel basicButtonModel, DockTitle.Orientation orientation, DockTitle.Orientation orientation2) {
            MiniButtonContent.this.label.setHorizontal(orientation2.isHorizontal());
        }

        @Override
        public void enabledStateChanged(BasicButtonModel basicButtonModel, boolean bl) {
            MiniButtonContent.this.updateLabelEnabled();
        }

        @Override
        public void textChanged(BasicButtonModel basicButtonModel, String string, String string2) {
            MiniButtonContent.this.label.setText(string2);
        }

        @Override
        public void bound(BasicButtonModel basicButtonModel, DockController dockController) {
            MiniButtonContent.this.minimumIconSize.setProperties(dockController);
            if (MiniButtonContent.this.textColor != null) {
                MiniButtonContent.this.textColor.connect(dockController);
                MiniButtonContent.this.textColorDisabled.connect(dockController);
            }
        }

        @Override
        public void unbound(BasicButtonModel basicButtonModel, DockController dockController) {
            MiniButtonContent.this.minimumIconSize.setProperties((DockController)null);
            if (MiniButtonContent.this.textColor != null) {
                MiniButtonContent.this.textColor.connect(null);
                MiniButtonContent.this.textColorDisabled.connect(null);
            }
        }
    };

    public MiniButtonContent() {
        this.label = new OrientedLabel(){

            @Override
            public boolean contains(int n, int n2) {
                return false;
            }

            @Override
            public void updateUI() {
                Color color = this.getForeground();
                if (MiniButtonContent.this.labelOriginalColor != null) {
                    this.setForeground(MiniButtonContent.this.labelOriginalColor);
                }
                super.updateUI();
                MiniButtonContent.this.labelOriginalColor = this.getForeground();
                if (MiniButtonContent.this.labelOriginalColor != null) {
                    this.setForeground(color);
                }
            }
        };
        this.labelOriginalColor = this.label.getForeground();
        this.setFocusable(false);
        this.label.setFocusable(false);
        this.setLayout(null);
        this.setOpaque(false);
        this.add(this.label);
        this.label.setIconOffset(0);
        this.label.setIconTextDistance(2);
    }

    public void setForegroundColorId(String string, String string2) {
        if (this.textColor == null) {
            this.textColor = new ActionColor(string, this.model.getDockable(), this.model.getAction(), null){

                @Override
                protected void changed(Color color, Color color2) {
                    if (color != color2 && MiniButtonContent.this.model.isEnabled()) {
                        MiniButtonContent.this.setLabelForeground(color2);
                    }
                }
            };
            this.textColorDisabled = new ActionColor(string2, this.model.getDockable(), this.model.getAction(), null){

                @Override
                protected void changed(Color color, Color color2) {
                    if (color != color2 && !MiniButtonContent.this.model.isEnabled()) {
                        MiniButtonContent.this.setLabelForeground(color2);
                    }
                }
            };
        } else {
            this.textColor.setId(string);
        }
    }

    public void setLabelForeground(Color color) {
        if (color == null) {
            this.label.setForeground(this.labelOriginalColor);
        } else {
            this.label.setForeground(color);
        }
        boolean bl = this.foregroundColorSet = color != null;
        if (this.foregroundColorSet) {
            this.label.setEnabled(true);
        } else {
            this.label.setEnabled(this.model.isEnabled());
        }
    }

    public void updateLabelEnabled() {
        boolean bl = this.model.isEnabled();
        if (this.textColor != null) {
            if (bl) {
                this.setLabelForeground(this.textColor.color());
            } else {
                this.setLabelForeground(this.textColorDisabled.color());
            }
        } else if (!this.foregroundColorSet) {
            this.label.setEnabled(bl);
        } else {
            this.label.setEnabled(true);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.label.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.label.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.label.getMaximumSize();
    }

    @Override
    public void doLayout() {
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Dimension dimension = this.label.getPreferredSize();
        int n = Math.max(0, rectangle.width - dimension.width);
        int n2 = Math.max(0, rectangle.height - dimension.height);
        rectangle.x += n / 2;
        rectangle.y += n2 / 2;
        rectangle.width -= n;
        rectangle.height -= n2;
        this.label.setBounds(rectangle);
    }

    @Override
    public boolean contains(int n, int n2) {
        return false;
    }

    public void setModel(BasicButtonModel basicButtonModel) {
        if (this.model != null) {
            throw new IllegalStateException("the model can be set only once");
        }
        if (this.model != null) {
            this.model.removeListener(this.listener);
        }
        this.model = basicButtonModel;
        if (this.model != null) {
            this.model.addListener(this.listener);
        }
        if (this.textColor != null) {
            this.textColor.connect(null);
            this.textColorDisabled.connect(null);
            String string = this.textColor.getId();
            String string2 = this.textColorDisabled.getId();
            this.textColor = null;
            this.textColorDisabled = null;
            this.setForeground(null);
            this.setForegroundColorId(string, string2);
        }
        this.updateContent();
    }

    protected void updateContent() {
        if (this.model == null) {
            this.label.setIcon(null);
            this.label.setText(null);
            this.label.setHorizontal(true);
            this.label.setEnabled(true);
        } else {
            this.label.setIcon(new ForwardIcon());
            this.label.setText(this.model.getText());
            this.label.setHorizontal(this.model.getOrientation().isHorizontal());
            this.label.setEnabled(this.model.isEnabled());
        }
    }

    protected Dimension getMinimumIconSize() {
        return this.minimumIconSize.getValue();
    }

    private class ForwardIcon
    implements Icon {
        private ForwardIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Icon icon = MiniButtonContent.this.model.getPaintIcon();
            if (icon != null) {
                Dimension dimension = MiniButtonContent.this.getMinimumIconSize();
                Dimension dimension2 = MiniButtonContent.this.model.getMaxIconSize();
                int n3 = (Math.max(dimension2.width, dimension.width) - icon.getIconWidth()) / 2;
                int n4 = (Math.max(dimension2.height, dimension.height) - icon.getIconHeight()) / 2;
                icon.paintIcon(component, graphics, n + n3, n2 + n4);
            }
        }

        @Override
        public int getIconWidth() {
            Dimension dimension = MiniButtonContent.this.getMinimumIconSize();
            return Math.max(dimension.width, ((MiniButtonContent)MiniButtonContent.this).model.getMaxIconSize().width);
        }

        @Override
        public int getIconHeight() {
            Dimension dimension = MiniButtonContent.this.getMinimumIconSize();
            return Math.max(dimension.height, ((MiniButtonContent)MiniButtonContent.this).model.getMaxIconSize().height);
        }
    }
}

