/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButtonContent;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class MiniButton<M extends BasicButtonModel>
extends JComponent {
    public static final String BORDER_KEY_NORMAL = "dock.border.action.miniButton.normal";
    public static final String BORDER_KEY_NORMAL_SELECTED = "dock.border.action.miniButton.normal.selected";
    public static final String BORDER_KEY_MOUSE_OVER = "dock.border.action.miniButton.mouseOver";
    public static final String BORDER_KEY_MOUSE_OVER_SELECTED = "dock.border.action.miniButton.mouseOver.selected";
    public static final String BORDER_KEY_MOUSE_PRESSED = "dock.border.action.miniButton.mousePressed";
    public static final String BORDER_KEY_MOUSE_PRESSED_SELECTED = "dock.border.action.miniButton.mousePressed.selected";
    private MiniButtonContent content;
    private Border normalBorder;
    private Border mouseOverBorder;
    private Border mousePressedBorder;
    private Border normalSelectedBorder;
    private Border mouseOverSelectedBorder;
    private Border mousePressedSelectedBorder;
    private String borderKeyNormal = "dock.border.action.miniButton.normal";
    private String borderKeyMouseOver = "dock.border.action.miniButton.mouseOver";
    private String borderKeyMousePressed = "dock.border.action.miniButton.mousePressed";
    private String borderKeyNormalSelected = "dock.border.action.miniButton.normal.selected";
    private String borderKeyMouseOverSelected = "dock.border.action.miniButton.mouseOver.selected";
    private String borderKeyMousePressedSelected = "dock.border.action.miniButton.mousePressed.selected";
    private M model;
    private BasicButtonModelAdapter listener = new BasicButtonModelAdapter(){

        @Override
        public void mouseInside(BasicButtonModel basicButtonModel, boolean bl) {
            MiniButton.this.updateBorder();
        }

        @Override
        public void mousePressed(BasicButtonModel basicButtonModel, boolean bl) {
            if (bl) {
                MiniButton.this.requestFocusInWindow();
            }
            MiniButton.this.updateBorder();
        }

        @Override
        public void enabledStateChanged(BasicButtonModel basicButtonModel, boolean bl) {
            MiniButton.this.updateBorder();
        }

        @Override
        public void selectedStateChanged(BasicButtonModel basicButtonModel, boolean bl) {
            MiniButton.this.updateBorder();
        }

        @Override
        public void borderChanged(BasicButtonModel basicButtonModel, String string, BorderModifier borderModifier, BorderModifier borderModifier2) {
            MiniButton.this.updateBorder();
        }
    };

    public MiniButton(M m) {
        this.model = m;
        this.content = this.createButtonContent();
        this.content.setModel((BasicButtonModel)m);
        this.setLayout(null);
        this.add(this.content);
        this.mousePressedBorder = BorderFactory.createBevelBorder(1);
        this.mouseOverBorder = BorderFactory.createBevelBorder(0);
        this.normalSelectedBorder = this.mousePressedBorder;
        this.mouseOverSelectedBorder = this.mousePressedBorder;
        this.mousePressedSelectedBorder = this.mouseOverBorder;
        this.setFocusable(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MiniButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                MiniButton.this.repaint();
            }
        });
        if (m != null) {
            this.content.setForegroundColorId("action.button.text", "action.button.text.disabled");
        }
    }

    protected MiniButtonContent createButtonContent() {
        return new MiniButtonContent();
    }

    protected MiniButtonContent getContent() {
        return this.content;
    }

    protected void setModel(M m) {
        if (this.model != null) {
            ((BasicButtonModel)this.model).removeListener(this.listener);
        }
        this.content.setModel((BasicButtonModel)m);
        this.model = m;
        if (this.model != null) {
            ((BasicButtonModel)this.model).addListener(this.listener);
            this.content.setForegroundColorId("action.button.text", "action.button.text.disabled");
        }
        this.updateBorder();
    }

    public M getModel() {
        return this.model;
    }

    public Border getMouseOverBorder() {
        return this.mouseOverBorder;
    }

    public void setMouseOverBorder(Border border) {
        this.mouseOverBorder = border;
        this.updateBorder();
    }

    public String getBorderKeyMouseOver() {
        return this.borderKeyMouseOver;
    }

    public void setBorderKeyMouseOver(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyMouseOver = string;
        this.updateBorder();
    }

    public Border getMousePressedBorder() {
        return this.mousePressedBorder;
    }

    public void setMousePressedBorder(Border border) {
        this.mousePressedBorder = border;
        this.updateBorder();
    }

    public String getBorderKeyMousePressed() {
        return this.borderKeyMousePressed;
    }

    public void setBorderKeyMousePressed(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyMousePressed = string;
        this.updateBorder();
    }

    public Border getNormalBorder() {
        return this.normalBorder;
    }

    public void setNormalBorder(Border border) {
        this.normalBorder = border;
        this.updateBorder();
    }

    public String getBorderKeyNormal() {
        return this.borderKeyNormal;
    }

    public void setBorderKeyNormal(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyNormal = string;
        this.updateBorder();
    }

    public Border getNormalSelectedBorder() {
        return this.normalSelectedBorder;
    }

    public void setNormalSelectedBorder(Border border) {
        this.normalSelectedBorder = border;
        this.updateBorder();
    }

    public String getBorderKeyNormalSelected() {
        return this.borderKeyNormalSelected;
    }

    public void setBorderKeyNormalSelected(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyNormalSelected = string;
        this.updateBorder();
    }

    public Border getMouseOverSelectedBorder() {
        return this.mouseOverSelectedBorder;
    }

    public void setMouseOverSelectedBorder(Border border) {
        this.mouseOverSelectedBorder = border;
        this.updateBorder();
    }

    public String getBorderKeyMouseOverSelected() {
        return this.borderKeyMouseOverSelected;
    }

    public void setBorderKeyMouseOverSelected(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyMouseOverSelected = string;
        this.updateBorder();
    }

    public Border getMousePressedSelectedBorder() {
        return this.mousePressedSelectedBorder;
    }

    public void setMousePressedSelectedBorder(Border border) {
        this.mousePressedSelectedBorder = border;
        this.updateBorder();
    }

    public String getBorderKeyMousePressedSelected() {
        return this.borderKeyMousePressedSelected;
    }

    public void setBorderKeyMousePressedSelected(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyMousePressedSelected = string;
        this.updateBorder();
    }

    @Override
    public void paint(Graphics graphics) {
        BackgroundPaint backgroundPaint = ((BasicButtonModel)this.model).getBackground();
        BackgroundComponent backgroundComponent = ((BasicButtonModel)this.model).getBackgroundComponent();
        AbstractPaintableComponent abstractPaintableComponent = new AbstractPaintableComponent(backgroundComponent, this, backgroundPaint){

            @Override
            protected void background(Graphics graphics) {
            }

            @Override
            protected void foreground(Graphics graphics) {
                MiniButton.this.doPaintForeground(graphics);
            }

            @Override
            protected void border(Graphics graphics) {
                MiniButton.this.doPaintBorder(graphics);
            }

            @Override
            protected void children(Graphics graphics) {
            }

            @Override
            protected void overlay(Graphics graphics) {
            }

            @Override
            public Transparency getTransparency() {
                return Transparency.DEFAULT;
            }
        };
        abstractPaintableComponent.paint(graphics);
    }

    private void doPaintForeground(Graphics graphics) {
        this.paintContent(graphics);
        if (this.isFocusOwner() && this.isFocusable()) {
            this.isEnabled();
        }
    }

    protected void paintContent(Graphics graphics) {
        this.paintChildren(graphics);
    }

    private void doPaintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintFocus(Graphics graphics) {
        graphics.setColor(this.getForeground());
        Insets insets = this.getMaxBorderInsets();
        int n = insets.left;
        int n2 = insets.right;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        --n4;
        graphics.drawLine(n, n2, n + 2, n2);
        graphics.drawLine(n, n2 + 1, n + 1, n2 + 1);
        graphics.drawLine(n, n2 + 2, n, n2 + 2);
        graphics.drawLine(n + --n3, n2, n + n3 - 2, n2);
        graphics.drawLine(n + n3, n2 + 1, n + n3 - 1, n2 + 1);
        graphics.drawLine(n + n3, n2 + 2, n + n3, n2 + 2);
        graphics.drawLine(n + n3, n2 + n4, n + n3 - 2, n2 + n4);
        graphics.drawLine(n + n3, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3, n2 + n4 - 2, n + n3, n2 + n4 - 2);
        graphics.drawLine(n, n2 + n4, n + 2, n2 + n4);
        graphics.drawLine(n, n2 + n4 - 1, n + 1, n2 + n4 - 1);
        graphics.drawLine(n, n2 + n4 - 2, n, n2 + n4 - 2);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getMaxBorderInsets();
        Dimension dimension = this.content.getPreferredSize();
        dimension.width += insets.left + insets.right + 2;
        dimension.height += insets.top + insets.bottom + 2;
        return dimension;
    }

    @Override
    public void doLayout() {
        Insets insets = this.getMaxBorderInsets();
        this.content.setBounds(insets.left, insets.top, this.getWidth() - insets.right - insets.left, this.getHeight() - insets.top - insets.bottom);
    }

    protected Insets getMaxBorderInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 0;
        while (n < 6) {
            Border border = null;
            switch (n) {
                case 0: {
                    border = this.getBorder(this.getNormalBorder(), this.borderKeyNormal);
                    break;
                }
                case 1: {
                    border = this.getBorder(this.getMouseOverBorder(), this.borderKeyMouseOver);
                    break;
                }
                case 2: {
                    border = this.getBorder(this.getMousePressedBorder(), this.borderKeyMousePressed);
                    break;
                }
                case 3: {
                    border = this.getBorder(this.getNormalSelectedBorder(), this.borderKeyNormalSelected);
                    break;
                }
                case 4: {
                    border = this.getBorder(this.getMouseOverSelectedBorder(), this.borderKeyMouseOverSelected);
                    break;
                }
                case 5: {
                    border = this.getBorder(this.getMousePressedSelectedBorder(), this.borderKeyMousePressedSelected);
                }
            }
            if (border != null) {
                Insets insets2 = border.getBorderInsets(this);
                insets.left = Math.max(insets.left, insets2.left);
                insets.right = Math.max(insets.right, insets2.right);
                insets.top = Math.max(insets.top, insets2.top);
                insets.bottom = Math.max(insets.bottom, insets2.bottom);
            }
            ++n;
        }
        return insets;
    }

    protected void updateBorder() {
        if (((BasicButtonModel)this.model).isEnabled() && ((BasicButtonModel)this.model).isMousePressed()) {
            if (((BasicButtonModel)this.model).isSelected()) {
                this.setBorder(this.getBorder(this.getMousePressedSelectedBorder(), this.borderKeyMousePressedSelected));
            } else {
                this.setBorder(this.getBorder(this.getMousePressedBorder(), this.borderKeyMousePressed));
            }
        } else if (((BasicButtonModel)this.model).isEnabled() && ((BasicButtonModel)this.model).isMouseInside()) {
            if (((BasicButtonModel)this.model).isSelected()) {
                this.setBorder(this.getBorder(this.getMouseOverSelectedBorder(), this.borderKeyMouseOverSelected));
            } else {
                this.setBorder(this.getBorder(this.getMouseOverBorder(), this.borderKeyMouseOver));
            }
        } else if (((BasicButtonModel)this.model).isSelected()) {
            this.setBorder(this.getBorder(this.getNormalSelectedBorder(), this.borderKeyNormalSelected));
        } else {
            this.setBorder(this.getBorder(this.getNormalBorder(), this.borderKeyNormal));
        }
    }

    private Border getBorder(Border border, String string) {
        BorderModifier borderModifier = ((BasicButtonModel)this.model).getBorder(string);
        if (borderModifier == null) {
            return border;
        }
        return borderModifier.modify(border);
    }
}

