/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButton;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButtonContent;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.Border;

public class DropDownMiniButton
extends MiniButton<BasicDropDownButtonModel> {
    private Icon dropIcon;
    private Icon disabledDropIcon;
    private BasicDropDownButtonHandler handler;

    public DropDownMiniButton(BasicDropDownButtonHandler basicDropDownButtonHandler) {
        super(null);
        this.handler = basicDropDownButtonHandler;
        BasicDropDownButtonModel basicDropDownButtonModel = new BasicDropDownButtonModel(this, basicDropDownButtonHandler, basicDropDownButtonHandler){

            @Override
            public void changed() {
                DropDownMiniButton.this.updateBorder();
                DropDownMiniButton.this.repaint();
            }

            @Override
            protected boolean inDropDownArea(int n, int n2) {
                return DropDownMiniButton.this.isOverDropIcon(n, n2);
            }
        };
        this.setModel(basicDropDownButtonModel);
        this.dropIcon = basicDropDownButtonHandler.getDropDownIcon();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getMaxBorderInsets();
        Dimension dimension = this.getContent().getPreferredSize();
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int n = insets.left + 2 * insets.right + dimension.width;
            int n2 = this.dropIcon.getIconHeight();
            n2 = Math.max(n2, dimension.height);
            return new Dimension(n += this.dropIcon.getIconWidth(), n2 += insets.top + insets.bottom);
        }
        int n = insets.top + 2 * insets.bottom + dimension.height;
        int n3 = this.dropIcon.getIconWidth();
        n3 = Math.max(n3, dimension.width);
        return new Dimension(n3 += insets.left + insets.right, n += this.dropIcon.getIconHeight());
    }

    @Override
    public void updateUI() {
        if (this.handler != null) {
            this.handler.updateUI();
        }
        super.updateUI();
    }

    @Override
    public void paint(Graphics graphics) {
        BasicDropDownButtonModel basicDropDownButtonModel = (BasicDropDownButtonModel)this.getModel();
        BackgroundPaint backgroundPaint = basicDropDownButtonModel.getBackground();
        BackgroundComponent backgroundComponent = basicDropDownButtonModel.getBackgroundComponent();
        AbstractPaintableComponent abstractPaintableComponent = new AbstractPaintableComponent(backgroundComponent, this, backgroundPaint){

            @Override
            protected void background(Graphics graphics) {
            }

            @Override
            protected void foreground(Graphics graphics) {
                DropDownMiniButton.this.doPaintForeground(graphics);
            }

            @Override
            protected void border(Graphics graphics) {
                DropDownMiniButton.this.doPaintBorder(graphics);
            }

            @Override
            protected void children(Graphics graphics) {
            }

            @Override
            protected void overlay(Graphics graphics) {
            }

            @Override
            public Transparency getTransparency() {
                return Transparency.DEFAULT;
            }
        };
        abstractPaintableComponent.paint(graphics);
    }

    @Override
    public void doLayout() {
        MiniButtonContent miniButtonContent = this.getContent();
        Insets insets = this.getMaxBorderInsets();
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int n = this.dropIcon.getIconWidth();
            miniButtonContent.setBounds(insets.left + 1, insets.top, this.getWidth() - insets.left - 2 * insets.right - 1 - n, this.getHeight() - insets.top - insets.bottom);
        } else {
            int n = this.dropIcon.getIconHeight();
            miniButtonContent.setBounds(insets.left, insets.top + 1, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - 2 * insets.bottom - 1 - n);
        }
    }

    private void doPaintForeground(Graphics graphics) {
        this.paintContent(graphics);
        Insets insets = this.getMaxBorderInsets();
        MiniButtonContent miniButtonContent = this.getContent();
        Icon icon = this.dropIcon;
        if (!this.isEnabled()) {
            if (this.disabledDropIcon == null) {
                this.disabledDropIcon = this.handler.getDisabledDropDownIcon();
            }
            icon = this.disabledDropIcon;
        }
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int n = miniButtonContent.getWidth();
            int n2 = this.dropIcon.getIconWidth();
            double d = insets.left + n + insets.right + n2 + insets.right;
            double d2 = (double)this.getWidth() / d;
            icon.paintIcon(this, graphics, (int)(d2 * (double)(insets.left + insets.right + n + n2 / 2) - (double)(n2 / 2)), insets.top + (this.getHeight() - insets.top - insets.bottom - this.dropIcon.getIconHeight()) / 2);
        } else {
            int n = miniButtonContent.getHeight();
            int n3 = this.dropIcon.getIconHeight();
            double d = insets.top + n + insets.bottom + n3 + insets.bottom;
            double d3 = (double)this.getHeight() / d;
            icon.paintIcon(this, graphics, insets.left + (this.getWidth() - insets.left - insets.right - this.dropIcon.getIconWidth()) / 2, (int)(d3 * (double)(insets.top + insets.bottom + n + n3 / 2) - (double)(n3 / 2)));
        }
        if (this.isFocusOwner() && this.isFocusable()) {
            this.isEnabled();
        }
    }

    private void doPaintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = this.getMaxBorderInsets();
            if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
                int n = this.getContent().getWidth();
                int n2 = this.dropIcon.getIconWidth();
                double d = insets.left + n + insets.right + n2 + insets.right;
                double d2 = (double)this.getWidth() / d;
                border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
                if (((BasicDropDownButtonModel)this.getModel()).isMouseOverDropDown()) {
                    border.paintBorder(this, graphics, 0, 0, (int)(d2 * (double)(insets.left + insets.right + n)), this.getHeight());
                }
            } else {
                int n = this.getContent().getHeight();
                int n3 = this.dropIcon.getIconHeight();
                double d = insets.top + n + insets.bottom + n3 + insets.bottom;
                double d3 = (double)this.getHeight() / d;
                if (((BasicDropDownButtonModel)this.getModel()).isMouseOverDropDown()) {
                    border.paintBorder(this, graphics, 0, 0, this.getWidth(), (int)(d3 * (double)(insets.top + insets.bottom + n)));
                }
            }
        }
    }

    public boolean isOverDropIcon(int n, int n2) {
        if (!this.contains(n, n2)) {
            return false;
        }
        Insets insets = this.getMaxBorderInsets();
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int n3 = this.getContent().getWidth();
            int n4 = this.dropIcon.getIconWidth();
            double d = insets.left + n3 + insets.right + n4 + insets.right;
            double d2 = (double)this.getWidth() / d;
            int n5 = (int)(d2 * (double)(insets.left + insets.right + n3)) - insets.right;
            return n > n5;
        }
        int n6 = this.getContent().getHeight();
        int n7 = this.dropIcon.getIconHeight();
        double d = insets.top + n6 + insets.bottom + n7 + insets.bottom;
        double d3 = (double)this.getHeight() / d;
        int n8 = (int)(d3 * (double)(insets.top + insets.bottom + n6)) - insets.bottom;
        return n2 > n8;
    }
}

