/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.actions.SimpleMenuAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.DockActionImportanceOrder;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    private DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;
    private Dockable dockable;
    private DockActionSource source;
    private Listener listener = new Listener();
    private List<ActionItem> actions = new ArrayList<ActionItem>();
    private DefaultDockActionSource menuSource;
    private BasicTitleViewItem<JComponent> menuItem;
    private SimpleMenuAction menuAction;
    private DockActionIcon menuIcon;
    private int visibleActions = -1;
    private PropertyValue<DockActionImportanceOrder> actionOrder = new PropertyValue<DockActionImportanceOrder>(DockActionImportanceOrder.ORDER){

        @Override
        protected void valueChanged(DockActionImportanceOrder dockActionImportanceOrder, DockActionImportanceOrder dockActionImportanceOrder2) {
            ButtonPanel.this.resetVisibleActions();
        }
    };

    public ButtonPanel(boolean bl) {
        this.setLayout(null);
        this.setOpaque(false);
        if (bl) {
            this.menuSource = new DefaultDockActionSource(new DockAction[0]);
            this.menuAction = new SimpleMenuAction(this.menuSource);
            this.menuIcon = new DockActionIcon("overflow.menu", this.menuAction){

                @Override
                protected void changed(Icon icon, Icon icon2) {
                    ButtonPanel.this.menuAction.setIcon(icon2);
                }
            };
        }
        this.setFocusable(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(dockAction, ViewTarget.TITLE, dockable);
    }

    public int getItemCount() {
        int n = 0;
        for (ActionItem actionItem : this.actions) {
            if (actionItem.item == null) continue;
            ++n;
        }
        return n;
    }

    public void setOrientation(DockTitle.Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            if (this.menuItem != null) {
                this.menuItem.setOrientation(orientation);
            }
            for (ActionItem actionItem : this.actions) {
                if (actionItem.item == null) continue;
                actionItem.item.setOrientation(orientation);
            }
            this.revalidate();
        }
    }

    public DockTitle.Orientation getOrientation() {
        return this.orientation;
    }

    public void set(Dockable dockable) {
        if (dockable == null) {
            this.set(null, null);
        } else {
            this.set(dockable, dockable.getGlobalActionOffers());
        }
    }

    public DockActionSource getSource() {
        return this.source;
    }

    public boolean hasActions() {
        return this.actions.size() > 0;
    }

    public void setController(DockController dockController) {
        this.actionOrder.setProperties(dockController);
    }

    private void set() {
        this.set(this.dockable, this.source, true);
    }

    public void set(Dockable dockable, DockActionSource dockActionSource) {
        this.set(dockable, dockActionSource, false);
    }

    public void set(Dockable dockable, DockActionSource dockActionSource, boolean bl) {
        if (dockActionSource == null != (dockable == null)) {
            throw new IllegalArgumentException("Either both arguments are null, or none");
        }
        if (bl || this.source != dockActionSource || this.dockable != dockable) {
            if (this.source != null) {
                this.removeAll();
                for (ActionItem object : this.actions) {
                    if (object.item == null) continue;
                    object.item.unbind();
                    object.action.unbind(this.dockable);
                }
                if (this.menuAction != null) {
                    if (this.menuItem != null) {
                        this.menuItem.unbind();
                        this.menuItem = null;
                    }
                    this.menuAction.unbind(this.dockable);
                    this.menuSource.removeAll();
                }
                this.actions.clear();
                this.source.removeDockActionSourceListener(this.listener);
            }
            this.source = dockActionSource;
            this.dockable = dockable;
            this.listener.setDockable(dockable);
            if (dockActionSource != null) {
                if (this.menuAction != null) {
                    this.menuAction.bind(dockable);
                    if (dockable.getController() != null) {
                        this.menuItem = this.createItemFor(this.menuAction, dockable);
                        if (this.menuItem != null) {
                            this.menuItem.setOrientation(this.orientation);
                            this.menuItem.setForeground(this.getForeground());
                            this.menuItem.setBackground(this.getBackground());
                            this.menuItem.bind();
                        }
                    }
                }
                dockActionSource.addDockActionSourceListener(this.listener);
                for (DockAction dockAction : dockActionSource) {
                    BasicTitleViewItem<JComponent> basicTitleViewItem;
                    ActionItem actionItem = new ActionItem();
                    actionItem.action = dockAction;
                    this.actions.add(actionItem);
                    if (dockable.getController() == null || (basicTitleViewItem = this.createItemFor(dockAction, dockable)) == null) continue;
                    dockAction.bind(dockable);
                    basicTitleViewItem.bind();
                    actionItem.item = basicTitleViewItem;
                    basicTitleViewItem.setOrientation(this.orientation);
                    basicTitleViewItem.setForeground(this.getForeground());
                    basicTitleViewItem.setBackground(this.getBackground());
                }
            }
            this.visibleActions = this.actions.size();
            this.resetVisibleActions();
            this.revalidate();
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.menuItem != null) {
            this.menuItem.setForeground(color);
        }
        if (this.actions != null) {
            for (ActionItem actionItem : this.actions) {
                if (actionItem.item == null) continue;
                actionItem.item.setForeground(color);
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.menuItem != null) {
            this.menuItem.setBackground(color);
        }
        if (this.actions != null) {
            for (ActionItem actionItem : this.actions) {
                if (actionItem.item == null) continue;
                actionItem.item.setBackground(color);
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ButtonPanel.this.setForeground(ButtonPanel.this.getForeground());
                ButtonPanel.this.setBackground(ButtonPanel.this.getBackground());
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.actions.isEmpty()) {
            return new Dimension(0, 0);
        }
        if (this.menuItem == null) {
            return this.getPreferredSize();
        }
        return ((JComponent)this.menuItem.getItem()).getMinimumSize();
    }

    private ActionItem[] getItemsOrdered() {
        DockAction[] dockActionArray = new DockAction[this.actions.size()];
        int n = 0;
        while (n < dockActionArray.length) {
            dockActionArray[n] = this.actions.get((int)n).action;
            ++n;
        }
        this.actionOrder.getValue().order(dockActionArray);
        n = 0;
        int n2 = 0;
        int n3 = dockActionArray.length;
        ActionItem[] actionItemArray = new ActionItem[n3];
        boolean[] blArray = new boolean[n3];
        DockAction[] dockActionArray2 = dockActionArray;
        int n4 = dockActionArray.length;
        int n5 = 0;
        while (n5 < n4) {
            block8: {
                ActionItem actionItem;
                DockAction dockAction = dockActionArray2[n5];
                int n6 = n2;
                while (n6 < n3) {
                    if (!blArray[n6]) {
                        actionItem = this.actions.get(n6);
                        if (actionItem.action == dockAction) {
                            blArray[n6] = true;
                            actionItemArray[n++] = actionItem;
                            n2 = n6 + 1;
                            break block8;
                        }
                    }
                    ++n6;
                }
                n6 = 0;
                while (n6 < n2) {
                    if (!blArray[n6]) {
                        actionItem = this.actions.get(n6);
                        if (actionItem.action == dockAction) {
                            blArray[n6] = true;
                            actionItemArray[n++] = actionItem;
                            n2 = n6 + 1;
                            break;
                        }
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        return actionItemArray;
    }

    public Dimension[] getPreferredSizes() {
        if (this.actions.isEmpty()) {
            return new Dimension[]{new Dimension(0, 0)};
        }
        if (this.menuAction == null) {
            return new Dimension[]{this.getPreferredSize()};
        }
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = this.menuItem == null ? new Dimension(0, 0) : ((JComponent)this.menuItem.getItem()).getPreferredSize();
        Dimension[] dimensionArray = new Dimension[this.actions.size() + 1];
        dimensionArray[0] = new Dimension(dimension2);
        ActionItem[] actionItemArray = this.getItemsOrdered();
        int n = 0;
        int n2 = actionItemArray.length;
        while (n < n2) {
            Dimension dimension3;
            BasicTitleViewItem<JComponent> basicTitleViewItem = actionItemArray[n].item;
            if (basicTitleViewItem != null) {
                dimension3 = ((JComponent)basicTitleViewItem.getItem()).getPreferredSize();
                if (this.orientation.isHorizontal()) {
                    dimension.width += dimension3.width;
                    dimension.height = Math.max(dimension.height, dimension3.height);
                } else {
                    dimension.width = Math.max(dimension.width, dimension3.width);
                    dimension.height += dimension3.height;
                }
            }
            dimension3 = new Dimension(dimension);
            if (n + 1 < n2) {
                if (this.orientation.isHorizontal()) {
                    dimension3.width += dimension2.width;
                    dimension3.height = Math.max(dimension3.height, dimension2.height);
                } else {
                    dimension3.width = Math.max(dimension3.width, dimension2.width);
                    dimension3.height += dimension2.height;
                }
            }
            dimensionArray[n + 1] = dimension3;
            ++n;
        }
        Insets insets = this.getInsets();
        Dimension[] dimensionArray2 = dimensionArray;
        int n3 = dimensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Dimension dimension4 = dimensionArray2[n4];
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom;
            ++n4;
        }
        return dimensionArray;
    }

    public Dimension getCurrentPreferredSize() {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (this.orientation.isHorizontal()) {
            n = 0;
            int n4 = this.getComponentCount();
            while (n < n4) {
                Dimension dimension = this.getComponent(n).getPreferredSize();
                n2 += dimension.width;
                n3 = Math.max(n3, dimension.height);
                ++n;
            }
        } else {
            n = 0;
            int n5 = this.getComponentCount();
            while (n < n5) {
                Dimension dimension = this.getComponent(n).getPreferredSize();
                n2 = Math.max(n2, dimension.width);
                n3 += dimension.height;
                ++n;
            }
        }
        Insets insets = this.getInsets();
        return new Dimension(n2 + insets.left + insets.right, n3 + insets.top + insets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        if (this.orientation.isHorizontal()) {
            for (ActionItem object2 : this.actions) {
                if (object2.item == null) continue;
                Dimension dimension = ((JComponent)object2.item.getItem()).getPreferredSize();
                n += dimension.width;
                n2 = Math.max(n2, dimension.height);
            }
        } else {
            for (ActionItem actionItem : this.actions) {
                if (actionItem.item == null) continue;
                Dimension dimension = ((JComponent)actionItem.item.getItem()).getPreferredSize();
                n = Math.max(n, dimension.width);
                n2 += dimension.height;
            }
        }
        Insets insets = this.getInsets();
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    public void setVisibleActions(int n) {
        if (this.visibleActions != n) {
            this.visibleActions = n;
            this.resetVisibleActions();
        }
    }

    private void resetVisibleActions() {
        this.removeAll();
        if (this.menuItem == null) {
            for (ActionItem actionItem : this.actions) {
                if (actionItem.item == null) continue;
                this.add((Component)actionItem.item.getItem());
            }
        } else {
            this.menuSource.removeAll();
            int n = 0;
            int n2 = 0;
            int n3 = this.actions.size();
            int n4 = this.actions.size();
            ActionItem[] actionItemArray = this.getItemsOrdered();
            HashSet<ActionItem> hashSet = new HashSet<ActionItem>();
            while (n < this.visibleActions && n2 < n4) {
                ActionItem actionItem = actionItemArray[n2++];
                if (actionItem.item == null) {
                    --n3;
                    continue;
                }
                ++n;
                hashSet.add(actionItem);
            }
            for (ActionItem actionItem : this.actions) {
                if (hashSet.contains(actionItem)) {
                    this.add((Component)actionItem.item.getItem());
                    continue;
                }
                this.menuSource.add(actionItem.action);
            }
            if (n < n3) {
                this.add((Component)this.menuItem.getItem());
            }
        }
    }

    @Override
    public void doLayout() {
        Dimension dimension = this.getCurrentPreferredSize();
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        if (this.orientation.isHorizontal()) {
            if (dimension.width <= 0) {
                return;
            }
            int n = insets.left;
            int n2 = insets.top;
            int n3 = this.getHeight() - insets.top - insets.bottom;
            int n4 = this.getWidth() - insets.left - insets.right;
            if (n4 > dimension.width) {
                n += n4 - dimension.width;
                n4 = dimension.width;
            }
            int n5 = 0;
            int n6 = this.getComponentCount();
            while (n5 < n6) {
                Component component = this.getComponent(n5);
                Dimension dimension2 = component.getPreferredSize();
                if (dimension.width <= 0) {
                    if (n4 <= 0) {
                        n4 = 1;
                    }
                    dimension.width = n4;
                }
                if (n4 == dimension.width) {
                    component.setBounds(n, n2, dimension2.width, n3);
                } else {
                    double d = (double)n4 / (double)dimension.width;
                    component.setBounds(n, n2, (int)(d * (double)dimension2.width), n3);
                }
                dimension.width -= dimension2.width;
                n4 -= component.getWidth();
                n += component.getWidth();
                ++n5;
            }
        } else {
            if (dimension.width <= 0) {
                return;
            }
            int n = insets.left;
            int n7 = insets.top;
            int n8 = this.getHeight() - insets.top - insets.bottom;
            int n9 = this.getWidth() - insets.left - insets.bottom;
            if (n8 > dimension.height) {
                n7 += n8 - dimension.height;
                n8 = dimension.height;
            }
            int n10 = 0;
            int n11 = this.getComponentCount();
            while (n10 < n11) {
                Component component = this.getComponent(n10);
                Dimension dimension3 = component.getPreferredSize();
                if (dimension.height <= 0) {
                    if (n8 <= 0) {
                        n8 = 1;
                    }
                    dimension.height = n8;
                }
                if (n8 == dimension.height) {
                    component.setBounds(n, n7, n9, dimension3.height);
                } else {
                    double d = (double)n8 / (double)dimension.height;
                    component.setBounds(n, n7, n9, (int)(d * (double)dimension3.height));
                }
                dimension.height -= dimension3.height;
                n8 -= component.getHeight();
                n7 += component.getHeight();
                ++n10;
            }
        }
    }

    private static class ActionItem {
        public DockAction action;
        public BasicTitleViewItem<JComponent> item;

        private ActionItem() {
        }
    }

    private class Listener
    implements DockActionSourceListener,
    DockHierarchyListener {
        private Dockable dockable;

        private Listener() {
        }

        public void setDockable(Dockable dockable) {
            if (this.dockable != null) {
                this.dockable.removeDockHierarchyListener(this);
                this.dockable = null;
            }
            this.dockable = dockable;
            DockController dockController = null;
            if (dockable != null) {
                dockable.addDockHierarchyListener(this);
                dockController = dockable.getController();
            }
            if (ButtonPanel.this.menuIcon != null) {
                if (dockController == null) {
                    ButtonPanel.this.menuIcon.setManager(null);
                } else {
                    ButtonPanel.this.menuIcon.setManager(dockController.getIcons());
                }
            }
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            DockController dockController = null;
            if (this.dockable != null) {
                dockController = this.dockable.getController();
            }
            if (ButtonPanel.this.menuIcon != null) {
                if (dockController == null) {
                    ButtonPanel.this.menuIcon.setManager(null);
                } else {
                    ButtonPanel.this.menuIcon.setManager(dockController.getIcons());
                }
            }
            ButtonPanel.this.set();
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        }

        @Override
        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            int n3 = n;
            while (n3 <= n2) {
                DockAction dockAction = dockActionSource.getDockAction(n3);
                ActionItem actionItem = new ActionItem();
                actionItem.action = dockAction;
                if (this.dockable.getController() != null) {
                    BasicTitleViewItem<JComponent> basicTitleViewItem = ButtonPanel.this.createItemFor(dockAction, this.dockable);
                    actionItem.item = basicTitleViewItem;
                    if (basicTitleViewItem != null) {
                        dockAction.bind(this.dockable);
                        basicTitleViewItem.bind();
                        basicTitleViewItem.setOrientation(ButtonPanel.this.orientation);
                        basicTitleViewItem.setForeground(ButtonPanel.this.getForeground());
                        basicTitleViewItem.setBackground(ButtonPanel.this.getBackground());
                    }
                }
                ButtonPanel.this.actions.add(n3, actionItem);
                ++n3;
            }
            ButtonPanel.this.visibleActions = ButtonPanel.this.actions.size();
            ButtonPanel.this.resetVisibleActions();
            ButtonPanel.this.revalidate();
        }

        @Override
        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            int n3 = n2;
            while (n3 >= n) {
                ActionItem actionItem = (ActionItem)ButtonPanel.this.actions.remove(n3);
                if (actionItem.item != null) {
                    actionItem.item.unbind();
                    actionItem.action.unbind(this.dockable);
                }
                --n3;
            }
            ButtonPanel.this.visibleActions = ButtonPanel.this.actions.size();
            ButtonPanel.this.resetVisibleActions();
            ButtonPanel.this.revalidate();
        }
    }
}

