/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.station.flap.button.ButtonContent;
import bibliothek.gui.dock.station.flap.button.ButtonContentListener;
import bibliothek.gui.dock.util.PropertyValue;

public abstract class ButtonContentValue
extends PropertyValue<ButtonContent>
implements ButtonContentListener {
    private Dockable dockable;
    private ButtonContent theme;
    private boolean showKnob;
    private boolean showIcon;
    private boolean showText;
    private boolean showChildren;
    private boolean showActions;
    private boolean filterActions;

    public ButtonContentValue(ButtonContent buttonContent) {
        super(FlapDockStation.BUTTON_CONTENT);
        this.theme = buttonContent;
    }

    @Override
    protected void valueChanged(ButtonContent buttonContent, ButtonContent buttonContent2) {
        if (this.dockable != null) {
            if (buttonContent != null) {
                buttonContent.removeListener(this.dockable, this);
            }
            if (buttonContent2 != null) {
                buttonContent2.addListener(this.dockable, this);
            }
            this.checkProperties();
        }
    }

    public void setDockable(Dockable dockable) {
        if (this.dockable != dockable) {
            ButtonContent buttonContent = (ButtonContent)this.getValue();
            if (this.dockable != null) {
                this.theme.removeListener(dockable, this);
                if (buttonContent != null) {
                    buttonContent.removeListener(this.dockable, this);
                }
            }
            this.dockable = dockable;
            if (this.dockable != null) {
                this.theme.addListener(dockable, this);
                if (buttonContent != null) {
                    buttonContent.addListener(this.dockable, this);
                }
            }
            this.checkProperties();
        }
    }

    @Override
    public void changed(ButtonContent buttonContent, Dockable dockable) {
        if (this.dockable == dockable && this.getValue() == buttonContent) {
            this.checkProperties();
        }
    }

    private void checkProperties() {
        ButtonContent buttonContent = (ButtonContent)this.getValue();
        if (buttonContent != null && this.dockable != null) {
            boolean bl = false;
            if (this.showKnob != buttonContent.showKnob(this.dockable, this.theme.showKnob(this.dockable, false))) {
                this.showKnob = !this.showKnob;
                bl = true;
            }
            if (this.showIcon != buttonContent.showIcon(this.dockable, this.theme.showIcon(this.dockable, false))) {
                this.showIcon = !this.showIcon;
                bl = true;
            }
            if (this.showText != buttonContent.showText(this.dockable, this.theme.showText(this.dockable, false))) {
                this.showText = !this.showText;
                bl = true;
            }
            if (this.showChildren != buttonContent.showChildren(this.dockable, this.theme.showChildren(this.dockable, false))) {
                this.showChildren = !this.showChildren;
                bl = true;
            }
            if (this.showActions != buttonContent.showActions(this.dockable, this.theme.showActions(this.dockable, false))) {
                this.showActions = !this.showActions;
                bl = true;
            }
            if (this.filterActions != buttonContent.filterActions(this.dockable, this.theme.filterActions(this.dockable, false))) {
                this.filterActions = !this.filterActions;
                bl = true;
            }
            if (bl) {
                this.propertyChanged();
            }
        }
    }

    public boolean isShowKnob() {
        return this.showKnob;
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public boolean isShowChildren() {
        return this.showChildren;
    }

    public boolean isShowActions() {
        return this.showActions;
    }

    public boolean isFilterActions() {
        return this.filterActions;
    }

    protected abstract void propertyChanged();
}

