/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.ButtonContentFilter;
import bibliothek.gui.dock.action.ButtonContentFilterListener;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.AbstractBasicHandler;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Color;
import java.awt.Component;
import java.util.Set;
import javax.swing.JComponent;

public abstract class BasicHandler<D extends StandardDockAction>
extends AbstractBasicHandler<D, BasicButtonModel>
implements BasicTrigger,
BasicTitleViewItem<JComponent> {
    private Listener listener;
    private PropertyValue<ButtonContentFilter> filter = new PropertyValue<ButtonContentFilter>(DockAction.BUTTON_CONTENT_FILTER){

        @Override
        protected void valueChanged(ButtonContentFilter buttonContentFilter, ButtonContentFilter buttonContentFilter2) {
            if (BasicHandler.this.isBound()) {
                if (buttonContentFilter != null) {
                    buttonContentFilter.removeListener(BasicHandler.this.filterListener);
                    buttonContentFilter.uninstall(BasicHandler.this.getDockable(), (DockAction)BasicHandler.this.getAction());
                }
                if (buttonContentFilter2 != null) {
                    buttonContentFilter2.addListener(BasicHandler.this.filterListener);
                    buttonContentFilter2.install(BasicHandler.this.getDockable(), (DockAction)BasicHandler.this.getAction());
                }
            }
            BasicHandler.this.updateText();
        }
    };
    private ButtonContentFilterListener filterListener = new ButtonContentFilterListener(){

        @Override
        public void showTextChanged(ButtonContentFilter buttonContentFilter, Dockable dockable, DockAction dockAction) {
            if (!(dockAction != null && dockAction != BasicHandler.this.getAction() || dockable != null && dockable != BasicHandler.this.getDockable())) {
                BasicHandler.this.updateText();
            }
        }
    };

    public BasicHandler(D d, Dockable dockable) {
        super(d, dockable);
    }

    @Override
    public JComponent getItem() {
        return ((BasicButtonModel)this.getModel()).getOwner();
    }

    @Override
    public void setBackground(Color color) {
        JComponent jComponent = this.getItem();
        if (jComponent != null) {
            ((Component)jComponent).setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        JComponent jComponent = this.getItem();
        if (jComponent != null) {
            ((Component)jComponent).setForeground(color);
        }
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        ((BasicButtonModel)this.getModel()).setOrientation(orientation);
    }

    @Override
    public abstract void triggered();

    @Override
    public void bind() {
        if (this.listener == null) {
            this.listener = this.createListener();
        }
        this.filter.setProperties(this.getDockable().getController());
        this.updateTooltip();
        Object m = this.getModel();
        StandardDockAction standardDockAction = (StandardDockAction)this.getAction();
        Dockable dockable = this.getDockable();
        ActionContentModifier[] actionContentModifierArray = standardDockAction.getIconContexts(dockable);
        int n = actionContentModifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContentModifier actionContentModifier = actionContentModifierArray[n2];
            ((BasicButtonModel)m).setIcon(actionContentModifier, standardDockAction.getIcon(dockable, actionContentModifier));
            ++n2;
        }
        this.updateText();
        ((BasicButtonModel)m).setEnabled(standardDockAction.isEnabled(dockable));
        ((BasicButtonModel)m).setDockableRepresentative(standardDockAction.getDockableRepresentation(dockable));
        standardDockAction.addDockActionListener(this.listener);
        super.bind();
        this.filter.getValue().addListener(this.filterListener);
        this.filter.getValue().install(this.getDockable(), (DockAction)this.getAction());
    }

    @Override
    public void unbind() {
        this.filter.getValue().removeListener(this.filterListener);
        this.filter.getValue().uninstall(this.getDockable(), (DockAction)this.getAction());
        super.unbind();
        this.filter.setProperties((DockController)null);
        ((BasicButtonModel)this.getModel()).setDockableRepresentative(null);
        ((StandardDockAction)this.getAction()).removeDockActionListener(this.listener);
    }

    protected Listener createListener() {
        return new Listener();
    }

    private void updateText() {
        Dockable dockable = this.getDockable();
        StandardDockAction standardDockAction = (StandardDockAction)this.getAction();
        if (this.filter.getValue().showText(dockable, standardDockAction)) {
            ((BasicButtonModel)this.getModel()).setText(standardDockAction.getText(dockable));
        } else {
            ((BasicButtonModel)this.getModel()).setText(null);
        }
    }

    private void updateTooltip() {
        Dockable dockable = this.getDockable();
        StandardDockAction standardDockAction = (StandardDockAction)this.getAction();
        String string = standardDockAction.getTooltipText(dockable);
        if (string == null || string.length() == 0) {
            string = standardDockAction.getText(dockable);
        }
        ((BasicButtonModel)this.getModel()).setToolTipText(string);
    }

    protected class Listener
    implements StandardDockActionListener {
        protected Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (set.contains(dockable)) {
                ((BasicButtonModel)BasicHandler.this.getModel()).setEnabled(standardDockAction.isEnabled(dockable));
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction standardDockAction, ActionContentModifier actionContentModifier, Set<Dockable> set) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (set.contains(dockable)) {
                Object m = BasicHandler.this.getModel();
                if (actionContentModifier == null) {
                    ((BasicButtonModel)m).clearIcons();
                    ActionContentModifier[] actionContentModifierArray = standardDockAction.getIconContexts(dockable);
                    int n = actionContentModifierArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ActionContentModifier actionContentModifier2 = actionContentModifierArray[n2];
                        ((BasicButtonModel)m).setIcon(actionContentModifier2, standardDockAction.getIcon(dockable, actionContentModifier2));
                        ++n2;
                    }
                } else {
                    ((BasicButtonModel)m).setIcon(actionContentModifier, standardDockAction.getIcon(dockable, actionContentModifier));
                }
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (set.contains(dockable)) {
                BasicHandler.this.updateText();
                BasicHandler.this.updateTooltip();
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (set.contains(dockable)) {
                BasicHandler.this.updateTooltip();
            }
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (set.contains(dockable)) {
                ((BasicButtonModel)BasicHandler.this.getModel()).setDockableRepresentative(standardDockAction.getDockableRepresentation(dockable));
            }
        }
    }
}

