/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.ButtonContentFilter;
import bibliothek.gui.dock.action.ButtonContentFilterListener;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.action.dropdown.DropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownView;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DropDownActionListener;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.AbstractBasicHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonTrigger;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.DropDownItemHandle;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownIcon;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class BasicDropDownButtonHandler
extends AbstractBasicHandler<DropDownAction, BasicDropDownButtonModel>
implements BasicDropDownButtonTrigger,
BasicTitleViewItem<JComponent> {
    private DockActionSource source;
    private Listener listener = new Listener();
    private DropDownItemHandle selection;
    private List<DockAction> actions = new ArrayList<DockAction>();
    private Map<DockAction, DropDownItemHandle> items = new HashMap<DockAction, DropDownItemHandle>();
    private JPopupMenu menu = new JPopupMenu();
    private SelectionView selectionView = new SelectionView();
    private ButtonView buttonView = new ButtonView();
    private DropDownFilter filter;
    private DropDownIcon dropDownIcon;
    private PropertyValue<ButtonContentFilter> buttonContentFilter = new PropertyValue<ButtonContentFilter>(DockAction.BUTTON_CONTENT_FILTER){

        @Override
        protected void valueChanged(ButtonContentFilter buttonContentFilter, ButtonContentFilter buttonContentFilter2) {
            if (BasicDropDownButtonHandler.this.isBound()) {
                if (buttonContentFilter != null) {
                    buttonContentFilter.removeListener(BasicDropDownButtonHandler.this.buttonContentFilterListener);
                    buttonContentFilter.uninstall(BasicDropDownButtonHandler.this.getDockable(), (DockAction)BasicDropDownButtonHandler.this.getAction());
                }
                if (buttonContentFilter2 != null) {
                    buttonContentFilter2.addListener(BasicDropDownButtonHandler.this.buttonContentFilterListener);
                    buttonContentFilter2.install(BasicDropDownButtonHandler.this.getDockable(), (DockAction)BasicDropDownButtonHandler.this.getAction());
                }
            }
            BasicDropDownButtonHandler.this.buttonView.updateText();
        }
    };
    private ButtonContentFilterListener buttonContentFilterListener = new ButtonContentFilterListener(){

        @Override
        public void showTextChanged(ButtonContentFilter buttonContentFilter, Dockable dockable, DockAction dockAction) {
            if (!(dockAction != null && dockAction != BasicDropDownButtonHandler.this.getAction() || dockable != null && dockable != BasicDropDownButtonHandler.this.getDockable())) {
                BasicDropDownButtonHandler.this.buttonView.updateText();
            }
        }
    };

    public BasicDropDownButtonHandler(DropDownAction dropDownAction, Dockable dockable) {
        super(dropDownAction, dockable);
    }

    @Override
    public void bind() {
        DropDownAction dropDownAction = (DropDownAction)this.getAction();
        Dockable dockable = this.getDockable();
        if (this.dropDownIcon != null) {
            if (!this.dropDownIcon.isInitialized()) {
                this.dropDownIcon.init(this.getDockable(), (DropDownAction)this.getAction(), this);
            }
            this.dropDownIcon.setController(dockable.getController());
        }
        dropDownAction.bind(dockable);
        this.filter = dropDownAction.getFilter(dockable).createView(dropDownAction, dockable, this.buttonView);
        this.filter.bind();
        this.source = dropDownAction.getSubActions(dockable);
        int n = 0;
        int n2 = this.source.getDockActionCount();
        while (n < n2) {
            DockAction dockAction = this.source.getDockAction(n);
            this.add(n, dockAction);
            ++n;
        }
        this.reset();
        this.selection = this.items.get(dropDownAction.getSelection(dockable));
        if (this.selection != null) {
            this.selection.getView().setView(this.selectionView);
        }
        dropDownAction.addDropDownActionListener(this.listener);
        dropDownAction.addDockActionListener(this.listener);
        this.source.addDockActionSourceListener(this.listener);
        ((BasicDropDownButtonModel)this.getModel()).setEnabled(dropDownAction.isEnabled(dockable));
        this.buttonContentFilter.setProperties(dockable.getController());
        super.bind();
        this.buttonContentFilter.getValue().addListener(this.buttonContentFilterListener);
    }

    @Override
    public void unbind() {
        DropDownAction dropDownAction = (DropDownAction)this.getAction();
        Dockable dockable = this.getDockable();
        if (this.dropDownIcon != null) {
            this.dropDownIcon.setController(null);
        }
        dropDownAction.removeDockActionListener(this.listener);
        dropDownAction.removeDropDownActionListener(this.listener);
        this.source.removeDockActionSourceListener(this.listener);
        int n = this.actions.size() - 1;
        while (n >= 0) {
            this.remove(n);
            --n;
        }
        this.menu.removeAll();
        if (this.selection != null) {
            this.selection.getView().setView(null);
        }
        this.filter.unbind();
        this.filter = null;
        dropDownAction.unbind(dockable);
        this.source = null;
        this.selection = null;
        this.items.clear();
        this.actions.clear();
        this.buttonContentFilter.getValue().removeListener(this.buttonContentFilterListener);
        super.unbind();
        this.buttonContentFilter.setProperties((DockController)null);
        ((BasicDropDownButtonModel)this.getModel()).setDockableRepresentative(null);
    }

    public Icon getDropDownIcon() {
        this.ensureDropDownIcon();
        return this.dropDownIcon;
    }

    public Icon getDisabledDropDownIcon() {
        this.ensureDropDownIcon();
        return this.dropDownIcon.getDisabledIcon();
    }

    private void ensureDropDownIcon() {
        if (this.dropDownIcon == null) {
            this.dropDownIcon = new DropDownIcon();
            if (this.isBound()) {
                this.dropDownIcon.init(this.getDockable(), (DropDownAction)this.getAction(), this);
                this.dropDownIcon.setController(this.getDockable().getController());
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        JComponent jComponent = this.getItem();
        if (jComponent != null) {
            ((Component)jComponent).setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        JComponent jComponent = this.getItem();
        if (jComponent != null) {
            ((Component)jComponent).setForeground(color);
        }
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        ((BasicDropDownButtonModel)this.getModel()).setOrientation(orientation);
    }

    private void add(int n, DockAction dockAction) {
        Dockable dockable = this.getDockable();
        this.actions.add(dockAction);
        DropDownViewItem dropDownViewItem = dockAction.createView(ViewTarget.DROP_DOWN, dockable.getController().getActionViewConverter(), dockable);
        if (dropDownViewItem != null) {
            DropDownItemHandle dropDownItemHandle = new DropDownItemHandle(dockAction, dropDownViewItem, dockable, (DropDownAction)this.getAction());
            dropDownItemHandle.bind();
            this.items.put(dockAction, dropDownItemHandle);
            if (dropDownViewItem.getItem() != null) {
                this.menu.add((Component)dropDownViewItem.getItem());
            }
        }
    }

    private void remove(int n) {
        DockAction dockAction = this.actions.remove(n);
        DropDownItemHandle dropDownItemHandle = this.items.remove(dockAction);
        if (dropDownItemHandle != null) {
            if (dropDownItemHandle.getView().getItem() != null) {
                this.menu.remove((Component)dropDownItemHandle.getView().getItem());
            }
            dropDownItemHandle.unbind();
        }
    }

    @Override
    public JComponent getItem() {
        return ((BasicDropDownButtonModel)this.getModel()).getOwner();
    }

    @Override
    public void triggered() {
        BasicDropDownButtonModel basicDropDownButtonModel = (BasicDropDownButtonModel)this.getModel();
        if (basicDropDownButtonModel.isMouseOverDropDown()) {
            this.popupTriggered();
        } else if (this.selection == null || !basicDropDownButtonModel.isSelectionEnabled() || !this.selection.getView().isTriggerable(true)) {
            this.popupTriggered();
        } else if (this.selection.getView().isTriggerable(true)) {
            this.selection.getView().triggered();
        }
    }

    @Override
    public void popupTriggered() {
        BasicDropDownButtonModel basicDropDownButtonModel = (BasicDropDownButtonModel)this.getModel();
        JComponent jComponent = basicDropDownButtonModel.getOwner();
        if (basicDropDownButtonModel.getOrientation().isHorizontal()) {
            this.menu.show(jComponent, 0, jComponent.getHeight());
        } else {
            this.menu.show(jComponent, jComponent.getWidth(), 0);
        }
    }

    public void updateUI() {
        if (this.menu != null) {
            SwingUtilities.updateComponentTreeUI(this.menu);
        }
    }

    protected ButtonView getButtonView() {
        return this.buttonView;
    }

    protected void reset() {
        ((BasicDropDownButtonModel)this.getModel()).setSelectionEnabled(false);
        if (this.filter != null) {
            this.filter.clearIcons();
            this.filter.setEnabled(true);
            this.filter.setSelected(false);
            this.filter.setText(null);
            this.filter.setTooltip(null);
            this.filter.setDockableRepresentation(null);
        }
        this.update();
    }

    protected void update() {
        if (this.filter != null) {
            this.filter.update(this.selection == null ? null : this.selection.getView());
        }
    }

    protected class ButtonView
    implements DropDownView {
        private String text;

        protected ButtonView() {
        }

        @Override
        public void setIcon(ActionContentModifier actionContentModifier, Icon icon) {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setIcon(actionContentModifier, icon);
        }

        @Override
        public ActionContentModifier[] getIconContexts() {
            return ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).getIconContexts();
        }

        @Override
        public void clearIcons() {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).clearIcons();
        }

        @Override
        public void setEnabled(boolean bl) {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setSelectionEnabled(bl);
        }

        @Override
        public void setSelected(boolean bl) {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setSelected(bl);
        }

        @Override
        public void setText(String string) {
            this.text = string;
            this.updateText();
        }

        public void updateText() {
            if (((ButtonContentFilter)BasicDropDownButtonHandler.this.buttonContentFilter.getValue()).showText(BasicDropDownButtonHandler.this.getDockable(), (DockAction)BasicDropDownButtonHandler.this.getAction())) {
                ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setText(this.text);
            } else {
                ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setText(null);
            }
        }

        @Override
        public void setTooltip(String string) {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setToolTipText(string);
        }

        @Override
        public void setDockableRepresentation(Dockable dockable) {
            if (BasicDropDownButtonHandler.this.isBound()) {
                ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setDockableRepresentative(dockable);
            }
        }
    }

    private class Listener
    implements StandardDockActionListener,
    DropDownActionListener,
    DockActionSourceListener {
        private Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            Dockable dockable = BasicDropDownButtonHandler.this.getDockable();
            if (set.contains(dockable)) {
                ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setEnabled(standardDockAction.isEnabled(dockable));
            }
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicDropDownButtonHandler.this.getDockable())) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction standardDockAction, ActionContentModifier actionContentModifier, Set<Dockable> set) {
            if (set.contains(BasicDropDownButtonHandler.this.getDockable())) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicDropDownButtonHandler.this.getDockable())) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicDropDownButtonHandler.this.getDockable())) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void selectionChanged(DropDownAction dropDownAction, Set<Dockable> set, DockAction dockAction) {
            if (BasicDropDownButtonHandler.this.selection != null) {
                BasicDropDownButtonHandler.this.selection.getView().setView(null);
            }
            BasicDropDownButtonHandler.this.reset();
            BasicDropDownButtonHandler.this.selection = (DropDownItemHandle)BasicDropDownButtonHandler.this.items.get(dockAction);
            if (BasicDropDownButtonHandler.this.selection != null) {
                BasicDropDownButtonHandler.this.selection.getView().setView(BasicDropDownButtonHandler.this.selectionView);
            }
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).changed();
        }

        @Override
        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            int n3 = n;
            while (n3 <= n2) {
                BasicDropDownButtonHandler.this.add(n3, dockActionSource.getDockAction(n3));
                ++n3;
            }
        }

        @Override
        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            int n3 = n2;
            while (n3 >= n) {
                BasicDropDownButtonHandler.this.remove(n3);
                --n3;
            }
        }
    }

    protected class SelectionView
    implements DropDownView {
        protected SelectionView() {
        }

        @Override
        public void setEnabled(boolean bl) {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setSelectionEnabled(bl);
            BasicDropDownButtonHandler.this.filter.setEnabled(bl);
            BasicDropDownButtonHandler.this.update();
        }

        @Override
        public ActionContentModifier[] getIconContexts() {
            return BasicDropDownButtonHandler.this.filter.getIconContexts();
        }

        @Override
        public void clearIcons() {
            BasicDropDownButtonHandler.this.filter.clearIcons();
            BasicDropDownButtonHandler.this.update();
        }

        @Override
        public void setIcon(ActionContentModifier actionContentModifier, Icon icon) {
            BasicDropDownButtonHandler.this.filter.setIcon(actionContentModifier, icon);
            BasicDropDownButtonHandler.this.update();
        }

        @Override
        public void setSelected(boolean bl) {
            BasicDropDownButtonHandler.this.filter.setSelected(bl);
            BasicDropDownButtonHandler.this.update();
        }

        @Override
        public void setText(String string) {
            BasicDropDownButtonHandler.this.filter.setText(string);
            BasicDropDownButtonHandler.this.update();
        }

        @Override
        public void setTooltip(String string) {
            BasicDropDownButtonHandler.this.filter.setTooltip(string);
            BasicDropDownButtonHandler.this.update();
        }

        @Override
        public void setDockableRepresentation(Dockable dockable) {
            BasicDropDownButtonHandler.this.filter.setDockableRepresentation(dockable);
            BasicDropDownButtonHandler.this.update();
        }
    }
}

