/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelListener;
import bibliothek.gui.dock.themes.basic.action.BasicResourceInitializer;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.container.Triple;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class BasicButtonModel {
    private boolean selected = false;
    private Map<ActionContentModifier, Icon> icons = new HashMap<ActionContentModifier, Icon>();
    private Map<ActionContentModifier, Icon> disabledIcons = new HashMap<ActionContentModifier, Icon>();
    private DockActionRepresentative representative;
    private boolean mouseInside = false;
    private boolean mousePressed = false;
    private String text;
    private JComponent owner;
    private DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;
    private BasicTrigger trigger;
    private BasicResourceInitializer initializer;
    private BackgroundPaint background;
    private BackgroundComponent backgroundComponent;
    private List<BasicButtonModelListener> listeners = new ArrayList<BasicButtonModelListener>();
    private Map<String, BorderModifier> borders = new HashMap<String, BorderModifier>();
    private DockController controller;

    public BasicButtonModel(JComponent jComponent, BasicTrigger basicTrigger, BasicResourceInitializer basicResourceInitializer) {
        this(jComponent, basicTrigger, basicResourceInitializer, true);
    }

    public BasicButtonModel(JComponent jComponent, BasicTrigger basicTrigger, BasicResourceInitializer basicResourceInitializer, boolean bl) {
        Object object;
        this.owner = jComponent;
        this.trigger = basicTrigger;
        this.initializer = basicResourceInitializer;
        if (bl) {
            object = new Listener();
            jComponent.addMouseListener((MouseListener)object);
            jComponent.addMouseMotionListener((MouseMotionListener)object);
        }
        if ((object = this.listActions()) != null) {
            InputMap inputMap = jComponent.getInputMap();
            ActionMap actionMap = jComponent.getActionMap();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Triple triple = (Triple)iterator.next();
                inputMap.put((KeyStroke)triple.getA(), triple.getB());
                actionMap.put(triple.getB(), (Action)triple.getC());
            }
        }
    }

    protected List<Triple<KeyStroke, String, Action>> listActions() {
        ArrayList<Triple<KeyStroke, String, Action>> arrayList = new ArrayList<Triple<KeyStroke, String, Action>>();
        Triple<KeyStroke, String, 1> triple = new Triple<KeyStroke, String, 1>();
        triple.setA(KeyStroke.getKeyStroke(32, 0, false));
        triple.setB("button_model_select");
        triple.setC(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicButtonModel.this.setMousePressed(true);
            }
        });
        arrayList.add(triple);
        Triple<KeyStroke, String, 2> triple2 = new Triple<KeyStroke, String, 2>();
        triple2.setA(KeyStroke.getKeyStroke(32, 0, true));
        triple2.setB("button_model_trigger");
        triple2.setC(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BasicButtonModel.this.mousePressed) {
                    BasicButtonModel.this.setMousePressed(false);
                    if (this.isEnabled()) {
                        BasicButtonModel.this.trigger();
                    }
                }
            }
        });
        arrayList.add(triple2);
        return arrayList;
    }

    public void addListener(BasicButtonModelListener basicButtonModelListener) {
        if (basicButtonModelListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.listeners.add(basicButtonModelListener);
    }

    public void setController(DockController dockController) {
        int n;
        Object object;
        if (this.controller != null) {
            object = this.controller;
            this.controller = null;
            BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
            int n2 = basicButtonModelListenerArray.length;
            n = 0;
            while (n < n2) {
                BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n];
                basicButtonModelListener.unbound(this, (DockController)object);
                ++n;
            }
        }
        if (dockController != null) {
            this.controller = dockController;
            BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
            n = basicButtonModelListenerArray.length;
            int n3 = 0;
            while (n3 < n) {
                object = basicButtonModelListenerArray[n3];
                object.bound(this, this.controller);
                ++n3;
            }
        }
    }

    public void removeListener(BasicButtonModelListener basicButtonModelListener) {
        this.listeners.remove(basicButtonModelListener);
    }

    protected BasicButtonModelListener[] listeners() {
        return this.listeners.toArray(new BasicButtonModelListener[this.listeners.size()]);
    }

    public JComponent getOwner() {
        return this.owner;
    }

    public void setBackground(BackgroundPaint backgroundPaint, BackgroundComponent backgroundComponent) {
        if (this.background != backgroundPaint) {
            if (backgroundPaint != null) {
                if (backgroundComponent == null) {
                    throw new IllegalArgumentException("backgroundComponent must not be null");
                }
                if (backgroundComponent.getComponent() != this.getOwner()) {
                    throw new IllegalArgumentException("backgroundComponent must exactly represent 'getOwner()'");
                }
            }
            BackgroundPaint backgroundPaint2 = this.background;
            this.background = backgroundPaint;
            this.backgroundComponent = backgroundComponent;
            BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
            int n = basicButtonModelListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n2];
                basicButtonModelListener.backgroundChanged(this, backgroundPaint2, backgroundPaint);
                ++n2;
            }
        }
    }

    public BackgroundPaint getBackground() {
        return this.background;
    }

    public BackgroundComponent getBackgroundComponent() {
        return this.backgroundComponent;
    }

    public DockAction getAction() {
        if (this.trigger == null) {
            return null;
        }
        return this.trigger.getAction();
    }

    public Dockable getDockable() {
        if (this.trigger == null) {
            return null;
        }
        return this.trigger.getDockable();
    }

    public void setBorder(String string, BorderModifier borderModifier) {
        BorderModifier borderModifier2 = this.borders.get(string);
        if (borderModifier2 != borderModifier) {
            if (borderModifier == null) {
                this.borders.remove(string);
            } else {
                this.borders.put(string, borderModifier);
            }
            BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
            int n = basicButtonModelListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n2];
                basicButtonModelListener.borderChanged(this, string, borderModifier2, borderModifier);
                ++n2;
            }
        }
    }

    public BorderModifier getBorder(String string) {
        if (this.initializer != null) {
            this.initializer.ensureBorder(this, string);
        }
        return this.borders.get(string);
    }

    public void clearIcons() {
        ActionContentModifier[] actionContentModifierArray = this.getIconContexts();
        int n = actionContentModifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContentModifier actionContentModifier = actionContentModifierArray[n2];
            this.setIcon(actionContentModifier, null);
            ++n2;
        }
    }

    public ActionContentModifier[] getIconContexts() {
        return this.icons.keySet().toArray(new ActionContentModifier[this.icons.size()]);
    }

    public void setText(String string) {
        String string2 = this.text;
        this.text = string;
        BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
        int n = basicButtonModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n2];
            basicButtonModelListener.textChanged(this, string2, string);
            ++n2;
        }
        this.changed();
    }

    public String getText() {
        return this.text;
    }

    public void setIcon(ActionContentModifier actionContentModifier, Icon icon) {
        Icon icon2 = this.icons.remove(actionContentModifier);
        if (icon == null) {
            this.icons.remove(actionContentModifier);
        } else {
            this.icons.put(actionContentModifier, icon);
        }
        this.disabledIcons.remove(actionContentModifier);
        BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
        int n = basicButtonModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n2];
            basicButtonModelListener.iconChanged(this, actionContentModifier, icon2, icon);
            ++n2;
        }
        this.changed();
    }

    public void setSelected(boolean bl) {
        if (this.selected != bl) {
            this.selected = bl;
            BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
            int n = basicButtonModelListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n2];
                basicButtonModelListener.selectedStateChanged(this, bl);
                ++n2;
            }
            this.changed();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setEnabled(boolean bl) {
        this.owner.setEnabled(bl);
        if (!bl) {
            this.setMousePressed(false);
        }
        BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
        int n = basicButtonModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n2];
            basicButtonModelListener.enabledStateChanged(this, bl);
            ++n2;
        }
        this.changed();
    }

    public boolean isEnabled() {
        return this.owner.isEnabled();
    }

    public void setToolTipText(String string) {
        String string2 = this.owner.getToolTipText();
        BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
        int n = basicButtonModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n2];
            basicButtonModelListener.tooltipChanged(this, string2, string);
            ++n2;
        }
        this.owner.setToolTipText(string);
    }

    public void setOrientation(DockTitle.Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Orientation must not be null");
        }
        DockTitle.Orientation orientation2 = this.orientation;
        this.orientation = orientation;
        BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
        int n = basicButtonModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n2];
            basicButtonModelListener.orientationChanged(this, orientation2, orientation);
            ++n2;
        }
        this.changed();
    }

    public void setDockableRepresentative(Dockable dockable) {
        if (this.representative != null) {
            this.representative.unbind();
            this.representative = null;
        }
        if (dockable != null) {
            this.representative = new DockActionRepresentative(dockable);
            this.representative.bind();
        }
    }

    public DockTitle.Orientation getOrientation() {
        return this.orientation;
    }

    public void changed() {
        this.owner.repaint();
    }

    public Dimension getMaxIconSize() {
        int n = 0;
        int n2 = 0;
        for (Icon icon : this.icons.values()) {
            n = Math.max(n, icon.getIconWidth());
            n2 = Math.max(n2, icon.getIconHeight());
        }
        return new Dimension(n, n2);
    }

    public Icon getPaintIcon() {
        return this.getPaintIcon(this.isEnabled());
    }

    public Icon getPaintIcon(boolean bl) {
        ActionContentModifier actionContentModifier = bl ? (this.mousePressed ? (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.NONE_PRESSED_HORIZONTAL : ActionContentModifier.NONE_PRESSED_VERTICAL) : (this.mouseInside ? (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.NONE_HOVER_HORIZONTAL : ActionContentModifier.NONE_HOVER_VERTICAL) : (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.NONE_HORIZONTAL : ActionContentModifier.NONE_VERTICAL))) : (this.mousePressed ? (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.DISABLED_PRESSED_HORIZONTAL : ActionContentModifier.DISABLED_PRESSED_VERTICAL) : (this.mouseInside ? (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.DISABLED_HOVER_HORIZONTAL : ActionContentModifier.DISABLED_HOVER_VERTICAL) : (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.DISABLED_HORIZONTAL : ActionContentModifier.DISABLED_VERTICAL)));
        while (actionContentModifier != null) {
            Icon icon = this.icons.get(actionContentModifier);
            if (icon != null) {
                if (!bl && actionContentModifier.isEnabled()) {
                    Icon icon2 = this.disabledIcons.get(actionContentModifier);
                    if (icon2 == null && !this.disabledIcons.containsKey(actionContentModifier)) {
                        icon2 = DockUtilities.disabledIcon(this.owner, icon);
                        this.disabledIcons.put(actionContentModifier, icon2);
                    }
                    if (icon2 != null) {
                        icon = icon2;
                    }
                }
                return icon;
            }
            actionContentModifier = actionContentModifier.getBackup();
        }
        return null;
    }

    protected void setMouseInside(boolean bl) {
        if (this.mouseInside != bl) {
            this.mouseInside = bl;
            BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
            int n = basicButtonModelListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n2];
                basicButtonModelListener.mouseInside(this, bl);
                ++n2;
            }
            this.changed();
        }
    }

    public boolean isMouseInside() {
        return this.mouseInside;
    }

    protected void setMousePressed(boolean bl) {
        if (this.mousePressed != bl) {
            this.mousePressed = bl;
            BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
            int n = basicButtonModelListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n2];
                basicButtonModelListener.mousePressed(this, bl);
                ++n2;
            }
            this.changed();
        }
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    protected void trigger() {
        if (this.trigger != null) {
            this.trigger.triggered();
        }
        BasicButtonModelListener[] basicButtonModelListenerArray = this.listeners();
        int n = basicButtonModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicButtonModelListener basicButtonModelListener = basicButtonModelListenerArray[n2];
            basicButtonModelListener.triggered();
            ++n2;
        }
    }

    private class DockActionRepresentative
    implements DockElementRepresentative,
    DockHierarchyListener {
        private Dockable dockable;
        private DockController controller;

        public DockActionRepresentative(Dockable dockable) {
            this.dockable = dockable;
        }

        public void bind() {
            this.dockable.addDockHierarchyListener(this);
            this.controller = this.dockable.getController();
            if (this.controller != null) {
                this.controller.addRepresentative(this);
            }
        }

        public void unbind() {
            this.dockable.removeDockHierarchyListener(this);
            if (this.controller != null) {
                this.controller.removeRepresentative(this);
                this.controller = null;
            }
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            if (this.controller != null) {
                this.controller.removeRepresentative(this);
                this.controller = null;
            }
            this.controller = this.dockable.getController();
            if (this.controller != null) {
                this.controller.addRepresentative(this);
            }
        }

        @Override
        public void addMouseInputListener(MouseInputListener mouseInputListener) {
            BasicButtonModel.this.getOwner().addMouseListener(mouseInputListener);
            BasicButtonModel.this.getOwner().addMouseMotionListener(mouseInputListener);
        }

        @Override
        public Component getComponent() {
            return BasicButtonModel.this.getOwner();
        }

        @Override
        public DockElement getElement() {
            return this.dockable;
        }

        @Override
        public Point getPopupLocation(Point point, boolean bl) {
            if (bl) {
                return point;
            }
            return null;
        }

        @Override
        public boolean isUsedAsTitle() {
            return false;
        }

        @Override
        public void removeMouseInputListener(MouseInputListener mouseInputListener) {
            BasicButtonModel.this.getOwner().removeMouseListener(mouseInputListener);
            BasicButtonModel.this.getOwner().removeMouseMotionListener(mouseInputListener);
        }

        @Override
        public boolean shouldFocus() {
            return false;
        }

        @Override
        public boolean shouldTransfersFocus() {
            return true;
        }
    }

    private class Listener
    extends MouseInputAdapter {
        private Listener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            BasicButtonModel.this.setMouseInside(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            BasicButtonModel.this.setMouseInside(false);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            boolean bl = BasicButtonModel.this.owner.contains(mouseEvent.getX(), mouseEvent.getY());
            if (bl != BasicButtonModel.this.mouseInside) {
                BasicButtonModel.this.setMouseInside(bl);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicButtonModel.this.mousePressed && mouseEvent.getButton() == 1) {
                BasicButtonModel.this.setMousePressed(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicButtonModel.this.mousePressed && mouseEvent.getButton() == 1) {
                boolean bl = BasicButtonModel.this.owner.contains(mouseEvent.getX(), mouseEvent.getY());
                if (bl && BasicButtonModel.this.isEnabled()) {
                    BasicButtonModel.this.trigger();
                }
                BasicButtonModel.this.setMousePressed(false);
                if (BasicButtonModel.this.mouseInside != bl) {
                    BasicButtonModel.this.setMouseInside(bl);
                }
            }
        }
    }
}

