/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionDockBorder;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionBackgroundComponent;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicResourceInitializer;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPaint;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

public class AbstractBasicHandler<D extends DockAction, M extends BasicButtonModel>
implements BasicResourceInitializer {
    private D action;
    private M model;
    private Dockable dockable;
    private Background background = new Background();
    private Map<String, BorderHandle> borders = new HashMap<String, BorderHandle>();
    private boolean bound = false;

    public AbstractBasicHandler(D d, Dockable dockable) {
        if (d == null) {
            throw new IllegalArgumentException("Action must not be null");
        }
        this.dockable = dockable;
        this.action = d;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public D getAction() {
        return this.action;
    }

    public M getModel() {
        return this.model;
    }

    @Override
    public void ensureBorder(BasicButtonModel basicButtonModel, String string) {
        this.addBorder(string);
    }

    public void addBorder(String string) {
        if (this.borders.get(string) == null) {
            BorderHandle borderHandle = new BorderHandle(string);
            this.borders.put(string, borderHandle);
            if (this.bound) {
                borderHandle.setController(this.dockable.getController());
            }
        }
    }

    public void setModel(M m) {
        this.model = m;
        for (BorderHandle borderHandle : this.borders.values()) {
            if (borderHandle.modifier == null) continue;
            ((BasicButtonModel)m).setBorder(borderHandle.id, borderHandle.modifier);
        }
        if (this.bound) {
            ((BasicButtonModel)m).setController(this.dockable.getController());
        }
    }

    public void bind() {
        if (!this.bound) {
            this.bound = true;
            DockController dockController = this.dockable.getController();
            this.background.setController(dockController);
            for (BorderHandle borderHandle : this.borders.values()) {
                borderHandle.setController(dockController);
            }
            ((BasicButtonModel)this.model).setController(dockController);
        }
    }

    public void unbind() {
        if (this.bound) {
            this.bound = false;
            this.background.setController(null);
            for (BorderHandle borderHandle : this.borders.values()) {
                borderHandle.setController(null);
            }
            ((BasicButtonModel)this.model).setController(null);
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    private class Background
    extends BackgroundAlgorithm
    implements DockActionBackgroundComponent {
        public Background() {
            super(DockActionBackgroundComponent.KIND, "dock.background.action");
        }

        @Override
        public void set(BackgroundPaint backgroundPaint) {
            super.set(backgroundPaint);
            AbstractBasicHandler.this.model.setBackground(this.getPaint(), this);
        }

        @Override
        public DockAction getAction() {
            return AbstractBasicHandler.this.action;
        }

        @Override
        public Dockable getDockable() {
            return AbstractBasicHandler.this.dockable;
        }

        @Override
        public Component getComponent() {
            return AbstractBasicHandler.this.model.getOwner();
        }
    }

    private class BorderHandle
    implements ActionDockBorder {
        private String id;
        private BorderModifier modifier;
        private DockController controller;

        public BorderHandle(String string) {
            this.id = string;
        }

        public void setController(DockController dockController) {
            if (this.controller != null) {
                this.controller.getThemeManager().remove(this);
            }
            this.controller = dockController;
            if (this.controller == null) {
                this.set(null);
            } else {
                this.controller.getThemeManager().add(this.id, ActionDockBorder.KIND, ThemeManager.BORDER_MODIFIER_TYPE, this);
            }
        }

        @Override
        public void set(BorderModifier borderModifier) {
            if (this.modifier != borderModifier) {
                this.modifier = borderModifier;
                if (AbstractBasicHandler.this.model != null) {
                    AbstractBasicHandler.this.model.setBorder(this.id, borderModifier);
                }
            }
        }

        @Override
        public DockAction getAction() {
            return AbstractBasicHandler.this.action;
        }

        @Override
        public Dockable getDockable() {
            return AbstractBasicHandler.this.dockable;
        }
    }
}

