/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class TabDisplayerCombinerTarget
implements DisplayerCombinerTarget {
    private int index = -1;
    private DockableDisplayer displayer;
    private StackDockComponent stack;

    public TabDisplayerCombinerTarget(DockableDisplayer dockableDisplayer, StackDockComponent stackDockComponent, CombinerSource combinerSource, Enforcement enforcement) {
        this.displayer = dockableDisplayer;
        this.stack = stackDockComponent;
        Point point = combinerSource.getMousePosition();
        if (point != null && stackDockComponent != null && stackDockComponent.getTabCount() == 1) {
            point = SwingUtilities.convertPoint(dockableDisplayer.getDockable().getComponent(), point, stackDockComponent.getComponent());
            Rectangle rectangle = stackDockComponent.getBoundsAt(0);
            if (stackDockComponent.getDockTabPlacement().isHorizontal()) {
                if (rectangle.y <= point.y && rectangle.y + rectangle.height >= point.y) {
                    this.index = rectangle.x + rectangle.width / 2 < point.x ? 1 : 0;
                } else if (enforcement.getForce() > 0.9f) {
                    this.index = 1;
                }
            } else if (rectangle.x <= point.x && rectangle.x + rectangle.width >= point.x) {
                this.index = rectangle.y + rectangle.height / 2 < point.y ? 1 : 0;
            } else if (enforcement.getForce() > 0.9f) {
                this.index = 1;
            }
        }
    }

    public boolean isValid() {
        return this.index >= 0;
    }

    public int getIndex() {
        return this.index;
    }

    public Dockable getTarget() {
        return this.displayer.getDockable();
    }

    @Override
    public Dockable execute(CombinerSource combinerSource) {
        DockStation dockStation = combinerSource.getParent();
        PlaceholderMap placeholderMap = combinerSource.getPlaceholders();
        StackDockStation stackDockStation = new StackDockStation(dockStation.getTheme());
        stackDockStation.setController(dockStation.getController());
        if (placeholderMap != null) {
            stackDockStation.setPlaceholders(placeholderMap);
        }
        if (this.index == 1) {
            stackDockStation.drop(combinerSource.getOld(), false);
            stackDockStation.drop(combinerSource.getNew(), false);
        } else {
            stackDockStation.drop(combinerSource.getNew(), false);
            stackDockStation.drop(combinerSource.getOld(), false);
        }
        return stackDockStation;
    }

    @Override
    public void paint(Graphics graphics, Component component, StationPaint stationPaint, Rectangle rectangle, Rectangle rectangle2) {
        rectangle2 = new Rectangle(rectangle2);
        Rectangle rectangle3 = this.stack.getBoundsAt(0);
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(this.stack.getComponent(), point, component);
        rectangle3.x += point.x;
        rectangle3.y += point.y;
        int n = 0;
        switch (this.stack.getDockTabPlacement()) {
            case TOP_OF_DOCKABLE: {
                n = rectangle3.y + rectangle3.height - rectangle2.y;
                if (n <= 0) break;
                rectangle2.height -= n;
                rectangle2.y += n;
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                n = rectangle2.y + rectangle2.height - rectangle3.y;
                if (n <= 0) break;
                rectangle2.height -= n;
                break;
            }
            case LEFT_OF_DOCKABLE: {
                n = rectangle3.x + rectangle3.width - rectangle2.x;
                if (n <= 0) break;
                rectangle2.width -= n;
                rectangle2.x += n;
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                n = rectangle2.x + rectangle2.width - rectangle3.x;
                if (n <= 0) break;
                rectangle2.width -= n;
            }
        }
        stationPaint.drawInsertion(graphics, this.displayer.getStation(), rectangle, rectangle2);
        if (this.stack.getDockTabPlacement().isHorizontal()) {
            if (this.index == 0) {
                stationPaint.drawInsertionLine(graphics, this.displayer.getStation(), rectangle3.x, rectangle3.y, rectangle3.x, rectangle3.y + rectangle3.height);
            } else {
                stationPaint.drawInsertionLine(graphics, this.displayer.getStation(), rectangle3.x + rectangle3.width, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height);
            }
        } else if (this.index == 0) {
            stationPaint.drawInsertionLine(graphics, this.displayer.getStation(), rectangle3.x, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y);
        } else {
            stationPaint.drawInsertionLine(graphics, this.displayer.getStation(), rectangle3.x, rectangle3.y + rectangle3.height, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height);
        }
    }

    public void paint(Graphics graphics, StationPaint stationPaint) {
        Dockable dockable = this.displayer.getDockable();
        Point point = new Point(0, 0);
        SwingUtilities.convertPoint(this.displayer.getComponent(), point, dockable.getComponent());
        stationPaint.drawInsertion(graphics, this.displayer.getStation(), null, new Rectangle(point, dockable.getComponent().getSize()));
    }
}

