/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.station.stack.StackDockComponentListener;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.StackDockComponentRepresentative;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.TabContentFilterListener;
import bibliothek.gui.dock.station.stack.action.DockActionDistributor;
import bibliothek.gui.dock.station.stack.action.DockActionDistributorSource;
import bibliothek.gui.dock.station.stack.tab.TabContentFilter;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecorator;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecoratorListener;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class TabDecorator
implements BasicDockableDisplayerDecorator,
StackDockComponentParent {
    private StackDockComponentListener componentListener = new StackDockComponentListener(){

        @Override
        public void tabChanged(StackDockComponent stackDockComponent, Dockable dockable) {
            TabDecorator.this.fireMoveableElementChanged();
        }

        @Override
        public void selectionChanged(StackDockComponent stackDockComponent) {
        }
    };
    private PropertyValue<StackDockComponentFactory> factory = new PropertyValue<StackDockComponentFactory>(StackDockStation.COMPONENT_FACTORY){

        @Override
        protected void valueChanged(StackDockComponentFactory stackDockComponentFactory, StackDockComponentFactory stackDockComponentFactory2) {
            TabContentFilter tabContentFilter = null;
            if (TabDecorator.this.filter != null) {
                tabContentFilter = (TabContentFilter)TabDecorator.this.filter.getValue();
            }
            if (TabDecorator.this.component != null) {
                TabDecorator.this.component.setController(null);
                TabDecorator.this.component.removeAll();
                if (tabContentFilter != null) {
                    tabContentFilter.uninstall(TabDecorator.this.component);
                }
                TabDecorator.this.component.removeStackDockComponentListener(TabDecorator.this.componentListener);
                TabDecorator.this.component = null;
            }
            if (stackDockComponentFactory2 != null) {
                TabDecorator.this.component = stackDockComponentFactory2.create(TabDecorator.this);
                TabDecorator.this.component.setDockTabPlacement((TabPlacement)((Object)TabDecorator.this.tabPlacement.getValue()));
                if (tabContentFilter != null) {
                    tabContentFilter.install(TabDecorator.this.component);
                }
                TabDecorator.this.component.setController(TabDecorator.this.controller);
                TabDecorator.this.component.addStackDockComponentListener(TabDecorator.this.componentListener);
                if (TabDecorator.this.dockable != null) {
                    TabDecorator.this.component.addTab(TabDecorator.this.dockable.getTitleText(), TabDecorator.this.dockable.getTitleIcon(), TabDecorator.this.representation, TabDecorator.this.dockable);
                    TabDecorator.this.component.setSelectedIndex(0);
                }
            }
            TabDecorator.this.representative.setComponent(TabDecorator.this.component);
            TabDecorator.this.fireMoveableElementChanged();
        }
    };
    private PropertyValue<TabPlacement> tabPlacement = new PropertyValue<TabPlacement>(StackDockStation.TAB_PLACEMENT){

        @Override
        protected void valueChanged(TabPlacement tabPlacement, TabPlacement tabPlacement2) {
            if (TabDecorator.this.component != null) {
                TabDecorator.this.component.setDockTabPlacement(tabPlacement2);
            }
        }
    };
    private PropertyValue<TabContentFilter> filter = new PropertyValue<TabContentFilter>(StackDockStation.TAB_CONTENT_FILTER){

        @Override
        protected void valueChanged(TabContentFilter tabContentFilter, TabContentFilter tabContentFilter2) {
            if (tabContentFilter != null) {
                if (TabDecorator.this.component != null) {
                    tabContentFilter.uninstall(TabDecorator.this.component);
                }
                tabContentFilter.removeListener(TabDecorator.this.filterListener);
            }
            if (tabContentFilter2 != null) {
                if (TabDecorator.this.component != null) {
                    tabContentFilter2.install(TabDecorator.this.component);
                }
                tabContentFilter2.addListener(TabDecorator.this.filterListener);
            }
            TabDecorator.this.updateTabContent();
        }
    };
    private DockableListener dockableListener = new DockableAdapter(){

        @Override
        public void titleTextChanged(Dockable dockable, String string, String string2) {
            TabDecorator.this.updateTabContent();
        }

        @Override
        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            TabDecorator.this.updateTabContent();
        }

        @Override
        public void titleToolTipChanged(Dockable dockable, String string, String string2) {
            TabDecorator.this.updateTabContent();
        }
    };
    private TabContentFilterListener filterListener = new TabContentFilterListener(){

        @Override
        public void contentChanged() {
            TabDecorator.this.updateTabContent();
        }

        @Override
        public void contentChanged(StackDockComponent stackDockComponent) {
            if (stackDockComponent == TabDecorator.this.component) {
                TabDecorator.this.updateTabContent();
            }
        }

        @Override
        public void contentChanged(StackDockStation stackDockStation) {
        }

        @Override
        public void contentChanged(Dockable dockable) {
            if (dockable == TabDecorator.this.dockable) {
                TabDecorator.this.updateTabContent();
            }
        }
    };
    private DockController controller;
    private Dockable dockable;
    private DockStation station;
    private StackDockComponent component;
    private Component representation;
    private StackDockComponentRepresentative representative = new StackDockComponentRepresentative();
    private DockActionDistributorSource actions;
    private List<BasicDockableDisplayerDecoratorListener> listeners = new ArrayList<BasicDockableDisplayerDecoratorListener>(2);

    public TabDecorator(DockStation dockStation, PropertyKey<DockActionDistributor> propertyKey) {
        this.station = dockStation;
        if (propertyKey != null) {
            this.actions = new DockActionDistributorSource(DockActionDistributor.Target.TITLE, propertyKey);
        }
    }

    @Override
    public void addDecoratorListener(BasicDockableDisplayerDecoratorListener basicDockableDisplayerDecoratorListener) {
        this.listeners.add(basicDockableDisplayerDecoratorListener);
    }

    @Override
    public void removeDecoratorListener(BasicDockableDisplayerDecoratorListener basicDockableDisplayerDecoratorListener) {
        this.listeners.remove(basicDockableDisplayerDecoratorListener);
    }

    protected void fireMoveableElementChanged() {
        BasicDockableDisplayerDecoratorListener[] basicDockableDisplayerDecoratorListenerArray = this.listeners.toArray(new BasicDockableDisplayerDecoratorListener[this.listeners.size()]);
        int n = basicDockableDisplayerDecoratorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicDockableDisplayerDecoratorListener basicDockableDisplayerDecoratorListener = basicDockableDisplayerDecoratorListenerArray[n2];
            basicDockableDisplayerDecoratorListener.moveableElementChanged(this);
            ++n2;
        }
    }

    @Override
    public DockStation getStackDockParent() {
        return this.station;
    }

    @Override
    public int indexOf(Dockable dockable) {
        if (this.dockable == dockable) {
            return 0;
        }
        return -1;
    }

    public StackDockComponent getStackComponent() {
        return this.component;
    }

    @Override
    public void setDockable(Component component, Dockable dockable) {
        if (this.dockable != null) {
            this.dockable.removeDockableListener(this.dockableListener);
        }
        this.dockable = dockable;
        this.representation = component;
        if (this.dockable != null) {
            this.dockable.addDockableListener(this.dockableListener);
        }
        if (this.component != null) {
            this.component.removeAll();
            if (dockable != null) {
                this.component.addTab(null, null, this.representation, dockable);
                this.component.setSelectedIndex(0);
                this.updateTabContent();
            }
        }
        this.representative.setTarget(dockable);
        if (this.actions != null) {
            this.actions.setDockable(dockable);
        }
        this.fireMoveableElementChanged();
    }

    @Override
    public DockElementRepresentative getMoveableElement() {
        if (this.component.getTabCount() > 0) {
            return this.component.getTabAt(0);
        }
        return null;
    }

    private void updateTabContent() {
        if (this.dockable != null && this.component != null && this.component.getTabCount() == 1) {
            TabContent tabContent = new TabContent(this.dockable.getTitleIcon(), this.dockable.getTitleText(), this.dockable.getTitleToolTip());
            TabContentFilter tabContentFilter = this.filter.getValue();
            if (tabContentFilter != null) {
                tabContent = tabContentFilter.filter(tabContent, this.component, this.dockable);
            }
            if (tabContent == null) {
                this.component.setTitleAt(0, null);
                this.component.setIconAt(0, null);
                this.component.setTooltipAt(0, null);
            } else {
                this.component.setTitleAt(0, tabContent.getTitle());
                this.component.setIconAt(0, tabContent.getIcon());
                this.component.setTooltipAt(0, tabContent.getTooltip());
            }
        }
    }

    @Override
    public void setController(DockController dockController) {
        this.controller = dockController;
        this.factory.setProperties(dockController);
        this.tabPlacement.setProperties(dockController);
        this.filter.setProperties(dockController);
        if (this.component != null) {
            this.component.setController(dockController);
        }
        this.representative.setController(dockController);
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            return null;
        }
        return this.component.getComponent();
    }

    @Override
    public DockActionSource getActionSuggestion() {
        return this.actions;
    }

    @Override
    public Insets getDockableInsets() {
        if (this.representation == null) {
            return new Insets(0, 0, 0, 0);
        }
        Point point = new Point(0, 0);
        SwingUtilities.convertPoint(this.representation, point, this.getComponent());
        Dimension dimension = this.getComponent().getSize();
        Dimension dimension2 = this.representation.getSize();
        return new Insets(point.y, point.x, dimension.height - dimension2.height - point.y, dimension.width - dimension2.width - point.x);
    }
}

