/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;

public class DisplayerContentPane
extends ConfiguredBackgroundPanel {
    private Component title;
    private Component dockable;
    private DockableDisplayer.Location location;

    public DisplayerContentPane() {
        super(null, Transparency.DEFAULT);
    }

    public void setTitleLocation(DockableDisplayer.Location location) {
        this.location = location;
        this.revalidate();
    }

    public void setDockable(Component component) {
        if (this.dockable != null) {
            this.remove(this.dockable);
        }
        this.dockable = component;
        if (this.dockable != null) {
            this.add(this.dockable);
        }
    }

    public void setTitle(Component component) {
        if (this.title != null) {
            this.remove(this.title);
        }
        this.title = component;
        if (this.title != null) {
            this.add(this.title);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Cloneable cloneable;
        Dimension dimension;
        if (this.title == null && this.dockable != null) {
            dimension = this.dockable.getPreferredSize();
        } else if (this.dockable == null && this.title != null) {
            dimension = this.title.getPreferredSize();
        } else if (this.dockable == null && this.title == null) {
            dimension = new Dimension(0, 0);
        } else if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
            cloneable = this.title.getPreferredSize();
            dimension = this.dockable.getPreferredSize();
            dimension = new Dimension(dimension.width + ((Dimension)cloneable).width, Math.max(dimension.height, ((Dimension)cloneable).height));
        } else {
            cloneable = this.title.getPreferredSize();
            dimension = this.dockable.getPreferredSize();
            dimension = new Dimension(Math.max(((Dimension)cloneable).width, dimension.width), ((Dimension)cloneable).height + dimension.height);
        }
        cloneable = this.getInsets();
        if (cloneable != null) {
            dimension = new Dimension(dimension.width + cloneable.left + cloneable.right, dimension.height + cloneable.top + cloneable.bottom);
        }
        return dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        Cloneable cloneable;
        Dimension dimension;
        if (this.title == null && this.dockable != null) {
            dimension = this.dockable.getMaximumSize();
        } else if (this.dockable == null && this.title != null) {
            dimension = this.title.getMaximumSize();
        } else if (this.dockable == null && this.title == null) {
            dimension = new Dimension(0, 0);
        } else if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
            cloneable = this.title.getMaximumSize();
            dimension = this.dockable.getMaximumSize();
            dimension = new Dimension(dimension.width + ((Dimension)cloneable).width, Math.max(dimension.height, ((Dimension)cloneable).height));
        } else {
            cloneable = this.title.getMaximumSize();
            dimension = this.dockable.getMaximumSize();
            dimension = new Dimension(Math.max(((Dimension)cloneable).width, dimension.width), ((Dimension)cloneable).height + dimension.height);
        }
        cloneable = this.getInsets();
        if (cloneable != null) {
            dimension = new Dimension(dimension.width + cloneable.left + cloneable.right, dimension.height + cloneable.top + cloneable.bottom);
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        Cloneable cloneable;
        Dimension dimension;
        if (this.title == null && this.dockable != null) {
            dimension = this.dockable.getMinimumSize();
        } else if (this.dockable == null && this.title != null) {
            dimension = this.title.getMinimumSize();
        } else if (this.dockable == null && this.title == null) {
            dimension = new Dimension(0, 0);
        } else if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
            cloneable = this.title.getMinimumSize();
            dimension = this.dockable.getMinimumSize();
            dimension = new Dimension(dimension.width + ((Dimension)cloneable).width, Math.max(dimension.height, ((Dimension)cloneable).height));
        } else {
            cloneable = this.title.getMinimumSize();
            dimension = this.dockable.getMinimumSize();
            dimension = new Dimension(Math.max(((Dimension)cloneable).width, dimension.width), ((Dimension)cloneable).height + dimension.height);
        }
        cloneable = this.getInsets();
        if (cloneable != null) {
            dimension = new Dimension(dimension.width + cloneable.left + cloneable.right, dimension.height + cloneable.top + cloneable.bottom);
        }
        return dimension;
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        if (this.title == null && this.dockable == null) {
            return;
        }
        n3 = Math.max(0, n3);
        n4 = Math.max(0, n4);
        if (this.title == null) {
            this.dockable.setBounds(n, n2, n3, n4);
        } else if (this.dockable == null) {
            this.title.setBounds(n, n2, n3, n4);
        } else {
            Dimension dimension = this.title.getPreferredSize();
            int n5 = dimension.width;
            int n6 = dimension.height;
            if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
                n5 = Math.min(n5, n3);
                n6 = n4;
            } else {
                n5 = n3;
                n6 = Math.min(n6, n4);
            }
            if (this.location == DockableDisplayer.Location.LEFT) {
                this.title.setBounds(n, n2, n5, n6);
                this.dockable.setBounds(n + n5, n2, n3 - n5, n4);
            } else if (this.location == DockableDisplayer.Location.RIGHT) {
                this.title.setBounds(n + n3 - n5, n2, n5, n6);
                this.dockable.setBounds(n, n2, n3 - n5, n6);
            } else if (this.location == DockableDisplayer.Location.BOTTOM) {
                this.title.setBounds(n, n2 + n4 - n6, n5, n6);
                this.dockable.setBounds(n, n2, n5, n4 - n6);
            } else {
                this.title.setBounds(n, n2, n5, n6);
                this.dockable.setBounds(n, n2 + n6, n5, n4 - n6);
            }
        }
    }
}

