/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class BasicStationTitle
extends AbstractDockTitle {
    private int preferredDimension = 20;
    private TitleColor activeColor = new BasicStationTitleColor("title.station.active", Color.WHITE);
    private TitleColor activeTextColor = new BasicStationTitleColor("title.station.active.text", Color.BLACK);
    private TitleColor inactiveColor = new BasicStationTitleColor("title.station.inactive", Color.WHITE);
    private TitleColor inactiveTextColor = new BasicStationTitleColor("title.station.inactive.text", Color.DARK_GRAY);
    private TitleColor disabledColor = new BasicStationTitleColor("title.station.disabled", Color.WHITE);

    public BasicStationTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        super(dockable, dockTitleVersion);
        this.setBorder("dock.border.title.station.basic", BorderFactory.createBevelBorder(0));
        this.setActive(false);
        this.addColor(this.activeColor);
        this.addColor(this.activeTextColor);
        this.addColor(this.inactiveColor);
        this.addColor(this.inactiveTextColor);
        this.addColor(this.disabledColor);
    }

    @Override
    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        Color color = jComponent.getBackground();
        Insets insets = jComponent.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = jComponent.getWidth() - insets.left - insets.right;
        int n4 = jComponent.getHeight() - insets.top - insets.bottom;
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Color color2 = Colors.brighter(color, 0.1);
        Color color3 = Colors.darker(color, 0.1);
        if (n3 > n4) {
            if (n4 >= 6) {
                int n5 = 0;
                while (n5 < 3) {
                    this.drawLineHorizontal(graphics, n, n4 * (n5 + 1) / 4, n3, color2, color3);
                    ++n5;
                }
            } else if (n4 >= 4) {
                this.drawLineHorizontal(graphics, n, n2, n3, color2, color3);
                this.drawLineHorizontal(graphics, n, n2 + n4 - 2, n3, color2, color3);
            } else if (n4 >= 2) {
                this.drawLineHorizontal(graphics, n, n2, n3, color2, color3);
            }
        } else if (n3 >= 6) {
            int n6 = 0;
            while (n6 < 3) {
                this.drawLineVertical(graphics, n3 * (n6 + 1) / 4, n2, n4, color2, color3);
                ++n6;
            }
        } else if (n3 >= 4) {
            this.drawLineVertical(graphics, n, n2, n4, color2, color3);
            this.drawLineVertical(graphics, n + n3 - 2, n2, n4, color2, color3);
        } else if (n3 >= 2) {
            this.drawLineVertical(graphics, n, n2, n4, color2, color3);
        }
    }

    public int getPreferredDimension() {
        return this.preferredDimension;
    }

    public void setPreferredDimension(int n) {
        this.preferredDimension = n;
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        this.updateColors();
    }

    @Override
    protected void setDisabled(boolean bl) {
        super.setDisabled(bl);
        this.updateColors();
    }

    protected void updateColors() {
        if (this.isDisabled()) {
            if (this.inactiveTextColor != null && this.disabledColor != null) {
                this.setBackground(this.disabledColor.color());
                this.setForeground(this.inactiveTextColor.color());
            }
        } else if (this.isActive()) {
            if (this.activeTextColor != null && this.activeColor != null) {
                this.setBackground(this.activeColor.color());
                this.setForeground(this.activeTextColor.color());
            }
        } else if (this.inactiveColor != null && this.inactiveTextColor != null) {
            this.setBackground(this.inactiveColor.color());
            this.setForeground(this.inactiveTextColor.color());
        }
        this.repaint();
    }

    public Color getActiveColor() {
        return (Color)this.activeColor.value();
    }

    public Color getInactiveColor() {
        return (Color)this.inactiveColor.value();
    }

    public Color getDisabledColor() {
        return (Color)this.disabledColor.value();
    }

    public Color getActiveTextColor() {
        return (Color)this.activeTextColor.value();
    }

    public Color getInactiveTextColor() {
        return (Color)this.inactiveTextColor.value();
    }

    public void setActiveColor(Color color) {
        this.activeColor.setValue(color);
        this.updateColors();
    }

    public void setActiveTextColor(Color color) {
        this.activeTextColor.setValue(color);
        this.updateColors();
    }

    public void setInactiveColor(Color color) {
        this.inactiveColor.setValue(color);
        this.updateColors();
    }

    public void setDisabledColor(Color color) {
        this.disabledColor.setValue(color);
        this.updateColors();
    }

    public void setInactiveTextColor(Color color) {
        this.inactiveTextColor.setValue(color);
        this.updateColors();
    }

    public TitleColor getActiveTitleColor() {
        return this.activeColor;
    }

    public TitleColor getDisabledTitleColor() {
        return this.disabledColor;
    }

    public TitleColor getActiveTextTitleColor() {
        return this.activeTextColor;
    }

    public TitleColor getInactiveTitleColor() {
        return this.inactiveColor;
    }

    public TitleColor getInactiveTextTitleColor() {
        return this.inactiveTextColor;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(this.preferredDimension, dimension.width), Math.max(this.preferredDimension, dimension.height));
    }

    private void drawLineHorizontal(Graphics graphics, int n, int n2, int n3, Color color, Color color2) {
        graphics.setColor(color);
        graphics.drawLine(n + 2, n2, n + n3 - 4, n2);
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n2 + 1, n + n3 - 4, n2 + 1);
    }

    private void drawLineVertical(Graphics graphics, int n, int n2, int n3, Color color, Color color2) {
        graphics.setColor(color);
        graphics.drawLine(n, n2 + 2, n, n2 + n3 - 4);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + n3 - 4);
    }

    private class BasicStationTitleColor
    extends TitleColor {
        public BasicStationTitleColor(String string, Color color) {
            super(string, BasicStationTitle.this, color);
        }

        @Override
        protected void changed(Color color, Color color2) {
            BasicStationTitle.this.updateColors();
        }
    }
}

