/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanFactory;
import bibliothek.gui.dock.station.span.SpanMode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Timer;

public class BasicSpanFactory
implements SpanFactory {
    private int duration;
    private int minSpeed;
    private Timer timer;
    private Collection<BasicSpan> ticking = new HashSet<BasicSpan>();

    public BasicSpanFactory(int n, int n2) {
        this.setDuration(n);
        this.setMinSpeed(n2);
        this.timer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicSpanFactory.this.tick();
            }
        });
        this.timer.setRepeats(true);
        this.timer.setCoalesce(true);
        this.timer.setDelay(20);
        this.timer.setInitialDelay(0);
    }

    public void setDuration(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("duration must be at least 0 milliseconds");
        }
        this.duration = n;
    }

    public void setMinSpeed(int n) {
        this.minSpeed = n;
    }

    public int getMinSpeed() {
        return this.minSpeed;
    }

    @Override
    public Span create(SpanCallback spanCallback) {
        return new BasicSpan(spanCallback);
    }

    private synchronized void start(BasicSpan basicSpan) {
        if (this.ticking.isEmpty()) {
            this.ticking.add(basicSpan);
            this.timer.start();
        } else {
            this.ticking.add(basicSpan);
        }
    }

    private synchronized void stop(BasicSpan basicSpan) {
        this.ticking.remove(basicSpan);
        if (this.ticking.isEmpty()) {
            this.timer.stop();
        }
    }

    private synchronized void tick() {
        long l = System.nanoTime();
        BasicSpan[] basicSpanArray = this.ticking.toArray(new BasicSpan[this.ticking.size()]);
        int n = basicSpanArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicSpan basicSpan = basicSpanArray[n2];
            basicSpan.tick(l);
            ++n2;
        }
    }

    private class BasicSpan
    implements Span {
        private SpanCallback callback;
        private Map<SpanMode, Integer> sizes = new HashMap<SpanMode, Integer>(2);
        private SpanMode currentMode;
        private int sizeStart;
        private int sizeTarget;
        private int animationDuration = -1;
        private long animationStart = -1L;
        private int duration;

        public BasicSpan(SpanCallback spanCallback) {
            this.callback = spanCallback;
        }

        @Override
        public void mutate(SpanMode spanMode) {
            this.sizeStart = this.getSize();
            this.sizeTarget = this.getSize(spanMode);
            this.duration = BasicSpanFactory.this.duration;
            if (this.sizeStart != this.sizeTarget) {
                if (BasicSpanFactory.this.minSpeed > 0) {
                    this.duration = Math.min(this.duration, 1000 * Math.abs(this.sizeStart - this.sizeTarget) / BasicSpanFactory.this.minSpeed);
                }
                this.animationDuration = 0;
                this.animationStart = -1L;
                BasicSpanFactory.this.start(this);
            }
        }

        @Override
        public void set(SpanMode spanMode) {
            BasicSpanFactory.this.stop(this);
            this.animationDuration = -1;
            this.sizeTarget = this.getSize(spanMode);
            this.callback.resized();
        }

        private int getSize(SpanMode spanMode) {
            Integer n = this.sizes.get(spanMode);
            if (n == null) {
                return spanMode.getSize();
            }
            return n;
        }

        @Override
        public void configureSize(SpanMode spanMode, int n) {
            this.sizes.put(spanMode, n);
            if (spanMode == this.currentMode) {
                this.set(spanMode);
            }
        }

        public void tick(long l) {
            if (this.animationStart == -1L) {
                this.animationStart = l;
            }
            this.animationDuration = (int)((l - this.animationStart) / 1000000L);
            if (this.animationDuration >= this.duration) {
                this.animationDuration = -1;
                BasicSpanFactory.this.stop(this);
            }
            this.callback.resized();
        }

        @Override
        public int getSize() {
            if (this.animationDuration == -1) {
                return this.sizeTarget;
            }
            double d = (double)this.animationDuration / (double)this.duration;
            if (d > 1.0) {
                d = 1.0;
            }
            d = 2.0 * (1.0 - d) * d + d * d;
            return (int)((double)this.sizeStart * (1.0 - d) + (double)this.sizeTarget * d);
        }
    }
}

