/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.dockable.TrueMovingImage;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.title.UpdatingTitleMovingImage;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class BasicMovingImageFactory
implements DockableMovingImageFactory {
    @Override
    public MovingImage create(DockController dockController, DockTitle dockTitle) {
        if (dockTitle.getOrigin() != null) {
            DockTitleVersion dockTitleVersion = dockTitle.getOrigin();
            return new UpdatingTitleMovingImage(dockTitle.getDockable(), dockTitleVersion, dockTitle.getOrientation());
        }
        Component component = dockTitle.getComponent();
        BufferedImage bufferedImage = new BufferedImage(Math.max(1, component.getWidth()), Math.max(1, component.getHeight()), 2);
        Graphics graphics = bufferedImage.getGraphics();
        component.paint(graphics);
        graphics.dispose();
        TrueMovingImage trueMovingImage = new TrueMovingImage();
        trueMovingImage.setImage(bufferedImage);
        return trueMovingImage;
    }

    @Override
    public MovingImage create(DockController dockController, Dockable dockable) {
        DockTitleVersion dockTitleVersion = dockController.getDockTitleManager().getVersion("theme");
        return new UpdatingTitleMovingImage(dockable, dockTitleVersion, DockTitle.Orientation.FREE_HORIZONTAL);
    }
}

