/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.displayer.DisplayerBackgroundComponent;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.displayer.DisplayerDockBorder;
import bibliothek.gui.dock.displayer.DisplayerFocusTraversalPolicy;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.displayer.SingleTabDecider;
import bibliothek.gui.dock.event.SingleTabDeciderListener;
import bibliothek.gui.dock.focus.DockFocusTraversalPolicy;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.stack.action.DockActionDistributor;
import bibliothek.gui.dock.station.stack.action.DockActionDistributorSource;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecorator;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecoratorListener;
import bibliothek.gui.dock.themes.basic.DisplayerContentPane;
import bibliothek.gui.dock.themes.basic.MinimalDecorator;
import bibliothek.gui.dock.themes.basic.TabDecorator;
import bibliothek.gui.dock.themes.basic.TabDisplayerCombinerTarget;
import bibliothek.gui.dock.themes.border.BorderForwarder;
import bibliothek.gui.dock.title.ActionsDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class BasicDockableDisplayer
extends ConfiguredBackgroundPanel
implements DockableDisplayer {
    private Dockable dockable;
    private DockTitle title;
    private DockableDisplayer.Location location;
    private DockStation station;
    private DockController controller;
    private Hints hints = new Hints();
    private boolean respectBorderHint = false;
    private boolean defaultBorderHint = true;
    private boolean singleTabShowInnerBorder = true;
    private boolean singleTabShowOuterBorder = true;
    private boolean tabInside = false;
    private List<DockableDisplayerListener> listeners = new ArrayList<DockableDisplayerListener>();
    private Background background = new Background();
    private DisplayerBorder baseBorder;
    private DisplayerBorder contentBorder;
    private SingleTabDeciderListener singleTabListener = new SingleTabDeciderListener(){

        @Override
        public void showSingleTabChanged(SingleTabDecider singleTabDecider, Dockable dockable) {
            if (dockable == BasicDockableDisplayer.this.dockable) {
                BasicDockableDisplayer.this.updateDecorator();
            }
        }
    };
    private PropertyValue<SingleTabDecider> decider = new PropertyValue<SingleTabDecider>(SingleTabDecider.SINGLE_TAB_DECIDER){

        @Override
        protected void valueChanged(SingleTabDecider singleTabDecider, SingleTabDecider singleTabDecider2) {
            if (singleTabDecider != null) {
                singleTabDecider.removeSingleTabDeciderListener(BasicDockableDisplayer.this.singleTabListener);
            }
            if (singleTabDecider2 != null) {
                singleTabDecider2.addSingleTabDeciderListener(BasicDockableDisplayer.this.singleTabListener);
            }
            BasicDockableDisplayer.this.updateDecorator();
        }
    };
    private BasicDockableDisplayerDecorator decorator;
    private BasicDockableDisplayerDecoratorListener decoratorListener = new BasicDockableDisplayerDecoratorListener(){

        @Override
        public void moveableElementChanged(BasicDockableDisplayerDecorator basicDockableDisplayerDecorator) {
            BasicDockableDisplayer.this.fireMoveableElementChanged();
        }
    };
    private boolean singleTabShowing;
    private boolean pendingForcedUpdateDecorator = false;
    private boolean stacked = false;
    private DisplayerContentPane content;
    private DockComponentRootHandler rootHandler;

    public BasicDockableDisplayer(DockStation dockStation) {
        this(dockStation, null, null);
    }

    public BasicDockableDisplayer(DockStation dockStation, Dockable dockable, DockTitle dockTitle) {
        this(dockStation, dockable, dockTitle, DockableDisplayer.Location.TOP);
    }

    public BasicDockableDisplayer(DockStation dockStation, Dockable dockable, DockTitle dockTitle, DockableDisplayer.Location location) {
        super((LayoutManager)new GridLayout(1, 1), Transparency.DEFAULT);
        this.init(dockStation, dockable, dockTitle, location);
    }

    protected BasicDockableDisplayer(DockStation dockStation, boolean bl) {
        super((LayoutManager)new GridLayout(1, 1), Transparency.DEFAULT);
        if (bl) {
            this.init(dockStation, null, null, DockableDisplayer.Location.TOP);
        }
    }

    protected void init(DockStation dockStation, Dockable dockable, DockTitle dockTitle, DockableDisplayer.Location location) {
        this.content = this.createContentPane();
        this.content.setBackground(this.background);
        this.setDecorator(new MinimalDecorator());
        this.setBackground(this.background);
        this.setTitleLocation(location);
        this.setStation(dockStation);
        this.setDockable(dockable);
        this.setTitle(dockTitle);
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new DockFocusTraversalPolicy(new DisplayerFocusTraversalPolicy(this), true));
        this.baseBorder = new DisplayerBorder(this, "basic.base");
        this.contentBorder = new DisplayerBorder(this.content, "basic.content");
        this.rootHandler = this.createRootHandler();
        this.rootHandler.addRoot(this.getComponent());
    }

    protected DockComponentRootHandler createRootHandler() {
        return new DockComponentRootHandler(this){

            @Override
            protected DockComponentRootHandler.TraverseResult shouldTraverse(Component component) {
                DockTitle dockTitle = BasicDockableDisplayer.this.getTitle();
                if (dockTitle != null && dockTitle.getComponent() == component) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE;
                }
                Dockable dockable = BasicDockableDisplayer.this.getDockable();
                if (dockable != null && dockable.getComponent() == component) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE;
                }
                return DockComponentRootHandler.TraverseResult.INCLUDE_CHILDREN;
            }
        };
    }

    protected DisplayerContentPane createContentPane() {
        return new DisplayerContentPane();
    }

    protected void setDecorator(BasicDockableDisplayerDecorator basicDockableDisplayerDecorator) {
        if (basicDockableDisplayerDecorator == null) {
            throw new IllegalArgumentException("decorator must not be null");
        }
        if (this.decorator != null) {
            this.decorator.setDockable(null, null);
            this.decorator.setController(null);
            this.decorator.removeDecoratorListener(this.decoratorListener);
        }
        this.decorator = basicDockableDisplayerDecorator;
        this.decorator.addDecoratorListener(this.decoratorListener);
        this.decorator.setController(this.controller);
        this.resetDecorator();
        if (this.title != null) {
            this.title.changed(new ActionsDockTitleEvent(this.dockable, basicDockableDisplayerDecorator.getActionSuggestion()));
        }
        this.fireMoveableElementChanged();
        this.revalidate();
        this.repaint();
    }

    protected void updateDecorator() {
        this.updateDecorator(false);
    }

    protected void updateDecorator(boolean bl) {
        if (bl) {
            this.pendingForcedUpdateDecorator = true;
        }
        if (this.dockable != null && this.station != null) {
            boolean bl2 = this.decider.getValue().showSingleTab(this.station, this.dockable);
            if (this.pendingForcedUpdateDecorator || bl2 != this.singleTabShowing) {
                this.pendingForcedUpdateDecorator = false;
                this.singleTabShowing = bl2;
                if (this.singleTabShowing) {
                    this.setDecorator(this.createTabDecorator());
                } else if (this.isStacked()) {
                    this.setDecorator(this.createStackedDecorator());
                } else {
                    this.setDecorator(this.createMinimalDecorator());
                }
            }
            this.updateBorder();
        }
    }

    public boolean isSingleTabShowing() {
        return this.singleTabShowing;
    }

    public void setStacked(boolean bl) {
        if (this.stacked != bl) {
            this.stacked = bl;
            this.updateDecorator(true);
        }
    }

    public boolean isStacked() {
        return this.stacked;
    }

    protected BasicDockableDisplayerDecorator createMinimalDecorator() {
        return new MinimalDecorator();
    }

    protected BasicDockableDisplayerDecorator createStackedDecorator() {
        return this.createMinimalDecorator();
    }

    protected BasicDockableDisplayerDecorator createStackedDecorator(PropertyKey<DockActionDistributor> propertyKey) {
        return new MinimalDecorator(propertyKey){
            private DockActionDistributorSource source;
            {
                this.source = new DockActionDistributorSource(DockActionDistributor.Target.TITLE, propertyKey);
            }

            @Override
            public void setDockable(Component component, Dockable dockable) {
                super.setDockable(component, dockable);
                this.source.setDockable(dockable);
            }

            @Override
            public DockActionSource getActionSuggestion() {
                return this.source;
            }
        };
    }

    protected BasicDockableDisplayerDecorator createTabDecorator() {
        return new TabDecorator(this.station, null);
    }

    @Override
    public void setController(DockController dockController) {
        this.rootHandler.setController(null);
        this.controller = dockController;
        this.decider.setProperties(dockController);
        this.decorator.setController(dockController);
        this.background.setController(dockController);
        this.baseBorder.setController(dockController);
        this.contentBorder.setController(dockController);
        this.resetDecorator();
        this.rootHandler.setController(dockController);
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public void setComponentConfiguration(DockComponentConfiguration dockComponentConfiguration) {
        this.rootHandler.setConfiguration(dockComponentConfiguration);
    }

    @Override
    public DockComponentConfiguration getComponentConfiguration() {
        return this.rootHandler.getConfiguration();
    }

    @Override
    public void addDockableDisplayerListener(DockableDisplayerListener dockableDisplayerListener) {
        this.listeners.add(dockableDisplayerListener);
    }

    @Override
    public void removeDockableDisplayerListener(DockableDisplayerListener dockableDisplayerListener) {
        this.listeners.remove(dockableDisplayerListener);
    }

    protected DockableDisplayerListener[] listeners() {
        return this.listeners.toArray(new DockableDisplayerListener[this.listeners.size()]);
    }

    protected void fireMoveableElementChanged() {
        DockableDisplayerListener[] dockableDisplayerListenerArray = this.listeners();
        int n = dockableDisplayerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableDisplayerListener dockableDisplayerListener = dockableDisplayerListenerArray[n2];
            dockableDisplayerListener.moveableElementChanged(this);
            ++n2;
        }
    }

    @Override
    public void setStation(DockStation dockStation) {
        this.station = dockStation;
        this.updateDecorator();
    }

    @Override
    public DockStation getStation() {
        return this.station;
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public void setDockable(Dockable dockable) {
        if (this.dockable != null) {
            this.dockable.configureDisplayerHints(null);
        }
        this.hints.setShowBorderHint(null);
        this.dockable = dockable;
        this.updateDecorator();
        this.resetDecorator();
        if (dockable != null) {
            this.dockable.configureDisplayerHints(this.hints);
        }
        this.revalidate();
    }

    protected void resetDecorator() {
        this.removeAll();
        if (this.tabInside) {
            if (this.dockable == null) {
                this.content.setDockable(null);
                this.decorator.setDockable(null, null);
            } else {
                this.content.setDockable(null);
                this.decorator.setDockable(this.getComponent(this.dockable), this.dockable);
                this.content.setDockable(this.decorator.getComponent());
            }
            this.add(this.content);
        } else {
            if (this.dockable == null) {
                this.content.setDockable(null);
            } else {
                this.content.setDockable(this.getComponent(this.dockable));
            }
            this.decorator.setDockable(this.content, this.dockable);
            Component component = this.decorator.getComponent();
            if (component != null) {
                this.add(component);
            }
        }
    }

    @Override
    public DockableDisplayer.Location getTitleLocation() {
        return this.location;
    }

    @Override
    public void setTitleLocation(DockableDisplayer.Location location) {
        if (location == null) {
            location = DockableDisplayer.Location.TOP;
        }
        this.location = location;
        this.content.setTitleLocation(location);
        if (this.title != null) {
            this.title.setOrientation(this.orientation(location));
        }
        this.revalidate();
    }

    protected DockTitle.Orientation orientation(DockableDisplayer.Location location) {
        switch (location) {
            case TOP: {
                return DockTitle.Orientation.NORTH_SIDED;
            }
            case BOTTOM: {
                return DockTitle.Orientation.SOUTH_SIDED;
            }
            case LEFT: {
                return DockTitle.Orientation.WEST_SIDED;
            }
            case RIGHT: {
                return DockTitle.Orientation.EAST_SIDED;
            }
        }
        return null;
    }

    @Override
    public DockTitle getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(DockTitle dockTitle) {
        this.title = dockTitle;
        if (dockTitle == null) {
            this.content.setTitle(null);
        } else {
            this.content.setTitle(this.getComponent(dockTitle));
        }
        if (dockTitle != null) {
            dockTitle.setOrientation(this.orientation(this.location));
            if (this.decorator != null) {
                dockTitle.changed(new ActionsDockTitleEvent(this.dockable, this.decorator.getActionSuggestion()));
            }
        }
        this.fireMoveableElementChanged();
        this.revalidate();
    }

    @Override
    public DockElementRepresentative getMoveableElement() {
        DockElementRepresentative dockElementRepresentative;
        if (this.title != null) {
            return this.title;
        }
        if (this.decorator != null && (dockElementRepresentative = this.decorator.getMoveableElement()) != null) {
            return dockElementRepresentative;
        }
        return this.getDockable();
    }

    @Override
    public Point getTitleCenter() {
        DockElementRepresentative dockElementRepresentative = this.getMoveableElement();
        if (dockElementRepresentative == null) {
            return null;
        }
        Component component = dockElementRepresentative.getComponent();
        if (!SwingUtilities.isDescendingFrom(component, this.getComponent())) {
            return null;
        }
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(component, point, this.getComponent());
        Dimension dimension = component.getSize();
        return new Point(point.x + dimension.width / 2, point.y + dimension.height / 2);
    }

    protected Component getComponent(Dockable dockable) {
        return dockable.getComponent();
    }

    protected Component getComponent(DockTitle dockTitle) {
        return dockTitle.getComponent();
    }

    @Override
    public boolean titleContains(int n, int n2) {
        DockTitle dockTitle = this.getTitle();
        if (dockTitle == null) {
            return false;
        }
        Component component = this.getComponent(dockTitle);
        Point point = new Point(n, n2);
        point = SwingUtilities.convertPoint(this, point, component);
        point.x -= component.getX();
        point.y -= component.getY();
        return component.contains(point);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Insets getDockableInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Insets insets2 = this.decorator.getDockableInsets();
        insets.left += insets2.left;
        insets.right += insets2.right;
        insets.top += insets2.top;
        insets.bottom += insets2.bottom;
        if (this.title == null && this.dockable == null) {
            return insets;
        }
        if (this.title == null) {
            return insets;
        }
        if (this.dockable != null) {
            Dimension dimension = this.getComponent(this.title).getPreferredSize();
            if (this.location == DockableDisplayer.Location.LEFT) {
                insets.left += dimension.width;
            } else if (this.location == DockableDisplayer.Location.RIGHT) {
                insets.right += dimension.width;
            } else if (this.location == DockableDisplayer.Location.BOTTOM) {
                insets.bottom += dimension.height;
            } else {
                insets.top += dimension.height;
            }
        }
        return insets;
    }

    protected Hints getHints() {
        return this.hints;
    }

    public void setRespectBorderHint(boolean bl) {
        if (this.respectBorderHint != bl) {
            this.respectBorderHint = bl;
            this.updateBorder();
        }
    }

    public boolean isRespectBorderHint() {
        return this.respectBorderHint;
    }

    public void setDefaultBorderHint(boolean bl) {
        if (this.defaultBorderHint != bl) {
            this.defaultBorderHint = bl;
            this.updateBorder();
        }
    }

    public boolean getDefaultBorderHint() {
        return this.defaultBorderHint;
    }

    public void setSingleTabShowInnerBorder(boolean bl) {
        this.singleTabShowInnerBorder = bl;
        this.updateBorder();
    }

    public boolean isSingleTabShowInnerBorder() {
        return this.singleTabShowInnerBorder;
    }

    public void setSingleTabShowOuterBorder(boolean bl) {
        this.singleTabShowOuterBorder = bl;
        this.updateBorder();
    }

    public boolean isSingleTabShowOuterBorder() {
        return this.singleTabShowOuterBorder;
    }

    public boolean isTabInside() {
        return this.tabInside;
    }

    public void setTabInside(boolean bl) {
        this.tabInside = bl;
        this.resetDecorator();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateBorder();
    }

    protected void updateBorder() {
        if (this.singleTabShowing) {
            if (this.singleTabShowInnerBorder) {
                this.setContentBorder(this.getDefaultBorder());
            } else {
                this.setContentBorder(null);
            }
            if (this.singleTabShowOuterBorder) {
                this.setBaseBorder(this.getDefaultBorder());
            } else {
                this.setBaseBorder(null);
            }
        } else {
            this.setContentBorder(null);
            if (this.respectBorderHint) {
                boolean bl = this.hints.getShowBorderHint();
                if (bl) {
                    this.setBaseBorder(this.getDefaultBorder());
                } else {
                    this.setBaseBorder(null);
                }
            } else if (this.defaultBorderHint) {
                this.setBaseBorder(this.getDefaultBorder());
            } else {
                this.setBaseBorder(null);
            }
        }
    }

    public void setBaseBorder(Border border) {
        if (this.baseBorder != null) {
            this.baseBorder.setBorder(border);
        }
    }

    public void setContentBorder(Border border) {
        if (this.contentBorder != null) {
            this.contentBorder.setBorder(border);
        }
    }

    @Override
    public DisplayerCombinerTarget prepareCombination(CombinerSource combinerSource, Enforcement enforcement) {
        TabDisplayerCombinerTarget tabDisplayerCombinerTarget;
        if (this.decorator instanceof TabDecorator && (tabDisplayerCombinerTarget = new TabDisplayerCombinerTarget(this, ((TabDecorator)this.decorator).getStackComponent(), combinerSource, enforcement)).isValid()) {
            return tabDisplayerCombinerTarget;
        }
        return null;
    }

    protected Border getDefaultBorder() {
        return BorderFactory.createBevelBorder(0);
    }

    private class Background
    extends BackgroundAlgorithm
    implements DisplayerBackgroundComponent {
        public Background() {
            super(DisplayerBackgroundComponent.KIND, "dock.background.displayer");
        }

        @Override
        public Component getComponent() {
            return BasicDockableDisplayer.this;
        }

        @Override
        public DockableDisplayer getDisplayer() {
            return BasicDockableDisplayer.this;
        }
    }

    protected class DisplayerBorder
    extends BorderForwarder
    implements DisplayerDockBorder {
        public DisplayerBorder(JComponent jComponent, String string) {
            super(DisplayerDockBorder.KIND, "dock.border.displayer." + string, jComponent);
        }

        @Override
        public DockableDisplayer getDisplayer() {
            return BasicDockableDisplayer.this;
        }
    }

    protected class Hints
    implements DockableDisplayerHints {
        private Boolean border;

        protected Hints() {
        }

        @Override
        public DockStation getStation() {
            return BasicDockableDisplayer.this.station;
        }

        @Override
        public void setShowBorderHint(Boolean bl) {
            if (this.border != bl) {
                this.border = bl;
                BasicDockableDisplayer.this.updateBorder();
            }
        }

        public boolean getShowBorderHint() {
            if (this.border != null) {
                return this.border;
            }
            return BasicDockableDisplayer.this.defaultBorderHint;
        }
    }
}

