/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class BasicDockTitle
extends AbstractDockTitle {
    public static final DockTitleFactory FACTORY = new DockTitleFactory(){

        @Override
        public void install(DockTitleRequest dockTitleRequest) {
        }

        @Override
        public void uninstall(DockTitleRequest dockTitleRequest) {
        }

        @Override
        public void request(DockTitleRequest dockTitleRequest) {
            dockTitleRequest.answer(new BasicDockTitle(dockTitleRequest.getTarget(), dockTitleRequest.getVersion()));
        }
    };
    private TitleColor activeLeftColor = new BasicTitleColor("title.active.left", Color.BLACK);
    private TitleColor inactiveLeftColor = new BasicTitleColor("title.inactive.left", Color.DARK_GRAY);
    private TitleColor disabledLeftColor = new BasicTitleColor("title.disabled.left", Color.LIGHT_GRAY);
    private TitleColor activeRightColor = new BasicTitleColor("title.active.right", Color.DARK_GRAY);
    private TitleColor inactiveRightColor = new BasicTitleColor("title.inactive.right", Color.LIGHT_GRAY);
    private TitleColor disabledRightColor = new BasicTitleColor("title.disabled.right", Color.LIGHT_GRAY);
    private TitleColor activeTextColor = new BasicTitleColor("title.active.text", Color.WHITE);
    private TitleColor inactiveTextColor = new BasicTitleColor("title.inactive.text", Color.BLACK);
    private GradientPaint gradient;

    public BasicDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        this(dockable, dockTitleVersion, true);
    }

    protected BasicDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion, boolean bl) {
        super(dockable, dockTitleVersion);
        this.setActive(false);
        this.addColor(this.activeLeftColor);
        this.addColor(this.inactiveLeftColor);
        this.addColor(this.disabledLeftColor);
        this.addColor(this.activeRightColor);
        this.addColor(this.inactiveRightColor);
        this.addColor(this.disabledRightColor);
        this.addColor(this.activeTextColor);
        this.addColor(this.inactiveTextColor);
    }

    @Override
    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.gradient = null;
    }

    @Override
    public void validate() {
        this.gradient = null;
        super.validate();
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        this.gradient = null;
        super.setOrientation(orientation);
    }

    @Override
    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.gradient == null) {
            this.gradient = this.isDisabled() ? this.getGradient((Color)this.disabledLeftColor.value(), (Color)this.disabledRightColor.value(), jComponent) : (this.isActive() ? this.getGradient((Color)this.activeLeftColor.value(), (Color)this.activeRightColor.value(), jComponent) : this.getGradient((Color)this.inactiveLeftColor.value(), (Color)this.inactiveRightColor.value(), jComponent));
        }
        graphics2D.setPaint(this.gradient);
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    protected GradientPaint getGradient(Color color, Color color2, Component component) {
        GradientPaint gradientPaint;
        if (this.getOrientation().isHorizontal()) {
            float f = (float)component.getHeight() / 2.0f;
            gradientPaint = new GradientPaint(0.0f, f, color, component.getWidth(), f, color2, false);
        } else {
            float f = (float)component.getWidth() / 2.0f;
            gradientPaint = new GradientPaint(f, 0.0f, color, f, component.getHeight(), color2, false);
        }
        return gradientPaint;
    }

    public Color getActiveLeftColor() {
        return (Color)this.activeLeftColor.value();
    }

    public TitleColor getActiveLeftTitleColor() {
        return this.activeLeftColor;
    }

    public void setActiveLeftColor(Color color) {
        this.activeLeftColor.setValue(color);
    }

    public void setActiveLeftColorId(String string) {
        this.activeLeftColor.setId(string);
    }

    public Color getActiveRightColor() {
        return (Color)this.activeRightColor.value();
    }

    public TitleColor getActiveRightTitleColor() {
        return this.activeRightColor;
    }

    public void setActiveRightColor(Color color) {
        this.activeRightColor.setValue(color);
    }

    public void setActiveRightColorId(String string) {
        this.activeRightColor.setId(string);
    }

    public Color getActiveTextColor() {
        return (Color)this.activeTextColor.value();
    }

    public TitleColor getActiveTextTitleColor() {
        return this.activeTextColor;
    }

    public void setActiveTextColor(Color color) {
        this.activeTextColor.setValue(color);
    }

    public void setActiveTextColorId(String string) {
        this.activeTextColor.setId(string);
    }

    public Color getDisabledLeftColor() {
        return (Color)this.disabledLeftColor.value();
    }

    public TitleColor getDisabledLeftTitleColor() {
        return this.disabledLeftColor;
    }

    public void setDisabledLeftColor(Color color) {
        this.disabledLeftColor.setValue(color);
    }

    public void setDisabledLeftColorId(String string) {
        this.disabledLeftColor.setId(string);
    }

    public Color getDisabledRightColor() {
        return (Color)this.disabledRightColor.value();
    }

    public TitleColor getDisabledRightTitleColor() {
        return this.disabledRightColor;
    }

    public void setDisabledRightColor(Color color) {
        this.disabledRightColor.setValue(color);
    }

    public void setDisabledRightColorId(String string) {
        this.disabledRightColor.setId(string);
    }

    public Color getInactiveLeftColor() {
        return (Color)this.inactiveLeftColor.value();
    }

    public TitleColor getInactiveLeftTitleColor() {
        return this.inactiveLeftColor;
    }

    public void setInactiveLeftColor(Color color) {
        this.inactiveLeftColor.setValue(color);
    }

    public void setInactiveLeftColorId(String string) {
        this.inactiveLeftColor.setId(string);
    }

    public Color getInactiveRightColor() {
        return (Color)this.inactiveRightColor.value();
    }

    public TitleColor getInactiveRightTitleColor() {
        return this.inactiveRightColor;
    }

    public void setInactiveRightColor(Color color) {
        this.inactiveRightColor.setValue(color);
    }

    public void setInactiveRightColorId(String string) {
        this.activeRightColor.setId(string);
    }

    public Color getInactiveTextColor() {
        return (Color)this.inactiveTextColor.value();
    }

    public TitleColor getInactiveTextTitleColor() {
        return this.inactiveTextColor;
    }

    public void setInactiveTextColor(Color color) {
        this.inactiveTextColor.setValue(color);
    }

    public void setInactiveTextColorId(String string) {
        this.inactiveTextColor.setId(string);
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        this.updateColors();
    }

    @Override
    protected void setDisabled(boolean bl) {
        super.setDisabled(bl);
        this.updateColors();
    }

    protected void updateColors() {
        this.gradient = null;
        if (this.isActive()) {
            if (this.activeTextColor != null) {
                this.setForeground((Color)this.activeTextColor.value());
            }
        } else if (this.inactiveTextColor != null) {
            this.setForeground((Color)this.inactiveTextColor.value());
        }
        this.repaint();
    }

    private class BasicTitleColor
    extends TitleColor {
        public BasicTitleColor(String string, Color color) {
            super(string, BasicDockTitle.this, color);
        }

        @Override
        protected void changed(Color color, Color color2) {
            BasicDockTitle.this.gradient = null;
            BasicDockTitle.this.updateColors();
        }
    }
}

