/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.dockable.DefaultDockablePerspective;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.stack.StackDockPerspective;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class BasicCombiner
implements Combiner {
    @Override
    public CombinerTarget prepare(final CombinerSource combinerSource, Enforcement enforcement) {
        DisplayerCombinerTarget displayerCombinerTarget;
        DockableDisplayer dockableDisplayer = combinerSource.getOldDisplayer();
        if (dockableDisplayer != null && (displayerCombinerTarget = dockableDisplayer.prepareCombination(combinerSource, enforcement)) != null) {
            return new DisplayerTarget(displayerCombinerTarget);
        }
        if (enforcement.getForce() < 0.5f) {
            return null;
        }
        return new CombinerTarget(){

            @Override
            public void paint(Graphics graphics, Component component, StationPaint stationPaint, Rectangle rectangle, Rectangle rectangle2) {
                stationPaint.drawInsertion(graphics, combinerSource.getParent(), rectangle, rectangle2);
            }

            @Override
            public DisplayerCombinerTarget getDisplayerCombination() {
                return null;
            }
        };
    }

    @Override
    public Dockable combine(CombinerSource combinerSource, CombinerTarget combinerTarget) {
        if (combinerTarget instanceof DisplayerTarget) {
            return ((DisplayerTarget)combinerTarget).execute(combinerSource);
        }
        DockStation dockStation = combinerSource.getParent();
        PlaceholderMap placeholderMap = combinerSource.getPlaceholders();
        StackDockStation stackDockStation = new StackDockStation(dockStation.getTheme());
        stackDockStation.setController(dockStation.getController());
        if (placeholderMap != null) {
            stackDockStation.setPlaceholders(placeholderMap);
        }
        stackDockStation.drop(combinerSource.getOld());
        stackDockStation.drop(combinerSource.getNew());
        return stackDockStation;
    }

    @Override
    public void aside(AsideRequest asideRequest) {
        int n;
        PlaceholderMap placeholderMap = asideRequest.getLayout();
        StackDockPerspective stackDockPerspective = new StackDockPerspective();
        if (placeholderMap != null) {
            stackDockPerspective.setPlaceholders(placeholderMap);
        }
        if (stackDockPerspective.getItemCount() == 0) {
            this.insert(stackDockPerspective, asideRequest.getLocation());
        }
        if ((n = this.indexOf(stackDockPerspective, asideRequest.getLocation())) == -1) {
            n = stackDockPerspective.getDockableCount();
            if (n == 0) {
                n = 1;
            }
        } else {
            ++n;
        }
        n = Math.min(stackDockPerspective.getItemCount(), n);
        if (asideRequest.getPlaceholder() != null) {
            stackDockPerspective.insertPlaceholder(n, asideRequest.getPlaceholder(), PlaceholderList.Level.BASE);
        }
        asideRequest.answer(new StackDockProperty(n, asideRequest.getPlaceholder()), stackDockPerspective.getPlaceholders());
    }

    private void insert(StackDockPerspective stackDockPerspective, DockableProperty dockableProperty) {
        Path path = dockableProperty instanceof StackDockProperty ? ((StackDockProperty)dockableProperty).getPlaceholder() : null;
        if (path == null) {
            stackDockPerspective.add(new DefaultDockablePerspective());
        } else {
            stackDockPerspective.addPlaceholder(path);
        }
    }

    private int indexOf(StackDockPerspective stackDockPerspective, DockableProperty dockableProperty) {
        if (dockableProperty instanceof StackDockProperty) {
            StackDockProperty stackDockProperty = (StackDockProperty)dockableProperty;
            int n = stackDockPerspective.indexOf(stackDockProperty.getPlaceholder());
            if (n != -1) {
                return n;
            }
            return stackDockProperty.getIndex();
        }
        return -1;
    }

    private class DisplayerTarget
    implements CombinerTarget {
        private DisplayerCombinerTarget operation;

        public DisplayerTarget(DisplayerCombinerTarget displayerCombinerTarget) {
            this.operation = displayerCombinerTarget;
        }

        public Dockable execute(CombinerSource combinerSource) {
            return this.operation.execute(combinerSource);
        }

        @Override
        public void paint(Graphics graphics, Component component, StationPaint stationPaint, Rectangle rectangle, Rectangle rectangle2) {
            this.operation.paint(graphics, component, stationPaint, rectangle, rectangle2);
        }

        @Override
        public DisplayerCombinerTarget getDisplayerCombination() {
            return this.operation;
        }
    }
}

