/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.FilteredDockActionSource;
import bibliothek.gui.dock.action.MultiDockActionSource;
import bibliothek.gui.dock.action.StationChildrenActionSource;
import bibliothek.gui.dock.station.flap.button.ButtonContent;
import bibliothek.gui.dock.station.flap.button.ButtonContentFilter;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonContentValue;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.DockTitleEvent;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class BasicButtonDockTitle
extends AbstractDockTitle {
    protected final int KNOB_SIZE = 10;
    private boolean mousePressed = false;
    private boolean selected = false;
    protected ButtonContentValue behavior;
    private PropertyValue<ButtonContentFilter> connector = new PropertyValue<ButtonContentFilter>(FlapDockStation.BUTTON_CONTENT_FILTER){

        @Override
        protected void valueChanged(ButtonContentFilter buttonContentFilter, ButtonContentFilter buttonContentFilter2) {
            if (BasicButtonDockTitle.this.behavior != null) {
                BasicButtonDockTitle.this.updateActionSource(true);
            }
        }
    };
    private boolean showChildren = false;
    private boolean showActions = false;
    private boolean filterActions = false;
    private TitleColor activeColor = new BasicTitleColor("title.flap.active", null);
    private TitleColor activeTextColor = new BasicTitleColor("title.flap.active.text", null);
    private TitleColor inactiveColor = new BasicTitleColor("title.flap.inactive", null);
    private TitleColor inactiveTextColor = new BasicTitleColor("title.flap.inactive.text", null);
    private TitleColor selectedColor = new BasicTitleColor("title.flap.selected", null);
    private TitleColor selectedTextColor = new BasicTitleColor("title.flap.selected.text", null);
    private TitleColor knobActiveHighlightColor = new BasicTitleColor("title.flap.active.knob.highlight", null);
    private TitleColor knobActiveShadowColor = new BasicTitleColor("title.flap.active.knob.shadow", null);
    private TitleColor knobInactiveHighlightColor = new BasicTitleColor("title.flap.inactive.knob.highlight", null);
    private TitleColor knobInactiveShadowColor = new BasicTitleColor("title.flap.inactive.knob.shadow", null);
    private TitleColor knobSelectedHighlightColor = new BasicTitleColor("title.flap.selected.knob.highlight", null);
    private TitleColor knobSelectedShadowColor = new BasicTitleColor("title.flap.selected.knob.shadow", null);
    private MultiDockActionSource allActionsSource = new MultiDockActionSource(new DockActionSource[0]);

    public BasicButtonDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        this.behavior = new ButtonContentValue(new ButtonContent(ButtonContent.TRUE, ButtonContent.TRUE, ButtonContent.IF_DOCKABLE, ButtonContent.IF_STATION, ButtonContent.TRUE, ButtonContent.TRUE)){

            @Override
            protected void propertyChanged() {
                BasicButtonDockTitle.this.updateContent();
            }
        };
        this.init(dockable, dockTitleVersion, false);
        this.changeBorder();
        this.addMouseInputListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                BasicButtonDockTitle.this.mousePressed = (mouseEvent.getModifiersEx() & 0x400) != 0;
                BasicButtonDockTitle.this.changeBorder();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                BasicButtonDockTitle.this.mousePressed = (mouseEvent.getModifiersEx() & 0x400) != 0;
                BasicButtonDockTitle.this.changeBorder();
            }
        });
        this.addColor(this.activeColor);
        this.addColor(this.activeTextColor);
        this.addColor(this.inactiveColor);
        this.addColor(this.inactiveTextColor);
        this.addColor(this.selectedColor);
        this.addColor(this.selectedTextColor);
        this.addColor(this.knobActiveHighlightColor);
        this.addColor(this.knobActiveShadowColor);
        this.addColor(this.knobInactiveHighlightColor);
        this.addColor(this.knobInactiveShadowColor);
        this.addColor(this.knobSelectedHighlightColor);
        this.addColor(this.knobSelectedShadowColor);
        this.allActionsSource.setSeparateSources(true);
        this.updateContent();
    }

    @Override
    public void bind() {
        DockTitleVersion dockTitleVersion = this.getOrigin();
        if (dockTitleVersion != null) {
            this.connector.setProperties(dockTitleVersion.getController());
            this.behavior.setProperties(dockTitleVersion.getController());
        }
        this.behavior.setDockable(this.getDockable());
        super.bind();
    }

    @Override
    public void unbind() {
        this.connector.setProperties((DockController)null);
        this.behavior.setProperties((DockController)null);
        this.behavior.setDockable(null);
        super.unbind();
    }

    private void updateContent() {
        this.updateIcon();
        this.updateText();
        this.updateActionSource(false);
        if (this.behavior.isShowActions() || this.behavior.isShowChildren()) {
            this.setShowMiniButtons(true);
        } else {
            this.setShowMiniButtons(false);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected Insets getInnerInsets() {
        Insets insets = super.getInnerInsets();
        if (this.behavior.isShowKnob()) {
            insets = this.getOrientation().isHorizontal() ? new Insets(insets.top, insets.left + 10, insets.bottom, insets.right) : new Insets(insets.top + 10, insets.left, insets.bottom, insets.right);
        }
        return insets;
    }

    @Override
    protected DockActionSource getActionSourceFor(Dockable dockable) {
        return this.allActionsSource;
    }

    private void updateActionSource(boolean bl) {
        boolean bl2 = this.behavior.isShowChildren();
        boolean bl3 = this.behavior.isShowActions();
        boolean bl4 = this.behavior.isFilterActions();
        if (bl || this.showChildren != bl2 || this.showActions != bl3 || this.filterActions != bl4) {
            this.allActionsSource.removeAll();
            if (bl2) {
                this.allActionsSource.add(this.getChildrenActionSourceFor(this.getDockable()));
            }
            if (bl3) {
                if (bl4) {
                    this.allActionsSource.add(this.createFilter(this.getDefaultActionSourceFor(this.getDockable())));
                } else {
                    this.allActionsSource.add(this.getDefaultActionSourceFor(this.getDockable()));
                }
            }
            this.showChildren = bl2;
            this.showActions = bl3;
        }
    }

    protected DockActionSource createFilter(DockActionSource dockActionSource) {
        final ButtonContentFilter buttonContentFilter = this.connector.getValue();
        return new FilteredDockActionSource(dockActionSource){

            @Override
            protected boolean include(DockAction dockAction) {
                return buttonContentFilter.isButtonAction(dockAction);
            }
        };
    }

    protected DockActionSource getDefaultActionSourceFor(Dockable dockable) {
        return super.getActionSourceFor(dockable);
    }

    protected DockActionSource getChildrenActionSourceFor(Dockable dockable) {
        return new StationChildrenActionSource(dockable, null);
    }

    @Override
    protected void updateIcon() {
        if (this.behavior.isShowIcon()) {
            super.updateIcon();
        } else {
            this.setIcon(null);
        }
    }

    @Override
    protected void updateText() {
        if (this.behavior.isShowText()) {
            super.updateText();
        } else {
            this.setText("");
        }
    }

    @Override
    protected void paintForeground(Graphics graphics, JComponent jComponent) {
        this.paintIcon(graphics, jComponent);
        if (this.behavior.isShowKnob()) {
            Insets insets = this.getInnerInsets();
            if (this.getOrientation().isHorizontal()) {
                int n = insets.left - 10 + 3;
                int n2 = insets.top + 3;
                int n3 = this.getHeight() - insets.bottom - 4;
                graphics.setColor(this.getColor(this.knobActiveHighlightColor, this.knobInactiveHighlightColor, this.knobSelectedHighlightColor));
                graphics.drawLine(n, n2, n, n3);
                graphics.drawLine(n, n2, n + 2, n2);
                graphics.setColor(this.getColor(this.knobActiveShadowColor, this.knobInactiveShadowColor, this.knobSelectedShadowColor));
                graphics.drawLine(n, n3, n + 2, n3);
                graphics.drawLine(n + 2, n2 + 1, n + 2, n3);
            } else {
                int n = insets.top - 10 + 3;
                int n4 = insets.left + 3;
                int n5 = this.getWidth() - insets.right - 4;
                graphics.setColor(this.getColor(this.knobActiveHighlightColor, this.knobInactiveHighlightColor, this.knobSelectedHighlightColor));
                graphics.drawLine(n4, n, n5, n);
                graphics.drawLine(n4, n, n4, n + 2);
                graphics.setColor(this.getColor(this.knobActiveShadowColor, this.knobInactiveShadowColor, this.knobSelectedShadowColor));
                graphics.drawLine(n4 + 1, n + 2, n5, n + 2);
                graphics.drawLine(n5, n, n5, n + 2);
            }
        }
    }

    @Override
    public void setActive(boolean bl) {
        if (bl != this.isActive()) {
            super.setActive(bl);
            this.selected = bl;
            this.updateLayout();
        }
    }

    @Override
    public void changed(DockTitleEvent dockTitleEvent) {
        if (dockTitleEvent instanceof ActivityDockTitleEvent) {
            ActivityDockTitleEvent activityDockTitleEvent = (ActivityDockTitleEvent)dockTitleEvent;
            super.setActive(activityDockTitleEvent.isActive());
            this.selected = activityDockTitleEvent.isActive() || activityDockTitleEvent.isPreferred();
            this.updateLayout();
        } else {
            super.changed(dockTitleEvent);
        }
    }

    @Override
    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    protected boolean isMousePressed() {
        return this.mousePressed;
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected void updateLayout() {
        this.changeBorder();
        this.updateColors();
    }

    protected void changeBorder() {
        if (this.selected && this.mousePressed) {
            this.setBorder("dock.border.title.button.selected.pressed", BorderFactory.createBevelBorder(0));
        } else if (this.selected) {
            this.setBorder("dock.border.title.button.selected", BorderFactory.createBevelBorder(1));
        } else if (this.mousePressed) {
            this.setBorder("dock.border.title.button.pressed", BorderFactory.createBevelBorder(1));
        } else {
            this.setBorder("dock.border.title.button", BorderFactory.createBevelBorder(0));
        }
    }

    protected void updateColors() {
        if (this.isActive()) {
            this.setBackground(this.activeColor.color());
            this.setForeground(this.activeTextColor.color());
        } else if (this.selected) {
            this.setBackground(this.selectedColor.color());
            this.setForeground(this.selectedTextColor.color());
        } else {
            this.setBackground(this.inactiveColor.color());
            this.setForeground(this.inactiveTextColor.color());
        }
    }

    private Color getColor(TitleColor titleColor, TitleColor titleColor2, TitleColor titleColor3) {
        if (this.isActive()) {
            return titleColor.color();
        }
        if (this.selected) {
            return titleColor3.color();
        }
        return titleColor2.color();
    }

    public Color getActiveTextColor() {
        return this.activeTextColor.color();
    }

    public void setActiveTextColor(Color color) {
        this.activeTextColor.setValue(color);
    }

    public Color getActiveColor() {
        return this.activeColor.color();
    }

    public void setActiveColor(Color color) {
        this.activeColor.setValue(color);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor.color();
    }

    public void setSelectedTextColor(Color color) {
        this.selectedTextColor.setValue(color);
    }

    public Color getSelectedColor() {
        return this.selectedColor.color();
    }

    public void setSelectedColor(Color color) {
        this.selectedColor.setValue(color);
    }

    public Color getInactiveTextColor() {
        return this.inactiveTextColor.color();
    }

    public void setInactiveTextColor(Color color) {
        this.inactiveTextColor.setValue(color);
    }

    public Color getInactiveColor() {
        return this.inactiveColor.color();
    }

    public void setInactiveColor(Color color) {
        this.inactiveColor.setValue(color);
    }

    private class BasicTitleColor
    extends TitleColor {
        public BasicTitleColor(String string, Color color) {
            super(string, TitleColor.KIND_FLAP_BUTTON_COLOR, BasicButtonDockTitle.this, color);
        }

        @Override
        protected void changed(Color color, Color color2) {
            BasicButtonDockTitle.this.updateColors();
        }
    }
}

