/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.themes.DefaultThemeMeta;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemeMeta;
import bibliothek.gui.dock.themes.ThemeProperties;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;

public class ThemePropertyFactory<T extends DockTheme>
implements ThemeFactory {
    private Constructor<T> constructor;
    private ThemeProperties properties;

    public ThemePropertyFactory(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Theme must not be null");
        }
        this.properties = clazz.getAnnotation(ThemeProperties.class);
        if (this.properties == null) {
            throw new IllegalArgumentException("Theme misses annotation ThemeProperties");
        }
        try {
            this.constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Missing default constructor", noSuchMethodException);
        }
    }

    public T create(DockController dockController) {
        try {
            return (T)((DockTheme)this.constructor.newInstance(new Object[0]));
        }
        catch (Exception exception) {
            System.err.println("Can't create theme due an unknown reason");
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public ThemeMeta createMeta(DockController dockController) {
        return new DefaultThemeMeta(this, dockController, this.properties.nameBundle(), this.properties.descriptionBundle(), this.getAuthors(), this.getWebpages());
    }

    public String[] getAuthors() {
        return this.properties.authors();
    }

    public URI[] getWebpages() {
        try {
            String[] stringArray = this.properties.webpages();
            URI[] uRIArray = new URI[stringArray.length];
            int n = 0;
            while (n < uRIArray.length) {
                uRIArray[n] = new URI(stringArray[n]);
                ++n;
            }
            return uRIArray;
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.print("Can't create urls due an unknown reason");
            uRISyntaxException.printStackTrace();
            return null;
        }
    }
}

