/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.event.UIListener;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.span.SpanFactory;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.TypedPropertyUIScheme;
import bibliothek.gui.dock.util.TypedUIProperties;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIValue;
import bibliothek.util.Path;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;

public class ThemeManager
extends TypedUIProperties {
    public static final TypedUIProperties.Type<StationPaint> STATION_PAINT_TYPE = new TypedUIProperties.Type("StationPaint");
    public static final String STATION_PAINT = "dock.paint";
    public static final TypedUIProperties.Type<Combiner> COMBINER_TYPE = new TypedUIProperties.Type("Combiner");
    public static final String COMBINER = "dock.combiner";
    public static final TypedUIProperties.Type<DisplayerFactory> DISPLAYER_FACTORY_TYPE = new TypedUIProperties.Type("DisplayerFactory");
    public static final String DISPLAYER_FACTORY = "dock.displayer";
    public static final TypedUIProperties.Type<BackgroundPaint> BACKGROUND_PAINT_TYPE = new TypedUIProperties.Type("BackgroundPaint");
    public static final String BACKGROUND_PAINT = "dock.background";
    public static final TypedUIProperties.Type<BorderModifier> BORDER_MODIFIER_TYPE = new TypedUIProperties.Type("BorderModifier");
    public static final String BORDER_MODIFIER = "dock.border";
    public static final TypedUIProperties.Type<SpanFactory> SPAN_FACTORY_TYPE = new TypedUIProperties.Type("SpanFactory");
    public static final String SPAN_FACTORY = "dock.spanFactory";
    private DockController controller;
    private DockTheme theme;
    private List<UIListener> uiListeners = new ArrayList<UIListener>();
    private PropertyChangeListener lookAndFeelObserver = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                ThemeManager.this.updateUI();
            }
        }
    };
    private TypedPropertyUIScheme transfers;

    public ThemeManager(DockController dockController) {
        super(dockController);
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
        UIManager.addPropertyChangeListener(this.lookAndFeelObserver);
        this.transfers = new TypedPropertyUIScheme(dockController.getProperties());
        this.setScheme(Priority.THEME, this.transfers);
    }

    public void init() {
        this.registerTypes();
        this.link();
    }

    private void registerTypes() {
        this.registerType(STATION_PAINT_TYPE);
        this.registerType(COMBINER_TYPE);
        this.registerType(DISPLAYER_FACTORY_TYPE);
        this.registerType(BACKGROUND_PAINT_TYPE);
        this.registerType(BORDER_MODIFIER_TYPE);
        this.registerType(SPAN_FACTORY_TYPE);
    }

    private void link() {
        this.link(DockTheme.STATION_PAINT, STATION_PAINT_TYPE, STATION_PAINT);
        this.link(DockTheme.COMBINER, COMBINER_TYPE, COMBINER);
        this.link(DockTheme.DISPLAYER_FACTORY, DISPLAYER_FACTORY_TYPE, DISPLAYER_FACTORY);
        this.link(DockTheme.BACKGROUND_PAINT, BACKGROUND_PAINT_TYPE, BACKGROUND_PAINT);
        this.link(DockTheme.BORDER_MODIFIER, BORDER_MODIFIER_TYPE, BORDER_MODIFIER);
        this.link(DockTheme.SPAN_FACTORY, SPAN_FACTORY_TYPE, SPAN_FACTORY);
    }

    public void kill() {
        this.theme.uninstall(this.controller);
        UIManager.removePropertyChangeListener(this.lookAndFeelObserver);
    }

    public <V, A extends V> void link(PropertyKey<A> propertyKey, TypedUIProperties.Type<V> type, String string) {
        this.transfers.link(propertyKey, type, string);
    }

    public <V> void unlink(TypedUIProperties.Type<V> type, String string) {
        this.transfers.unlink(type, string);
    }

    public void addUIListener(UIListener uIListener) {
        this.uiListeners.add(uIListener);
    }

    public void removeUIListener(UIListener uIListener) {
        this.uiListeners.remove(uIListener);
    }

    protected UIListener[] uiListeners() {
        return this.uiListeners.toArray(new UIListener[this.uiListeners.size()]);
    }

    public void updateUI() {
        UIListener[] uIListenerArray = this.uiListeners();
        int n = uIListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIListener uIListener = uIListenerArray[n2];
            uIListener.updateUI(this.controller);
            ++n2;
        }
    }

    public DockTheme getTheme() {
        return this.theme;
    }

    public void setTheme(DockTheme dockTheme) {
        if (dockTheme == null) {
            throw new IllegalArgumentException("Theme must not be null");
        }
        if (this.theme != dockTheme) {
            int n;
            int n2;
            Object[] objectArray;
            Object object;
            Object object2 = this.uiListeners();
            int n3 = ((UIListener[])object2).length;
            int n4 = 0;
            while (n4 < n3) {
                object = object2[n4];
                object.themeWillChange(this.controller, this.theme, dockTheme);
                ++n4;
            }
            object = this.controller.getRegister();
            DockTheme dockTheme2 = this.theme;
            Dockable dockable = null;
            try {
                ((DockRegister)object).setStalled(true);
                dockable = this.controller.getFocusedDockable();
                if (this.theme != null) {
                    this.theme.uninstall(this.controller);
                }
                this.theme = dockTheme;
                dockTheme.install(this.controller);
                this.controller.getDockTitleManager().registerTheme("theme", dockTheme.getTitleFactory(this.controller));
                objectArray = ((DockRegister)object).listDockStations();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    object2 = objectArray[n];
                    if (object2.getController() == this.controller) {
                        object2.updateTheme();
                    }
                    ++n;
                }
            }
            finally {
                ((DockRegister)object).setStalled(false);
            }
            this.controller.setFocusedDockable(new DefaultFocusRequest(dockable, null, true));
            objectArray = this.uiListeners();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                object2 = objectArray[n];
                object2.themeChanged(this.controller, dockTheme2, dockTheme);
                ++n;
            }
        }
    }

    public void setStationPaint(String string, StationPaint stationPaint) {
        this.put(Priority.CLIENT, string, STATION_PAINT_TYPE, stationPaint);
    }

    public void setStationPaintBridge(Path path, UIBridge<StationPaint, UIValue<StationPaint>> uIBridge) {
        if (uIBridge == null) {
            this.unpublish(Priority.CLIENT, path, STATION_PAINT_TYPE);
        } else {
            this.publish(Priority.CLIENT, path, STATION_PAINT_TYPE, uIBridge);
        }
    }

    public void setCombiner(String string, Combiner combiner) {
        this.put(Priority.CLIENT, string, COMBINER_TYPE, combiner);
    }

    public void setCombinerBridge(Path path, UIBridge<Combiner, UIValue<Combiner>> uIBridge) {
        if (uIBridge == null) {
            this.unpublish(Priority.CLIENT, path, COMBINER_TYPE);
        } else {
            this.publish(Priority.CLIENT, path, COMBINER_TYPE, uIBridge);
        }
    }

    public void setDisplayerFactory(String string, DisplayerFactory displayerFactory) {
        this.put(Priority.CLIENT, string, DISPLAYER_FACTORY_TYPE, displayerFactory);
    }

    public void setDisplayerFactoryBridge(Path path, UIBridge<DisplayerFactory, UIValue<DisplayerFactory>> uIBridge) {
        if (uIBridge == null) {
            this.unpublish(Priority.CLIENT, path, DISPLAYER_FACTORY_TYPE);
        } else {
            this.publish(Priority.CLIENT, path, DISPLAYER_FACTORY_TYPE, uIBridge);
        }
    }

    public void setSpanFactory(String string, SpanFactory spanFactory) {
        this.put(Priority.CLIENT, string, SPAN_FACTORY_TYPE, spanFactory);
    }

    public void setSpanFactoryBridge(Path path, UIBridge<SpanFactory, UIValue<SpanFactory>> uIBridge) {
        if (uIBridge == null) {
            this.unpublish(Priority.CLIENT, path, SPAN_FACTORY_TYPE);
        } else {
            this.publish(Priority.CLIENT, path, SPAN_FACTORY_TYPE, uIBridge);
        }
    }

    public void setBackgroundPaint(String string, BackgroundPaint backgroundPaint) {
        this.put(Priority.CLIENT, string, BACKGROUND_PAINT_TYPE, backgroundPaint);
    }

    public void setBackgroundPaintBridge(Path path, UIBridge<BackgroundPaint, UIValue<BackgroundPaint>> uIBridge) {
        if (uIBridge == null) {
            this.unpublish(Priority.CLIENT, path, BACKGROUND_PAINT_TYPE);
        } else {
            this.publish(Priority.CLIENT, path, BACKGROUND_PAINT_TYPE, uIBridge);
        }
    }

    public void setBorderModifier(String string, BorderModifier borderModifier) {
        this.put(Priority.CLIENT, string, BORDER_MODIFIER_TYPE, borderModifier);
    }

    public void setBorderModifierBridge(Path path, UIBridge<BorderModifier, UIValue<BorderModifier>> uIBridge) {
        if (uIBridge == null) {
            this.unpublish(Priority.CLIENT, path, BORDER_MODIFIER_TYPE);
        } else {
            this.publish(Priority.CLIENT, path, BORDER_MODIFIER_TYPE, uIBridge);
        }
    }
}

