/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.focus.DockableSelectionListener;
import java.awt.Component;

public class ThemeDockableSelection
implements DockableSelection {
    private DockController controller;
    private DockableSelection current;
    private DockableSelectionListener listener = new DockableSelectionListener(){

        @Override
        public void selected(Dockable dockable) {
            ThemeDockableSelection.this.closed();
        }

        @Override
        public void considering(Dockable dockable) {
        }

        @Override
        public void canceled() {
            ThemeDockableSelection.this.closed();
        }
    };

    public ThemeDockableSelection(DockController dockController) {
        this.controller = dockController;
    }

    private DockableSelection get() {
        if (this.current != null) {
            return this.current;
        }
        return this.controller.getTheme().getDockableSelection(this.controller);
    }

    private void closed() {
        if (this.current != null) {
            this.current.removeDockableSelectionListener(this.listener);
            this.current = null;
        }
    }

    @Override
    public void addDockableSelectionListener(DockableSelectionListener dockableSelectionListener) {
        this.get().addDockableSelectionListener(dockableSelectionListener);
    }

    @Override
    public void close() {
        this.get().close();
        this.closed();
    }

    @Override
    public Component getComponent() {
        return this.get().getComponent();
    }

    @Override
    public boolean hasChoices(DockController dockController) {
        return this.get().hasChoices(dockController);
    }

    @Override
    public void open(DockController dockController) {
        if (this.current == null) {
            this.current = this.get();
            this.current.addDockableSelectionListener(this.listener);
        }
        this.current.open(dockController);
    }

    @Override
    public void removeDockableSelectionListener(DockableSelectionListener dockableSelectionListener) {
        this.get().removeDockableSelectionListener(dockableSelectionListener);
    }
}

