/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.Enforcement;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class ThemeCombiner
implements Combiner {
    private DockController controller;

    public ThemeCombiner(DockController dockController) {
        this.controller = dockController;
    }

    private Combiner get(CombinerSource combinerSource) {
        return this.get(combinerSource.getParent());
    }

    private Combiner get(DockStation dockStation) {
        return this.controller.getTheme().getCombiner(dockStation);
    }

    @Override
    public CombinerTarget prepare(CombinerSource combinerSource, Enforcement enforcement) {
        Combiner combiner = this.get(combinerSource);
        CombinerTarget combinerTarget = combiner.prepare(combinerSource, enforcement);
        if (combinerTarget == null) {
            return null;
        }
        return new Target(combiner, combinerTarget);
    }

    @Override
    public Dockable combine(CombinerSource combinerSource, CombinerTarget combinerTarget) {
        Target target = (Target)combinerTarget;
        return target.combiner.combine(combinerSource, target.delegate);
    }

    @Override
    public void aside(AsideRequest asideRequest) {
        DockStation dockStation = asideRequest.getParentStation();
        if (dockStation != null) {
            Combiner combiner = this.get(dockStation);
            combiner.aside(asideRequest);
        }
    }

    private static class Target
    implements CombinerTarget {
        private Combiner combiner;
        private CombinerTarget delegate;

        public Target(Combiner combiner, CombinerTarget combinerTarget) {
            this.combiner = combiner;
            this.delegate = combinerTarget;
        }

        @Override
        public void paint(Graphics graphics, Component component, StationPaint stationPaint, Rectangle rectangle, Rectangle rectangle2) {
            this.delegate.paint(graphics, component, stationPaint, rectangle, rectangle2);
        }

        @Override
        public DisplayerCombinerTarget getDisplayerCombination() {
            return this.delegate.getDisplayerCombination();
        }
    }
}

