/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.themes.DefaultThemeMeta;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemeMeta;
import bibliothek.gui.dock.themes.ThemeMetaListener;
import bibliothek.gui.dock.themes.ThemePropertyFactory;
import bibliothek.gui.dock.themes.nostack.NoStackAcceptance;
import bibliothek.gui.dock.themes.nostack.NoStackTitleFactory;
import bibliothek.gui.dock.title.DockTitleFactory;

public class NoStackTheme
implements DockTheme {
    private DockTheme base;
    private NoStackAcceptance acceptance = new NoStackAcceptance();

    public static <T extends DockTheme> ThemeFactory getFactory(Class<T> clazz) {
        final ThemePropertyFactory<T> themePropertyFactory = new ThemePropertyFactory<T>(clazz);
        return new ThemeFactory(){

            @Override
            public DockTheme create(DockController dockController) {
                return new NoStackTheme(themePropertyFactory.create(dockController));
            }

            @Override
            public ThemeMeta createMeta(DockController dockController) {
                return new Meta(this, dockController, themePropertyFactory.createMeta(dockController));
            }
        };
    }

    public NoStackTheme(DockTheme dockTheme) {
        if (dockTheme == null) {
            throw new IllegalArgumentException("Base theme must not be null");
        }
        this.base = dockTheme;
    }

    @Override
    public Combiner getCombiner(DockStation dockStation) {
        return this.base.getCombiner(dockStation);
    }

    @Override
    public DisplayerFactory getDisplayFactory(DockStation dockStation) {
        return this.base.getDisplayFactory(dockStation);
    }

    @Override
    public StationPaint getPaint(DockStation dockStation) {
        return this.base.getPaint(dockStation);
    }

    @Override
    public DockTitleFactory getTitleFactory(DockController dockController) {
        return new NoStackTitleFactory(this.base.getTitleFactory(dockController));
    }

    @Override
    public DockableMovingImageFactory getMovingImageFactory(DockController dockController) {
        return this.base.getMovingImageFactory(dockController);
    }

    @Override
    public DockableSelection getDockableSelection(DockController dockController) {
        return this.base.getDockableSelection(dockController);
    }

    @Override
    public void install(DockController dockController) {
        this.base.install(dockController);
        dockController.addAcceptance(this.acceptance);
    }

    @Override
    public void uninstall(DockController dockController) {
        this.base.uninstall(dockController);
        dockController.removeAcceptance(this.acceptance);
    }

    private static class Meta
    extends DefaultThemeMeta
    implements ThemeMetaListener {
        private ThemeMeta meta;

        public Meta(ThemeFactory themeFactory, DockController dockController, ThemeMeta themeMeta) {
            super(themeFactory, dockController, "theme.small", "theme.small.description", themeMeta.getAuthors(), themeMeta.getWebpages());
            this.meta = themeMeta;
        }

        @Override
        public void addListener(ThemeMetaListener themeMetaListener) {
            if (!this.hasListeners()) {
                this.meta.addListener(this);
            }
            super.addListener(themeMetaListener);
        }

        @Override
        public void removeListener(ThemeMetaListener themeMetaListener) {
            super.removeListener(themeMetaListener);
            if (!this.hasListeners()) {
                this.meta.removeListener(this);
            }
        }

        @Override
        public String getName() {
            String string = super.getName();
            String string2 = this.meta.getName();
            return String.valueOf(string) + " \"" + string2 + "\"";
        }

        @Override
        public String[] getAuthors() {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3 = stringArray2 = this.getAuthors();
            int n = stringArray2.length;
            int n2 = 0;
            while (n2 < n) {
                stringArray = stringArray3[n2];
                if (stringArray.equals("Benjamin Sigg")) {
                    return stringArray2;
                }
                ++n2;
            }
            stringArray = new String[stringArray2.length + 1];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            stringArray[stringArray2.length] = "Benjamin Sigg";
            return stringArray;
        }

        @Override
        public void authorsChanged(ThemeMeta themeMeta) {
            this.setAuthors(themeMeta.getAuthors());
        }

        @Override
        public void webpagesChanged(ThemeMeta themeMeta) {
            this.setWebpages(themeMeta.getWebpages());
        }

        @Override
        public void descriptionChanged(ThemeMeta themeMeta) {
        }

        @Override
        public void nameChanged(ThemeMeta themeMeta) {
            this.fireNameChanged();
        }
    }
}

