/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemeFactoryText;
import bibliothek.gui.dock.themes.ThemeMeta;
import bibliothek.gui.dock.themes.ThemeMetaListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class DefaultThemeMeta
implements ThemeMeta {
    private ThemeFactory factory;
    private DockController controller;
    private ThemeFactoryText name;
    private ThemeFactoryText description;
    private String[] authors;
    private URI[] webpages;
    private List<ThemeMetaListener> listeners = new ArrayList<ThemeMetaListener>();

    public DefaultThemeMeta(ThemeFactory themeFactory, DockController dockController, String string, String string2, String[] stringArray, URI[] uRIArray) {
        this.factory = themeFactory;
        this.controller = dockController;
        this.authors = stringArray;
        this.webpages = uRIArray;
        this.name = new ThemeFactoryText(string, themeFactory){

            @Override
            protected void changed(String string, String string2) {
                DefaultThemeMeta.this.fireNameChanged();
            }
        };
        this.description = new ThemeFactoryText(string2, themeFactory){

            @Override
            protected void changed(String string, String string2) {
                DefaultThemeMeta.this.fireDescriptionChanged();
            }
        };
    }

    protected boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    protected void fireNameChanged() {
        ThemeMetaListener[] themeMetaListenerArray = this.listeners.toArray(new ThemeMetaListener[this.listeners.size()]);
        int n = themeMetaListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThemeMetaListener themeMetaListener = themeMetaListenerArray[n2];
            themeMetaListener.nameChanged(this);
            ++n2;
        }
    }

    protected void fireDescriptionChanged() {
        ThemeMetaListener[] themeMetaListenerArray = this.listeners.toArray(new ThemeMetaListener[this.listeners.size()]);
        int n = themeMetaListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThemeMetaListener themeMetaListener = themeMetaListenerArray[n2];
            themeMetaListener.descriptionChanged(this);
            ++n2;
        }
    }

    protected void fireAuthorChanged() {
        ThemeMetaListener[] themeMetaListenerArray = this.listeners.toArray(new ThemeMetaListener[this.listeners.size()]);
        int n = themeMetaListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThemeMetaListener themeMetaListener = themeMetaListenerArray[n2];
            themeMetaListener.authorsChanged(this);
            ++n2;
        }
    }

    protected void fireWebpagesChanged() {
        ThemeMetaListener[] themeMetaListenerArray = this.listeners.toArray(new ThemeMetaListener[this.listeners.size()]);
        int n = themeMetaListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThemeMetaListener themeMetaListener = themeMetaListenerArray[n2];
            themeMetaListener.webpagesChanged(this);
            ++n2;
        }
    }

    @Override
    public ThemeFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(ThemeFactory themeFactory) {
        this.factory = themeFactory;
    }

    @Override
    public void addListener(ThemeMetaListener themeMetaListener) {
        if (themeMetaListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.listeners.size() == 0) {
            this.name.setController(this.controller);
            this.description.setController(this.controller);
        }
        this.listeners.add(themeMetaListener);
    }

    @Override
    public void removeListener(ThemeMetaListener themeMetaListener) {
        this.listeners.remove(themeMetaListener);
        if (this.listeners.size() == 0) {
            this.name.setController(null);
            this.description.setController(null);
        }
    }

    public void setAuthors(String[] stringArray) {
        this.authors = stringArray;
        this.fireAuthorChanged();
    }

    @Override
    public String[] getAuthors() {
        return this.authors;
    }

    @Override
    public String getDescription() {
        if (this.listeners.size() == 0) {
            this.description.update(this.controller.getTexts());
        }
        return (String)this.description.value();
    }

    @Override
    public String getName() {
        if (this.listeners.size() == 0) {
            this.name.update(this.controller.getTexts());
        }
        return (String)this.name.value();
    }

    public void setWebpages(URI[] uRIArray) {
        this.webpages = uRIArray;
        this.fireWebpagesChanged();
    }

    @Override
    public URI[] getWebpages() {
        return this.webpages;
    }
}

