/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.mode;

import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XContainer;
import bibliothek.util.xml.XElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModeSettings<A, B> {
    private List<DockableEntry> dockables = new ArrayList<DockableEntry>();
    private Map<Path, ModeSetting<A>> modes = new HashMap<Path, ModeSetting<A>>();
    private ModeSettingsConverter<A, B> converter;
    private Map<Path, ModeSettingFactory<A>> factories = new HashMap<Path, ModeSettingFactory<A>>();

    public ModeSettings(ModeSettingsConverter<A, B> modeSettingsConverter) {
        if (modeSettingsConverter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        this.converter = modeSettingsConverter;
    }

    public ModeSettingsConverter<A, B> getConverter() {
        return this.converter;
    }

    public void addFactory(ModeSettingFactory<A> modeSettingFactory) {
        this.factories.put(modeSettingFactory.getModeId(), modeSettingFactory);
    }

    public void add(String string, Path path, Map<Path, A> map, Collection<Path> collection) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        if (map == null) {
            throw new NullPointerException("properties");
        }
        if (collection == null) {
            throw new NullPointerException("history");
        }
        DockableEntry dockableEntry = new DockableEntry();
        dockableEntry.id = string;
        dockableEntry.current = path;
        dockableEntry.history = collection.toArray(new Path[collection.size()]);
        dockableEntry.properties = new HashMap();
        for (Map.Entry<Path, A> entry : map.entrySet()) {
            dockableEntry.properties.put(entry.getKey(), this.converter.convertToSetting(entry.getValue()));
        }
        this.dockables.add(dockableEntry);
    }

    public void add(Mode<A> mode) {
        ModeSettingFactory<A> modeSettingFactory = this.factories.get(mode.getUniqueIdentifier());
        if (modeSettingFactory == null) {
            throw new IllegalArgumentException("no factory present for '" + mode.getUniqueIdentifier() + "'");
        }
        ModeSetting<A> modeSetting = modeSettingFactory.create();
        if (modeSetting != null) {
            mode.writeSetting(modeSetting);
            this.modes.put(modeSetting.getModeId(), modeSetting);
        }
    }

    public void add(ModeSetting<A> modeSetting) {
        this.modes.put(modeSetting.getModeId(), modeSetting);
    }

    public int size() {
        return this.dockables.size();
    }

    public int indexOf(String string) {
        int n = 0;
        for (DockableEntry dockableEntry : this.dockables) {
            if (dockableEntry.id.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getId(int n) {
        return this.dockables.get((int)n).id;
    }

    public Path getCurrent(int n) {
        return this.dockables.get((int)n).current;
    }

    public Path[] getHistory(int n) {
        return this.dockables.get((int)n).history;
    }

    public Map<Path, A> getProperties(int n) {
        HashMap<Path, A> hashMap = new HashMap<Path, A>();
        for (Map.Entry entry : this.dockables.get((int)n).properties.entrySet()) {
            hashMap.put(entry.getKey(), this.converter.convertToWorld(entry.getValue()));
        }
        return hashMap;
    }

    public ModeSetting<A> getSettings(Path path) {
        return this.modes.get(path);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        dataOutputStream.writeInt(this.dockables.size());
        for (DockableEntry object2 : this.dockables) {
            dataOutputStream.writeUTF(object2.id);
            if (object2.current == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeUTF(object2.current.toString());
            }
            dataOutputStream.writeInt(object2.history.length);
            Path[] pathArray = object2.history;
            int n = object2.history.length;
            int n2 = 0;
            while (n2 < n) {
                Path path = pathArray[n2];
                dataOutputStream.writeUTF(path.toString());
                ++n2;
            }
            dataOutputStream.writeInt(object2.properties.size());
            for (Map.Entry entry : object2.properties.entrySet()) {
                dataOutputStream.writeUTF(((Path)entry.getKey()).toString());
                this.converter.writeProperty(entry.getValue(), dataOutputStream);
            }
        }
        dataOutputStream.writeInt(this.modes.size());
        for (ModeSetting modeSetting : this.modes.values()) {
            dataOutputStream.writeUTF(modeSetting.getModeId().toString());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
            modeSetting.write(dataOutputStream2, this.converter);
            dataOutputStream.writeInt(byteArrayOutputStream.size());
            byteArrayOutputStream.writeTo(dataOutputStream);
            dataOutputStream2.close();
        }
    }

    protected void rescueSettings(DataInputStream dataInputStream, Version version) throws IOException {
    }

    protected void rescueSettings(XElement xElement) {
    }

    protected Path resuceMode(String string) {
        return null;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        Object object;
        boolean bl;
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl2 = bl = Version.VERSION_1_0_7.compareTo(version) >= 0;
        if (bl) {
            Version.read(dataInputStream);
        }
        this.dockables.clear();
        int n2 = 0;
        int n3 = dataInputStream.readInt();
        while (n2 < n3) {
            object = new DockableEntry();
            this.dockables.add((DockableEntry)object);
            ((DockableEntry)object).id = dataInputStream.readUTF();
            if (dataInputStream.readBoolean()) {
                String string = dataInputStream.readUTF();
                ((DockableEntry)object).current = bl ? this.resuceMode(string) : new Path(string);
            }
            ((DockableEntry)object).history = new Path[dataInputStream.readInt()];
            n = 0;
            while (n < ((DockableEntry)object).history.length) {
                String string = dataInputStream.readUTF();
                ((DockableEntry)object).history[n] = bl ? this.resuceMode(string) : new Path(string);
                ++n;
            }
            if (bl) {
                n = 0;
                int n4 = 0;
                while (n4 < ((DockableEntry)object).history.length) {
                    if (((DockableEntry)object).history[n4] != null) {
                        ++n;
                    }
                    ++n4;
                }
                if (n != ((DockableEntry)object).history.length) {
                    Path[] pathArray = ((DockableEntry)object).history;
                    ((DockableEntry)object).history = new Path[n];
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < pathArray.length) {
                        if (pathArray[n6] != null) {
                            ((DockableEntry)object).history[n5++] = pathArray[n6];
                        }
                        ++n6;
                    }
                }
            }
            ((DockableEntry)object).properties = new HashMap();
            n = 0;
            int n7 = dataInputStream.readInt();
            while (n < n7) {
                String string = dataInputStream.readUTF();
                Path path = bl ? this.resuceMode(string) : new Path(string);
                B b = this.converter.readProperty(dataInputStream);
                if (path != null) {
                    ((DockableEntry)object).properties.put(path, b);
                }
                ++n;
            }
            ++n2;
        }
        this.modes.clear();
        if (bl) {
            this.rescueSettings(dataInputStream, version);
        } else {
            n2 = 0;
            n3 = dataInputStream.readInt();
            while (n2 < n3) {
                int n8;
                object = new Path(dataInputStream.readUTF());
                n = dataInputStream.readInt();
                byte[] byArray = new byte[n];
                int n9 = 0;
                int n10 = n;
                while (n10 > 0 && (n8 = dataInputStream.read(byArray, n9, n10)) > 0) {
                    n9 += n8;
                    n10 -= n8;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream);
                ModeSettingFactory<A> modeSettingFactory = this.factories.get(object);
                if (modeSettingFactory != null) {
                    ModeSetting<A> modeSetting = modeSettingFactory.create();
                    modeSetting.read(dataInputStream2, this.converter);
                    dataInputStream2.close();
                    this.modes.put(modeSetting.getModeId(), modeSetting);
                }
                ++n2;
            }
        }
    }

    public void writeXML(XElement xElement) {
        XElement xElement2;
        XElement xElement3 = xElement.addElement("dockables");
        for (DockableEntry dockableEntry : this.dockables) {
            Object object;
            XElement xElement4 = xElement3.addElement("entry");
            xElement4.addString("id", dockableEntry.id);
            if (dockableEntry.current != null) {
                xElement4.addString("current", dockableEntry.current.toString());
            }
            xElement2 = xElement4.addElement("history");
            Object object2 = dockableEntry.history;
            int n = dockableEntry.history.length;
            int n2 = 0;
            while (n2 < n) {
                object = object2[n2];
                xElement2.addElement("mode").setString(((Path)object).toString());
                ++n2;
            }
            object = xElement4.addElement("properties");
            for (Map.Entry entry : dockableEntry.properties.entrySet()) {
                object2 = ((XElement)object).addElement("property");
                ((XElement)object2).addString("id", entry.getKey().toString());
                this.converter.writePropertyXML(entry.getValue(), (XElement)object2);
            }
        }
        XElement xElement5 = xElement.addElement("modes");
        for (ModeSetting modeSetting : this.modes.values()) {
            xElement2 = xElement5.addElement("entry");
            xElement2.addString("id", modeSetting.getModeId().toString());
            modeSetting.write(xElement2, this.converter);
        }
    }

    public void readXML(XElement xElement) {
        Object object;
        ModeSettingFactory<A> modeSettingFactory;
        Object object2;
        Object object3;
        XElement xElement2;
        int n;
        this.dockables.clear();
        XElement xElement3 = xElement.getElement("dockables");
        if (xElement3 != null) {
            XElement[] xElementArray = xElement3.getElements("entry");
            n = xElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                xElement2 = xElementArray[n2];
                object3 = new DockableEntry();
                this.dockables.add((DockableEntry)object3);
                object3.id = xElement2.getString("id");
                object2 = xElement2.getAttribute("current");
                if (object2 != null) {
                    object3.current = new Path(((XContainer)object2).getString());
                }
                if ((modeSettingFactory = xElement2.getElement("history")) == null) {
                    object3.history = new Path[0];
                } else {
                    object = ((XElement)((Object)modeSettingFactory)).getElements("mode");
                    object3.history = new Path[((XElement[])object).length];
                    int n3 = 0;
                    while (n3 < ((XElement[])object).length) {
                        object3.history[n3] = new Path(((XElement)object[n3]).getString());
                        ++n3;
                    }
                }
                object = xElement2.getElement("properties");
                object3.properties = new HashMap();
                if (object != null) {
                    XElement[] xElementArray2 = ((XElement)object).getElements("property");
                    int n4 = xElementArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        XElement xElement4 = xElementArray2[n5];
                        object3.properties.put(new Path(xElement4.getString("id")), this.converter.readPropertyXML(xElement4));
                        ++n5;
                    }
                }
                ++n2;
            }
        }
        this.modes.clear();
        xElement2 = xElement.getElement("modes");
        if (xElement2 != null) {
            object3 = xElement2.getElements("entry");
            int n6 = ((XElement[])object3).length;
            n = 0;
            while (n < n6) {
                XElement xElement5 = object3[n];
                object2 = new Path(xElement5.getString("id"));
                modeSettingFactory = this.factories.get(object2);
                if (modeSettingFactory != null) {
                    object = modeSettingFactory.create();
                    object.read(xElement5, this.converter);
                    this.modes.put(object.getModeId(), (ModeSetting<A>)object);
                }
                ++n;
            }
        } else {
            this.rescueSettings(xElement);
        }
    }

    private class DockableEntry {
        public String id;
        public Path current;
        public Map<Path, B> properties;
        public Path[] history;

        private DockableEntry() {
        }
    }
}

