/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManager;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ModeForwardingActionSource<H>
extends AbstractDockActionSource {
    private DockStation station;
    private ModeManager<H, ? extends Mode<H>> manager;
    private DockActionSource delegate;
    private DockActionSourceListener delegateListener = new DockActionSourceListener(){

        @Override
        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            ModeForwardingActionSource.this.fireRemoved(n, n2);
        }

        @Override
        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            ModeForwardingActionSource.this.fireAdded(n, n2);
        }
    };
    private DockStationListener stationListener = new DockStationAdapter(){

        @Override
        public void dockableAdded(DockStation dockStation, Dockable dockable) {
            ModeForwardingActionSource.this.rebuild();
        }

        @Override
        public void dockableRemoved(DockStation dockStation, Dockable dockable) {
            ModeForwardingActionSource.this.rebuild();
        }

        @Override
        public void dockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
            ModeForwardingActionSource.this.rebuild();
        }
    };

    public ModeForwardingActionSource(DockStation dockStation, ModeManager<H, ? extends Mode<H>> modeManager) {
        this.station = dockStation;
        this.manager = modeManager;
        this.rebuild();
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        boolean bl = this.listeners.isEmpty();
        super.addDockActionSourceListener(dockActionSourceListener);
        if (bl) {
            if (this.delegate != null) {
                this.delegate.addDockActionSourceListener(this.delegateListener);
            }
            this.station.addDockStationListener(this.stationListener);
        }
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        super.removeDockActionSourceListener(dockActionSourceListener);
        if (this.listeners.isEmpty()) {
            if (this.delegate != null) {
                this.delegate.removeDockActionSourceListener(this.delegateListener);
            }
            this.station.removeDockStationListener(this.stationListener);
        }
    }

    @Override
    public DockAction getDockAction(int n) {
        return this.delegate.getDockAction(n);
    }

    @Override
    public int getDockActionCount() {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.getDockActionCount();
    }

    @Override
    public LocationHint getLocationHint() {
        return new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT);
    }

    @Override
    public Iterator<DockAction> iterator() {
        if (this.delegate == null) {
            return new Iterator<DockAction>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public DockAction next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.delegate.iterator();
    }

    private void rebuild() {
        int n;
        if (this.delegate != null) {
            if (!this.listeners.isEmpty()) {
                this.delegate.removeDockActionSourceListener(this.delegateListener);
            }
            n = this.getDockActionCount();
            this.delegate = null;
            if (n > 0) {
                this.fireRemoved(0, n - 1);
            }
        }
        this.delegate = this.manager.getSharedActions(this.station);
        if (this.delegate != null) {
            if (!this.listeners.isEmpty()) {
                this.delegate.addDockActionSourceListener(this.delegateListener);
            }
            if ((n = this.getDockActionCount()) > 0) {
                this.fireAdded(0, n - 1);
            }
        }
    }
}

