/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PlaceholderMap {
    private int version;
    private Path format;
    private Map<Key, Map<String, Object>> data = new LinkedHashMap<Key, Map<String, Object>>();
    private PlaceholderStrategy strategy;
    private PlaceholderStrategyListener listener = new PlaceholderStrategyListener(){

        @Override
        public void placeholderInvalidated(Set<Path> set) {
            PlaceholderMap.this.removeAll(set, false);
        }
    };

    public PlaceholderMap(Path path, int n) {
        if (path == null) {
            throw new IllegalArgumentException("format must not be null");
        }
        this.format = path;
        this.version = n;
    }

    public PlaceholderMap(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        this.setPlaceholderStrategy(placeholderStrategy);
        Version version = Version.read(dataInputStream);
        if (Version.VERSION_1_1_1a.compareTo(version) < 0) {
            throw new IOException("unknown version: " + version);
        }
        this.version = dataInputStream.readInt();
        this.format = new Path(dataInputStream.readUTF());
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            PlaceholderKey placeholderKey = new PlaceholderKey(dataInputStream, version);
            if ((placeholderKey = placeholderKey.shrink(placeholderStrategy)) != null) {
                this.add(placeholderKey);
                Map<String, Object> map = this.data.get(placeholderKey);
                n3 = dataInputStream.readInt();
                int n4 = 0;
                while (n4 < n3) {
                    String string = dataInputStream.readUTF();
                    Object object = this.read(dataInputStream, placeholderStrategy);
                    map.put(string, object);
                    ++n4;
                }
            } else {
                int n5 = dataInputStream.readInt();
                n3 = 0;
                while (n3 < n5) {
                    dataInputStream.readUTF();
                    this.read(dataInputStream, placeholderStrategy);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public PlaceholderMap(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        this.setPlaceholderStrategy(placeholderStrategy);
        XElement xElement2 = xElement.getElement("version");
        if (xElement2 == null) {
            throw new XException("missing element 'version'");
        }
        this.version = xElement2.getInt();
        XElement xElement3 = xElement.getElement("format");
        if (xElement3 == null) {
            throw new XException("missing element 'format'");
        }
        this.format = new Path(xElement3.getString());
        int n = 0;
        int n2 = xElement.getElementCount();
        while (n < n2) {
            XElement xElement4 = xElement.getElement(n);
            if (xElement4.getName().equals("entry")) {
                PlaceholderKey placeholderKey = new PlaceholderKey(xElement4.getElement("key"));
                if ((placeholderKey = placeholderKey.shrink(placeholderStrategy)) != null) {
                    this.add(placeholderKey);
                    Map<String, Object> map = this.data.get(placeholderKey);
                    int n3 = 0;
                    int n4 = xElement4.getElementCount();
                    while (n3 < n4) {
                        XElement xElement5 = xElement4.getElement(n3);
                        if (xElement5.getName().equals("item")) {
                            String string = xElement5.getString("key");
                            Object object = this.read(xElement5, placeholderStrategy);
                            map.put(string, object);
                        }
                        ++n3;
                    }
                }
            }
            ++n;
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_1_1a);
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeUTF(this.format.toString());
        dataOutputStream.writeInt(this.data.size());
        for (Map.Entry<Key, Map<String, Object>> entry : this.data.entrySet()) {
            ((PlaceholderKey)entry.getKey()).write(dataOutputStream);
            Map<String, Object> map = entry.getValue();
            dataOutputStream.writeInt(map.size());
            for (Map.Entry<String, Object> entry2 : map.entrySet()) {
                dataOutputStream.writeUTF(entry2.getKey());
                this.write(entry2.getValue(), dataOutputStream);
            }
        }
    }

    private void write(Object object, DataOutputStream dataOutputStream) throws IOException {
        if (object instanceof String) {
            dataOutputStream.writeByte(0);
            dataOutputStream.writeUTF((String)object);
        } else if (object instanceof Integer) {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt((Integer)object);
        } else if (object instanceof Long) {
            dataOutputStream.writeByte(2);
            dataOutputStream.writeLong((Long)object);
        } else if (object instanceof Double) {
            dataOutputStream.writeByte(3);
            dataOutputStream.writeDouble((Double)object);
        } else if (object instanceof Boolean) {
            dataOutputStream.writeByte(4);
            dataOutputStream.writeBoolean((Boolean)object);
        } else if (object instanceof PlaceholderMap) {
            dataOutputStream.writeByte(5);
            ((PlaceholderMap)object).write(dataOutputStream);
        } else if (object instanceof Object[]) {
            dataOutputStream.writeByte(6);
            Object[] objectArray = (Object[])object;
            dataOutputStream.writeInt(objectArray.length);
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray2[n2];
                this.write(object2, dataOutputStream);
                ++n2;
            }
        } else if (object instanceof Path) {
            dataOutputStream.writeByte(7);
            dataOutputStream.writeUTF(((Path)object).toString());
        } else {
            throw new IOException("unknown type: " + object.getClass());
        }
    }

    private Object read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        byte by = dataInputStream.readByte();
        switch (by) {
            case 0: {
                return dataInputStream.readUTF();
            }
            case 1: {
                return dataInputStream.readInt();
            }
            case 2: {
                return dataInputStream.readLong();
            }
            case 3: {
                return dataInputStream.readDouble();
            }
            case 4: {
                return dataInputStream.readBoolean();
            }
            case 5: {
                return new PlaceholderMap(dataInputStream, placeholderStrategy);
            }
            case 6: {
                int n = dataInputStream.readInt();
                Object[] objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = this.read(dataInputStream, placeholderStrategy);
                    ++n2;
                }
                return objectArray;
            }
            case 7: {
                return new Path(dataInputStream.readUTF());
            }
        }
        throw new IOException("illegal format");
    }

    public void write(XElement xElement) {
        xElement.addElement("version").setInt(this.version);
        xElement.addElement("format").setString(this.format.toString());
        for (Map.Entry<Key, Map<String, Object>> entry : this.data.entrySet()) {
            XElement xElement2 = xElement.addElement("entry");
            ((PlaceholderKey)entry.getKey()).write(xElement2.addElement("key"));
            Map<String, Object> map = entry.getValue();
            for (Map.Entry<String, Object> entry2 : map.entrySet()) {
                XElement xElement3 = xElement2.addElement("item");
                xElement3.addString("key", entry2.getKey());
                this.write(entry2.getValue(), xElement3);
            }
        }
    }

    private void write(Object object, XElement xElement) {
        if (object instanceof String) {
            xElement.addString("type", "s");
            xElement.setString((String)object);
        } else if (object instanceof Integer) {
            xElement.addString("type", "i");
            xElement.setInt((Integer)object);
        } else if (object instanceof Long) {
            xElement.addString("type", "l");
            xElement.setLong((Long)object);
        } else if (object instanceof Double) {
            xElement.addString("type", "d");
            xElement.setDouble((Double)object);
        } else if (object instanceof Boolean) {
            xElement.addString("type", "b");
            xElement.setBoolean((Boolean)object);
        } else if (object instanceof PlaceholderMap) {
            xElement.addString("type", "p");
            ((PlaceholderMap)object).write(xElement);
        } else if (object instanceof Object[]) {
            Object[] objectArray;
            xElement.addString("type", "a");
            Object[] objectArray2 = objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray2[n2];
                this.write(object2, xElement.addElement("item"));
                ++n2;
            }
        } else if (object instanceof Path) {
            xElement.addString("type", "t");
            xElement.setString(((Path)object).toString());
        } else {
            throw new XException("unknown type: " + object.getClass());
        }
    }

    private Object read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        String string = xElement.getString("type");
        if ("s".equals(string)) {
            return xElement.getString();
        }
        if ("i".equals(string)) {
            return xElement.getInt();
        }
        if ("l".equals(string)) {
            return xElement.getLong();
        }
        if ("d".equals(string)) {
            return xElement.getDouble();
        }
        if ("b".equals(string)) {
            return xElement.getBoolean();
        }
        if ("p".equals(string)) {
            return new PlaceholderMap(xElement, placeholderStrategy);
        }
        if ("a".equals(string)) {
            XElement[] xElementArray = xElement.getElements("item");
            Object[] objectArray = new Object[xElementArray.length];
            int n = 0;
            while (n < xElementArray.length) {
                objectArray[n] = this.read(xElementArray[n], placeholderStrategy);
                ++n;
            }
            return objectArray;
        }
        if ("t".equals(string)) {
            return new Path(xElement.getString());
        }
        throw new XException("unknown type: " + string);
    }

    public PlaceholderMap copy() {
        PlaceholderMap placeholderMap = new PlaceholderMap(this.format, this.version);
        for (Map.Entry<Key, Map<String, Object>> entry : this.data.entrySet()) {
            Key key = placeholderMap.copyKey(entry.getKey());
            placeholderMap.add(key);
            Map<String, Object> map = placeholderMap.data.get(key);
            for (Map.Entry<String, Object> entry2 : entry.getValue().entrySet()) {
                map.put(entry2.getKey(), this.copy(entry2.getValue()));
            }
        }
        return placeholderMap;
    }

    public PlaceholderMap filter(PlaceholderStrategy placeholderStrategy) {
        if (placeholderStrategy == null || this.strategy == placeholderStrategy) {
            return this;
        }
        PlaceholderMap placeholderMap = this.copy();
        placeholderMap.setPlaceholderStrategy(placeholderStrategy);
        placeholderMap.setPlaceholderStrategy(null);
        return placeholderMap;
    }

    private Object copy(Object object) {
        if (object instanceof String) {
            return object;
        }
        if (object instanceof Integer) {
            return object;
        }
        if (object instanceof Long) {
            return object;
        }
        if (object instanceof Double) {
            return object;
        }
        if (object instanceof Boolean) {
            return object;
        }
        if (object instanceof PlaceholderMap) {
            return ((PlaceholderMap)object).copy();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray2.length) {
                objectArray2[n] = this.copy(objectArray[n]);
                ++n;
            }
            return objectArray2;
        }
        throw new IllegalArgumentException("unknown type: " + object.getClass());
    }

    public Key newKey(Path ... pathArray) {
        return this.newKey((String)null, pathArray);
    }

    public Key newKey(String string, Path ... pathArray) {
        return new PlaceholderKey(string, pathArray, true);
    }

    public Key newUniqueKey(Path ... pathArray) {
        return this.newUniqueKey((String)null, pathArray);
    }

    public Key newUniqueKey(String string, Path ... pathArray) {
        return new PlaceholderKey(string, pathArray, false);
    }

    public Key copyKey(Key key) {
        return new PlaceholderKey(key.getAnchor(), key.getPlaceholders(), key.isShared());
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        if (this.strategy != null) {
            this.strategy.removeListener(this.listener);
        }
        this.strategy = placeholderStrategy;
        for (Map<String, Object> map : this.data.values()) {
            for (Object object : map.values()) {
                this.setPlaceholderStrategy(object, placeholderStrategy);
            }
        }
        if (this.strategy != null) {
            this.validate(this.strategy, false);
            this.strategy.addListener(this.listener);
        }
    }

    private void setPlaceholderStrategy(Object object, PlaceholderStrategy placeholderStrategy) {
        if (object instanceof PlaceholderMap) {
            ((PlaceholderMap)object).setPlaceholderStrategy(placeholderStrategy);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray[n2];
                this.setPlaceholderStrategy(object2, placeholderStrategy);
                ++n2;
            }
        }
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.strategy;
    }

    public void validate(PlaceholderStrategy placeholderStrategy, boolean bl) {
        Key[] keyArray;
        if (placeholderStrategy == null) {
            return;
        }
        if (bl) {
            for (Map<String, Object> object2 : this.data.values()) {
                for (Object n2 : object2.values()) {
                    this.validate(n2, placeholderStrategy);
                }
            }
        }
        Key[] keyArray2 = keyArray = this.data.keySet().toArray(new Key[this.data.size()]);
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Key key = keyArray2[n2];
            PlaceholderKey placeholderKey = ((PlaceholderKey)key).shrink(placeholderStrategy);
            if (placeholderKey != key) {
                Map<String, Object> map = this.data.remove(key);
                if (placeholderKey != null) {
                    this.data.put(placeholderKey, map);
                }
            }
            ++n2;
        }
    }

    private void validate(Object object, PlaceholderStrategy placeholderStrategy) {
        if (object instanceof PlaceholderMap) {
            ((PlaceholderMap)object).validate(placeholderStrategy, true);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray[n2];
                this.validate(object2, placeholderStrategy);
                ++n2;
            }
        }
    }

    public void removeAll(Path path, boolean bl) {
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        this.removeAll(hashSet, bl);
    }

    public void removeAll(Set<Path> set, boolean bl) {
        Key[] keyArray;
        if (set.isEmpty()) {
            return;
        }
        if (bl) {
            for (Map<String, Object> object2 : this.data.values()) {
                for (Object n2 : object2.values()) {
                    this.removeAll(n2, set);
                }
            }
        }
        Key[] keyArray2 = keyArray = this.data.keySet().toArray(new Key[this.data.size()]);
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Key key = keyArray2[n2];
            PlaceholderKey placeholderKey = ((PlaceholderKey)key).shrink(set);
            if (placeholderKey != key) {
                Map<String, Object> map = this.data.remove(key);
                if (placeholderKey != null) {
                    this.data.put(placeholderKey, map);
                }
            }
            ++n2;
        }
    }

    private void removeAll(Object object, Set<Path> set) {
        if (object instanceof PlaceholderMap) {
            ((PlaceholderMap)object).removeAll(set, true);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray[n2];
                this.removeAll(object2, set);
                ++n2;
            }
        }
    }

    public int getVersion() {
        return this.version;
    }

    public Path getFormat() {
        return this.format;
    }

    public void add(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("placeholder must not be null");
        }
        Map<String, Object> map = this.data.get(key);
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
            this.data.put(key, map);
        }
    }

    public void remove(Key key) {
        this.data.remove(key);
    }

    public Key[] getPlaceholders() {
        Set<Key> set = this.data.keySet();
        return set.toArray(new Key[set.size()]);
    }

    public String[] getKeys(Key key) {
        Map<String, Object> map = this.data.get(key);
        if (map == null) {
            return null;
        }
        Set<String> set = map.keySet();
        return set.toArray(new String[set.size()]);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void putString(Key key, String string, String string2) {
        this.put(key, string, string2);
    }

    public void putPath(Key key, String string, Path path) {
        this.put(key, string, path);
    }

    public void putInt(Key key, String string, int n) {
        this.put(key, string, n);
    }

    public void putLong(Key key, String string, long l) {
        this.put(key, string, l);
    }

    public void putBoolean(Key key, String string, boolean bl) {
        this.put(key, string, bl);
    }

    public void putDouble(Key key, String string, double d) {
        this.put(key, string, d);
    }

    public void putMap(Key key, String string, PlaceholderMap placeholderMap) {
        this.put(key, string, placeholderMap);
    }

    public void putArray(Key key, String string, Object[] objectArray) {
        this.put(key, string, objectArray);
    }

    public void put(Key key, String string, Object object) {
        Class<?> clazz = this.invalidType(object);
        if (clazz != null) {
            throw new IllegalArgumentException("value of illegal type: " + (clazz instanceof String ? clazz : clazz.getClass()));
        }
        this.add(key);
        this.data.get(key).put(string, object);
    }

    private Object invalidType(Object object) {
        if (object instanceof String || object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Boolean || object instanceof Path || object instanceof PlaceholderMap) {
            return null;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray[n2];
                Object object3 = this.invalidType(object2);
                if (object3 != null) {
                    return object3;
                }
                ++n2;
            }
        }
        if (object == null) {
            return "null";
        }
        return null;
    }

    public Object remove(Key key, String string) {
        Map<String, Object> map = this.data.get(key);
        if (map == null) {
            return null;
        }
        return map.remove(string);
    }

    public boolean contains(Key key, String string) {
        return this.get(key, string) != null;
    }

    public String getString(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException("\"" + string + "\" is not a string");
    }

    public Path getPath(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof Path) {
            return (Path)object;
        }
        throw new IllegalArgumentException();
    }

    public int getInt(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new IllegalArgumentException();
    }

    public long getLong(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof Long) {
            return (Long)object;
        }
        throw new IllegalArgumentException();
    }

    public boolean getBoolean(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new IllegalArgumentException();
    }

    public double getDouble(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof Double) {
            return (Double)object;
        }
        throw new IllegalArgumentException();
    }

    public PlaceholderMap getMap(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof PlaceholderMap) {
            return (PlaceholderMap)object;
        }
        throw new IllegalArgumentException();
    }

    public Object[] getArray(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        throw new IllegalArgumentException();
    }

    public Object get(Key key, String string) {
        Map<String, Object> map = this.data.get(key);
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    public String toString() {
        return this.data.toString();
    }

    public static interface Key {
        public Path[] getPlaceholders();

        public boolean contains(Path var1);

        public String getAnchor();

        public boolean isShared();
    }

    private class PlaceholderKey
    implements Key {
        private Path[] placeholders;
        private String anchor;
        private boolean shared;

        public PlaceholderKey(String string, Path[] pathArray, boolean bl) {
            if (pathArray == null) {
                throw new IllegalArgumentException("placeholders must not be null");
            }
            Path[] pathArray2 = pathArray;
            int n = pathArray.length;
            int n2 = 0;
            while (n2 < n) {
                Path path = pathArray2[n2];
                if (path == null) {
                    throw new IllegalArgumentException("placeholders does contain a null value");
                }
                ++n2;
            }
            this.anchor = string;
            this.placeholders = pathArray;
            this.shared = bl;
        }

        public PlaceholderKey(DataInputStream dataInputStream, Version version) throws IOException {
            this.shared = dataInputStream.readBoolean();
            if (Version.VERSION_1_1_1.compareTo(version) <= 0 && dataInputStream.readBoolean()) {
                this.anchor = dataInputStream.readUTF();
            }
            this.placeholders = new Path[dataInputStream.readInt()];
            int n = 0;
            while (n < this.placeholders.length) {
                this.placeholders[n] = new Path(dataInputStream.readUTF());
                ++n;
            }
        }

        public PlaceholderKey(XElement xElement) {
            this.shared = xElement.getBoolean("shared");
            XElement xElement2 = xElement.getElement("anchor");
            if (xElement2 != null) {
                this.anchor = xElement2.getString();
            }
            XElement[] xElementArray = xElement.getElements("placeholder");
            this.placeholders = new Path[xElementArray.length];
            int n = 0;
            while (n < xElementArray.length) {
                this.placeholders[n] = new Path(xElementArray[n].getString());
                ++n;
            }
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeBoolean(this.shared);
            if (this.anchor != null) {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeUTF(this.anchor);
            } else {
                dataOutputStream.writeBoolean(false);
            }
            dataOutputStream.writeInt(this.placeholders.length);
            Path[] pathArray = this.placeholders;
            int n = this.placeholders.length;
            int n2 = 0;
            while (n2 < n) {
                Path path = pathArray[n2];
                dataOutputStream.writeUTF(path.toString());
                ++n2;
            }
        }

        public void write(XElement xElement) {
            xElement.addBoolean("shared", this.shared);
            if (this.anchor != null) {
                xElement.addElement("anchor").setString(this.anchor);
            }
            Path[] pathArray = this.placeholders;
            int n = this.placeholders.length;
            int n2 = 0;
            while (n2 < n) {
                Path path = pathArray[n2];
                xElement.addElement("placeholder").setString(path.toString());
                ++n2;
            }
        }

        public PlaceholderKey shrink(PlaceholderStrategy placeholderStrategy) {
            if (placeholderStrategy == null) {
                return this;
            }
            boolean[] blArray = new boolean[this.placeholders.length];
            int n = 0;
            int n2 = 0;
            while (n2 < blArray.length) {
                blArray[n2] = placeholderStrategy.isValidPlaceholder(this.placeholders[n2]);
                if (blArray[n2]) {
                    ++n;
                }
                ++n2;
            }
            if (n == this.placeholders.length) {
                return this;
            }
            if (n == 0 && this.anchor == null) {
                return null;
            }
            Path[] pathArray = new Path[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.placeholders.length) {
                if (blArray[n4]) {
                    pathArray[n3++] = this.placeholders[n4];
                }
                ++n4;
            }
            return new PlaceholderKey(this.anchor, pathArray, this.shared);
        }

        public PlaceholderKey shrink(Set<Path> set) {
            boolean[] blArray = new boolean[this.placeholders.length];
            int n = 0;
            int n2 = 0;
            while (n2 < blArray.length) {
                boolean bl = blArray[n2] = !set.contains(this.placeholders[n2]);
                if (blArray[n2]) {
                    ++n;
                }
                ++n2;
            }
            if (n == this.placeholders.length) {
                return this;
            }
            if (n == 0 && this.anchor == null) {
                return null;
            }
            Path[] pathArray = new Path[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.placeholders.length) {
                if (blArray[n4]) {
                    pathArray[n3++] = this.placeholders[n4];
                }
                ++n4;
            }
            return new PlaceholderKey(this.anchor, pathArray, this.shared);
        }

        @Override
        public Path[] getPlaceholders() {
            return this.placeholders;
        }

        @Override
        public boolean contains(Path path) {
            Path[] pathArray = this.placeholders;
            int n = this.placeholders.length;
            int n2 = 0;
            while (n2 < n) {
                Path path2 = pathArray[n2];
                if (path2.equals(path)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public boolean isShared() {
            return this.shared;
        }

        @Override
        public String getAnchor() {
            return this.anchor;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Path[] pathArray = this.placeholders;
            int n = this.placeholders.length;
            int n2 = 0;
            while (n2 < n) {
                Path path = pathArray[n2];
                stringBuilder.append(path);
                stringBuilder.append(", ");
                ++n2;
            }
            if (this.anchor != null) {
                stringBuilder.append(", anchor=").append(this.anchor).append(", ");
            }
            stringBuilder.append("shared=");
            stringBuilder.append(this.shared);
            return stringBuilder.toString();
        }

        public int hashCode() {
            int n = Arrays.hashCode(this.placeholders);
            if (this.shared) {
                return n;
            }
            return -n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!this.isShared()) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            PlaceholderKey placeholderKey = (PlaceholderKey)object;
            if (!placeholderKey.isShared()) {
                return false;
            }
            if (this.anchor == null && placeholderKey.getAnchor() != null) {
                return false;
            }
            if (this.anchor != null && !this.anchor.equals(placeholderKey.getAnchor())) {
                return false;
            }
            return Arrays.equals(this.placeholders, placeholderKey.placeholders);
        }
    }
}

