/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderMetaMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.util.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class PlaceholderList<D, S, P extends PlaceholderListItem<D>> {
    private PlaceholderStrategy strategy;
    private Entry head = null;
    private Entry headPlaceholder = null;
    private Entry headDockable = null;
    private SubList<Item> allItems = new SubList<Item>(this, this, Level.BASE){
        final /* synthetic */ PlaceholderList this$0;
        {
            this.this$0 = placeholderList2;
            super(level);
        }

        @Override
        protected Item wrap(Item item) {
            return item;
        }

        @Override
        protected boolean visible(Item item) {
            return true;
        }

        @Override
        protected Item unwrap(Item item) {
            return item;
        }
    };
    private SubList<Set<Path>> allPlaceholders = new SubList<Set<Path>>(this, this, Level.BASE){
        final /* synthetic */ PlaceholderList this$0;
        {
            this.this$0 = placeholderList2;
            super(level);
        }

        @Override
        protected Item wrap(Set<Path> set) {
            return new Item(this.this$0, set);
        }

        @Override
        protected boolean visible(Item item) {
            return true;
        }

        @Override
        protected Set<Path> unwrap(Item item) {
            Set<Path> set = item.getPlaceholderSet();
            if (set == null) {
                return Collections.emptySet();
            }
            return set;
        }
    };
    private SubList<Set<Path>> purePlaceholders = new SubList<Set<Path>>(this, this, Level.PLACEHOLDER){
        final /* synthetic */ PlaceholderList this$0;
        {
            this.this$0 = placeholderList2;
            super(level);
        }

        @Override
        protected Item wrap(Set<Path> set) {
            return new Item(this.this$0, set);
        }

        @Override
        protected boolean visible(Item item) {
            return item.isPlaceholder();
        }

        @Override
        protected Set<Path> unwrap(Item item) {
            return item.getPlaceholderSet();
        }
    };
    private SubList<P> dockables = new SubList<P>(this, this, Level.DOCKABLE){
        final /* synthetic */ PlaceholderList this$0;
        {
            this.this$0 = placeholderList2;
            super(level);
        }

        @Override
        protected Item wrap(P p) {
            return new Item(this.this$0, p);
        }

        @Override
        protected boolean visible(Item item) {
            return !item.isPlaceholder();
        }

        @Override
        protected P unwrap(Item item) {
            return item.getDockable();
        }

        @Override
        public void add(int n, P p) {
            super.add(n, p);
            this.removeDockable(p.asDockable());
        }

        private void removeDockable(D d) {
            Object s;
            Path path = this.this$0.getPlaceholder(d);
            if (path != null) {
                this.this$0.removeAll(path);
            }
            if ((s = this.this$0.toStation(d)) != null) {
                D[] DArray = this.this$0.getChildren(s);
                int n = DArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object d2 = DArray[n2];
                    this.removeDockable(d2);
                    ++n2;
                }
            }
        }
    };
    private PlaceholderStrategyListener listener = new PlaceholderStrategyListener(){

        @Override
        public void placeholderInvalidated(Set<Path> set) {
            PlaceholderList.this.removeAll(set);
        }
    };
    private boolean bound = false;

    public PlaceholderList() {
    }

    public PlaceholderList(PlaceholderMap placeholderMap, PlaceholderListItemConverter<D, P> placeholderListItemConverter) {
        this.read(placeholderMap, placeholderListItemConverter);
    }

    protected abstract Path getPlaceholder(D var1);

    protected abstract String toString(D var1);

    protected abstract S toStation(D var1);

    protected abstract PlaceholderMap getPlaceholders(S var1);

    protected abstract void setPlaceholders(S var1, PlaceholderMap var2);

    private boolean hasChildren(S s) {
        return this.getChildren(s).length > 0;
    }

    protected abstract D[] getChildren(S var1);

    public void read(PlaceholderMap placeholderMap, PlaceholderListItemConverter<D, P> placeholderListItemConverter) {
        this.read(placeholderMap, placeholderListItemConverter, false);
    }

    protected void read(PlaceholderMap placeholderMap, PlaceholderListItemConverter<D, P> placeholderListItemConverter, boolean bl) {
        if (placeholderListItemConverter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        if (!placeholderMap.getFormat().equals(new Path("dock.PlaceholderList"))) {
            throw new IllegalArgumentException("unknown format: " + placeholderMap.getFormat());
        }
        if (placeholderMap.getVersion() != 0) {
            throw new IllegalArgumentException("version unknown: " + placeholderMap.getVersion());
        }
        PlaceholderMap.Key[] keyArray = placeholderMap.getPlaceholders();
        int n = 0;
        int n2 = keyArray.length;
        while (n < n2) {
            String string;
            int n3;
            Object[] objectArray;
            Object object;
            Object object2;
            HashSet<Path> hashSet = null;
            if (!bl && ((Path[])(object2 = keyArray[n].getPlaceholders())).length > 0) {
                hashSet = new HashSet<Path>();
                Path[] pathArray = object2;
                int n4 = ((Path[])object2).length;
                int n5 = 0;
                while (n5 < n4) {
                    object = pathArray[n5];
                    hashSet.add((Path)object);
                    ++n5;
                }
            }
            object2 = null;
            if (placeholderMap.contains(keyArray[n], "convert")) {
                Object[] objectArray2;
                object = new ConvertedPlaceholderListItem();
                objectArray = objectArray2 = placeholderMap.getArray(keyArray[n], "convert-keys");
                n3 = objectArray2.length;
                int n6 = 0;
                while (n6 < n3) {
                    Object object3 = objectArray[n6];
                    string = (String)object3;
                    ((PlaceholderMetaMap)object).put(string, placeholderMap.get(keyArray[n], "dock." + string));
                    ++n6;
                }
                if (placeholderMap.contains(keyArray[n], "map")) {
                    ((ConvertedPlaceholderListItem)object).setPlaceholderMap(placeholderMap.getMap(keyArray[n], "map"));
                }
                object2 = placeholderListItemConverter.convert((ConvertedPlaceholderListItem)object);
            }
            if (!bl) {
                object = null;
                if (object2 == null) {
                    if (hashSet != null && !hashSet.isEmpty()) {
                        object = new Item(this, hashSet);
                    }
                } else {
                    object = new Item(this, (PlaceholderListItem)object2, hashSet, null);
                }
                if (object != null) {
                    if (placeholderMap.contains(keyArray[n], "map")) {
                        ((Item)object).setPlaceholderMap(placeholderMap.getMap(keyArray[n], "map"));
                    }
                    if (placeholderMap.contains(keyArray[n], "item")) {
                        Object[] objectArray3;
                        objectArray = objectArray3 = placeholderMap.getArray(keyArray[n], "item-keys");
                        n3 = objectArray3.length;
                        int n7 = 0;
                        while (n7 < n3) {
                            Object object4 = objectArray[n7];
                            string = (String)object4;
                            ((PlaceholderMetaMap)object).put(string, placeholderMap.get(keyArray[n], "item." + string));
                            ++n7;
                        }
                    }
                    this.list().add((Item)object);
                }
            }
            if (object2 != null) {
                placeholderListItemConverter.added((Path[])object2);
            }
            ++n;
        }
    }

    public PlaceholderMap toMap(PlaceholderListItemConverter<?, ? super P> placeholderListItemConverter) {
        if (placeholderListItemConverter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        PlaceholderMap placeholderMap = new PlaceholderMap(new Path("dock.PlaceholderList"), 0);
        int n = 0;
        for (Item item : this.list()) {
            String string;
            int n2;
            int n3;
            String[] stringArray;
            String[] stringArray2;
            Object object;
            Set<Path> set = item.getPlaceholderSet();
            if (set == null) {
                set = Collections.emptySet();
            }
            set = new HashSet<Path>(set);
            Path[] pathArray = item.getPlaceholderMap();
            Path path = null;
            Object p = item.getDockable();
            ConvertedPlaceholderListItem convertedPlaceholderListItem = null;
            if (p != null && (convertedPlaceholderListItem = placeholderListItemConverter.convert(n, p)) != null) {
                path = convertedPlaceholderListItem.getPlaceholder();
                object = convertedPlaceholderListItem.getPlaceholderMap();
                if (object != null) {
                    pathArray = object;
                }
            }
            if (!item.isPlaceholder()) {
                ++n;
            }
            if (path != null) {
                set.add(path);
            }
            if (((Path[])(object = set.toArray(new Path[set.size()]))).length <= 0 && convertedPlaceholderListItem == null) continue;
            PlaceholderMap.Key key = placeholderMap.newUniqueKey((Path)object);
            placeholderMap.add(key);
            if (pathArray != null) {
                placeholderMap.put(key, "map", pathArray);
            }
            if (convertedPlaceholderListItem != null) {
                placeholderMap.put(key, "convert", true);
                stringArray2 = convertedPlaceholderListItem.keys();
                placeholderMap.put(key, "convert-keys", stringArray2);
                stringArray = stringArray2;
                n3 = stringArray2.length;
                n2 = 0;
                while (n2 < n3) {
                    string = stringArray[n2];
                    placeholderMap.put(key, "dock." + string, convertedPlaceholderListItem.get(string));
                    ++n2;
                }
            }
            if ((stringArray2 = item.keys()).length <= 0) continue;
            placeholderMap.put(key, "item", true);
            placeholderMap.put(key, "item-keys", stringArray2);
            stringArray = stringArray2;
            n3 = stringArray2.length;
            n2 = 0;
            while (n2 < n3) {
                string = stringArray[n2];
                placeholderMap.put(key, "item." + string, item.get(string));
                ++n2;
            }
        }
        return placeholderMap;
    }

    public void bind() {
        if (!this.bound) {
            this.bound = true;
            if (this.strategy != null) {
                this.strategy.addListener(this.listener);
                for (Item item : this.list()) {
                    item.setStrategy(this.strategy);
                }
                this.checkAllPlaceholders();
            }
        }
    }

    public void unbind() {
        if (this.bound) {
            this.bound = false;
            if (this.strategy != null) {
                this.strategy.removeListener(this.listener);
                for (Item item : this.list()) {
                    item.setStrategy(null);
                }
            }
        }
    }

    public PlaceholderStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(PlaceholderStrategy placeholderStrategy) {
        if (this.bound) {
            if (this.strategy != null) {
                this.strategy.removeListener(this.listener);
            }
            this.strategy = placeholderStrategy;
            if (this.strategy != null) {
                this.strategy.addListener(this.listener);
            }
            for (Item item : this.list()) {
                item.setStrategy(placeholderStrategy);
            }
            this.checkAllPlaceholders();
        } else {
            this.strategy = placeholderStrategy;
        }
    }

    private void checkAllPlaceholders() {
        if (this.strategy != null) {
            Iterator iterator = this.list().iterator();
            while (iterator.hasNext()) {
                Item item = (Item)iterator.next();
                Set<Path> set = item.getPlaceholderSet();
                if (set != null) {
                    Iterator<Path> iterator2 = set.iterator();
                    while (iterator2.hasNext()) {
                        if (this.strategy.isValidPlaceholder(iterator2.next())) continue;
                        iterator2.remove();
                    }
                }
                if (set != null && !set.isEmpty() || !item.isPlaceholder()) continue;
                iterator.remove();
            }
        }
    }

    public void insertAllPlaceholders() {
        if (this.strategy != null) {
            for (Item item : this.list()) {
                Path path;
                Object p = item.getDockable();
                if (p == null || (path = this.getPlaceholder(p.asDockable())) == null) continue;
                item.add(path);
            }
        }
    }

    public Filter<P> dockables() {
        return this.dockables;
    }

    public Filter<Set<Path>> purePlaceholders() {
        return this.purePlaceholders;
    }

    public Filter<Item> list() {
        return this.allItems;
    }

    public Filter<Set<Path>> listPlaceholders() {
        return this.allPlaceholders;
    }

    public void removeAll(Set<Path> set) {
        Iterator iterator = this.list().iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            item.removeAll(set);
            if (item.getPlaceholderSet() != null || !item.isPlaceholder()) continue;
            iterator.remove();
        }
    }

    public void removeAll(Path path) {
        this.ensureRemoved(null, path);
    }

    private void ensureRemoved(Item item, Path path) {
        Iterator iterator = this.list().iterator();
        while (iterator.hasNext()) {
            Item item2 = (Item)iterator.next();
            if (item2 == item) continue;
            item2.remove(path);
            if (item2.getPlaceholderSet() != null || !item2.isPlaceholder()) continue;
            iterator.remove();
        }
    }

    public Path remove(int n) {
        Entry entry = this.search(n, Level.DOCKABLE);
        if (entry == null) {
            throw new IllegalArgumentException("no such dockable: " + n);
        }
        return this.removeDockable(entry);
    }

    public Path remove(P p) {
        Entry entry = this.search(p);
        if (entry == null) {
            return null;
        }
        return this.removeDockable(entry);
    }

    private Path removeDockable(Entry entry) {
        Object p = entry.item.getDockable();
        Path path = this.getPlaceholder(p.asDockable());
        if (path == null) {
            entry.item.setDockable(null);
        } else {
            entry.item.add(path);
            entry.item.setDockable(null);
        }
        S s = this.toStation(p.asDockable());
        if (s != null) {
            PlaceholderMap placeholderMap = this.getPlaceholders(s);
            entry.item.setPlaceholderMap(placeholderMap);
            if (placeholderMap != null) {
                PlaceholderMap.Key[] keyArray = placeholderMap.getPlaceholders();
                int n = keyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PlaceholderMap.Key key = keyArray[n2];
                    Path[] pathArray = key.getPlaceholders();
                    int n3 = pathArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Path path2 = pathArray[n4];
                        entry.item.add(path2);
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        if (!entry.item.hasPlaceholders()) {
            entry.remove();
        }
        return path;
    }

    public int put(Path path, P p) {
        Path path2;
        if (p == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        Entry entry = this.search(path);
        if (entry == null) {
            return -1;
        }
        entry.set(new Item(this, p, entry.item.getPlaceholderSet(), entry.item.getPlaceholderMap()));
        S s = this.toStation(p.asDockable());
        PlaceholderMap placeholderMap = entry.item.getPlaceholderMap();
        if (s != null && placeholderMap != null && !this.hasChildren(s)) {
            entry.item.setPlaceholderMap(null);
            this.setPlaceholders(s, placeholderMap);
        }
        this.removeAll(path);
        if (this.strategy != null && (path2 = this.getPlaceholder(p.asDockable())) != null && !path2.equals(path)) {
            this.removeAll(path2);
        }
        return entry.index(Level.DOCKABLE);
    }

    /*
     * Unable to fully structure code
     */
    public int getDockableIndex(Path var1_1) {
        var2_2 = this.search(var1_1);
        if (var2_2 != null) ** GOTO lbl5
        return -1;
lbl-1000:
        // 1 sources

        {
            var2_2 = var2_2.previous(Level.BASE);
lbl5:
            // 2 sources

            ** while (var2_2 != null && Entry.access$1((Entry)var2_2).isPlaceholder())
        }
lbl6:
        // 1 sources

        if (var2_2 == null) {
            return 0;
        }
        return var2_2.index(Level.DOCKABLE) + 1;
    }

    public int getListIndex(Path path) {
        Entry entry = this.search(path);
        if (entry == null) {
            return -1;
        }
        return entry.index(Level.BASE);
    }

    public int getListIndex(int n, Path path) {
        int n2 = -1;
        if (path != null && (n2 = this.getListIndex(path)) == -1) {
            this.insertAllPlaceholders();
            n2 = this.getListIndex(path);
        }
        if (n2 == -1) {
            n2 = n;
        }
        n2 = Math.min(n2, this.list().size());
        return n2;
    }

    public int getNextListIndex(int n, Path path) {
        int n2 = this.getListIndex(n, path);
        ++n2;
        n2 = Math.min(n2, this.list().size());
        return n2;
    }

    public boolean hasPlaceholder(Path path) {
        return this.search(path) != null;
    }

    public boolean put(P p, Path path) {
        Entry entry = this.search(p);
        if (entry == null) {
            return false;
        }
        this.removeAll(path);
        entry.item.add(path);
        return true;
    }

    public P getDockableAt(Path path) {
        Entry entry = this.search(path);
        if (entry == null) {
            return null;
        }
        return entry.item.getDockable();
    }

    public PlaceholderMetaMap getMetaMap(Path path) {
        Entry entry = this.search(path);
        if (entry == null) {
            return null;
        }
        return entry.item;
    }

    public PlaceholderMap getMap(Path path) {
        Entry entry = this.search(path);
        if (entry == null) {
            return null;
        }
        return entry.item.placeholderMap;
    }

    public Item getItem(Path path) {
        int n = this.getListIndex(path);
        if (n == -1) {
            this.insertAllPlaceholders();
            n = this.getListIndex(path);
        }
        if (n != -1) {
            return this.list().get(n);
        }
        return null;
    }

    public Item getItem(D d) {
        Entry entry = this.search((P)d);
        if (entry == null) {
            return null;
        }
        return entry.item;
    }

    public void addPlaceholder(D d, Path path) {
        if (d == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        Item item = this.getItem(d);
        if (item == null) {
            throw new IllegalArgumentException("unable to find item for dockable");
        }
        this.ensureRemoved(item, path);
        item.add(path);
    }

    public int size(Level level) {
        switch (level) {
            case BASE: {
                return this.list().size();
            }
            case DOCKABLE: {
                return this.dockables().size();
            }
            case PLACEHOLDER: {
                return this.purePlaceholders().size();
            }
        }
        throw new IllegalArgumentException("unknown level: " + (Object)((Object)level));
    }

    private Entry search(Path path) {
        Entry entry = this.head;
        while (entry != null) {
            Set<Path> set = entry.item.getPlaceholderSet();
            if (set != null && set.contains(path)) {
                return entry;
            }
            entry = entry.next(Level.BASE);
        }
        return null;
    }

    private Entry search(D d) {
        Entry entry = this.head(Level.DOCKABLE);
        while (entry != null) {
            if (entry.item.getDockable().asDockable() == d) {
                return entry;
            }
            entry = entry.next(Level.DOCKABLE);
        }
        return null;
    }

    private Entry search(P p) {
        Entry entry = this.head(Level.DOCKABLE);
        while (entry != null) {
            if (entry.item.getDockable() == p) {
                return entry;
            }
            entry = entry.next(Level.DOCKABLE);
        }
        return null;
    }

    private Entry search(int n, Level level) {
        Entry entry = this.head(level);
        while (entry != null && n > 0) {
            entry = entry.next(level);
            --n;
        }
        return entry;
    }

    public int baseToLevel(int n, Level level) {
        Entry entry = this.search(n, Level.BASE);
        if (entry == null) {
            throw new IndexOutOfBoundsException();
        }
        return entry.index(level);
    }

    public int levelToBase(int n, Level level) {
        Entry entry = this.search(n, level);
        if (entry == null) {
            throw new IndexOutOfBoundsException();
        }
        return entry.index(Level.BASE);
    }

    public void clear() {
        this.head = null;
        this.headDockable = null;
        this.headPlaceholder = null;
        this.invalidate();
    }

    private Entry head(Level level) {
        switch (level) {
            case BASE: {
                return this.head;
            }
            case PLACEHOLDER: {
                return this.headPlaceholder;
            }
            case DOCKABLE: {
                return this.headDockable;
            }
        }
        throw new IllegalArgumentException();
    }

    private void invalidate() {
        this.dockables.invalidate();
        this.allPlaceholders.invalidate();
        this.purePlaceholders.invalidate();
        this.allItems.invalidate();
    }

    public String toString() {
        return this.list().toString();
    }

    private class Entry {
        private Item item;
        private boolean itemWasPlaceholder;
        private Entry next;
        private Entry previous;
        private Entry nextLevel;
        private Entry previousLevel;

        public Entry(Entry entry, Item item) {
            this.item = item;
            this.insertAfter(entry);
        }

        public void insertAfter(Entry entry) {
            Entry entry2;
            PlaceholderList.this.invalidate();
            this.item.setOwner(this);
            this.itemWasPlaceholder = this.item.isPlaceholder();
            Entry entry3 = null;
            if (entry == null) {
                this.next = PlaceholderList.this.head;
                if (PlaceholderList.this.head != null) {
                    ((PlaceholderList)PlaceholderList.this).head.previous = this;
                }
                PlaceholderList.this.head = this;
                entry3 = null;
            } else {
                this.next = entry.next;
                if (this.next != null) {
                    this.next.previous = this;
                }
                entry.next = this;
                this.previous = entry;
                entry2 = entry;
                while (entry2 != null && entry3 == null) {
                    if (entry2.item.isPlaceholder() == this.item.isPlaceholder()) {
                        entry3 = entry2;
                    }
                    entry2 = entry2.previous(Level.BASE);
                }
            }
            entry2 = null;
            if (entry3 == null) {
                if (this.item.isPlaceholder()) {
                    entry2 = PlaceholderList.this.headPlaceholder;
                    PlaceholderList.this.headPlaceholder = this;
                } else {
                    entry2 = PlaceholderList.this.headDockable;
                    PlaceholderList.this.headDockable = this;
                }
            }
            if (entry3 != null) {
                this.previousLevel = entry3;
                this.nextLevel = entry3.nextLevel;
                if (this.nextLevel != null) {
                    this.nextLevel.previousLevel = this;
                }
                this.previousLevel.nextLevel = this;
            } else if (entry2 != null) {
                this.nextLevel = entry2;
                entry2.previousLevel = this;
            }
        }

        public void move(int n, Level level) {
            if (n == 0) {
                return;
            }
            Entry entry = this;
            if (n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    if ((entry = entry.next(level)) == null) {
                        throw new IllegalArgumentException("delta too big");
                    }
                    ++n2;
                }
            } else {
                int n3 = -n;
                while (n3 >= 0) {
                    if (entry == null) {
                        throw new IllegalArgumentException("delta too big");
                    }
                    entry = entry.previous(level);
                    --n3;
                }
            }
            this.remove();
            this.insertAfter(entry);
        }

        public Entry next(Level level) {
            switch (level) {
                case BASE: {
                    return this.next;
                }
                case PLACEHOLDER: {
                    return this.item.isPlaceholder() ? this.nextLevel : null;
                }
                case DOCKABLE: {
                    return this.item.isPlaceholder() ? null : this.nextLevel;
                }
            }
            throw new IllegalArgumentException();
        }

        public Entry previous(Level level) {
            switch (level) {
                case BASE: {
                    return this.previous;
                }
                case PLACEHOLDER: {
                    return this.item.isPlaceholder() ? this.previousLevel : null;
                }
                case DOCKABLE: {
                    return this.item.isPlaceholder() ? null : this.previousLevel;
                }
            }
            throw new IllegalArgumentException();
        }

        public int index(Level level) {
            Entry entry = PlaceholderList.this.head(level);
            int n = 0;
            while (entry != this && entry != null) {
                entry = entry.next(level);
                ++n;
            }
            if (entry == null) {
                return -1;
            }
            return n;
        }

        public void refresh() {
            this.set(this.item);
        }

        public void set(Item item) {
            this.item.setOwner(null);
            item.setOwner(this);
            if (this.itemWasPlaceholder != item.isPlaceholder()) {
                this.itemWasPlaceholder = item.isPlaceholder();
                PlaceholderList.this.invalidate();
                this.removeLevel();
                Entry entry = this.findLevelPredecessor(item.isPlaceholder());
                Entry entry2 = this.findLevelSuccessor(item.isPlaceholder());
                if (entry == null) {
                    if (item.isPlaceholder()) {
                        PlaceholderList.this.headPlaceholder = this;
                    } else {
                        PlaceholderList.this.headDockable = this;
                    }
                    this.previousLevel = null;
                } else {
                    entry.nextLevel = this;
                    this.previousLevel = entry;
                }
                if (entry2 != null) {
                    this.nextLevel = entry2;
                    entry2.previousLevel = this;
                } else {
                    this.nextLevel = null;
                }
            }
            this.item = item;
        }

        private Entry findLevelPredecessor(boolean bl) {
            Entry entry = this.previous;
            while (entry != null) {
                if (entry.item.isPlaceholder() == bl) {
                    return entry;
                }
                entry = entry.previous;
            }
            return null;
        }

        private Entry findLevelSuccessor(boolean bl) {
            Entry entry = this.next;
            while (entry != null) {
                if (entry.item.isPlaceholder() == bl) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        public void remove() {
            PlaceholderList.this.invalidate();
            if (this.next != null) {
                this.next.previous = this.previous;
            }
            if (this.previous != null) {
                this.previous.next = this.next;
            }
            if (this == PlaceholderList.this.head) {
                PlaceholderList.this.head = this.next;
            }
            this.next = null;
            this.previous = null;
            this.item.setOwner(null);
            this.removeLevel();
        }

        private void removeLevel() {
            PlaceholderList.this.invalidate();
            if (this.nextLevel != null) {
                this.nextLevel.previousLevel = this.previousLevel;
            }
            if (this.previousLevel != null) {
                this.previousLevel.nextLevel = this.nextLevel;
            }
            if (this == PlaceholderList.this.headDockable) {
                PlaceholderList.this.headDockable = this.nextLevel;
            }
            if (this == PlaceholderList.this.headPlaceholder) {
                PlaceholderList.this.headPlaceholder = this.nextLevel;
            }
            this.nextLevel = null;
            this.previousLevel = null;
        }

        public String toString() {
            return this.item.toString();
        }
    }

    public static interface Filter<M>
    extends Iterable<M> {
        public int size();

        public M get(int var1);

        public PlaceholderMetaMap getMetaMap(int var1);

        public void add(M var1);

        public void add(int var1, M var2);

        public void addPlaceholder(int var1, Path var2);

        public void insertPlaceholder(int var1, Path var2);

        public M set(int var1, M var2);

        public M remove(int var1);

        public int remove(M var1);

        public int indexOf(M var1);

        public int indexOfPlaceholder(Path var1);

        public void move(int var1, int var2);

        public void move(Filter<M> var1, int var2, int var3);
    }

    public static class Item
    extends PlaceholderMetaMap {
        private P value;
        private Set<Path> placeholderSet;
        private PlaceholderMap placeholderMap;
        private Entry owner;
        final /* synthetic */ PlaceholderList this$0;

        public Item(P p) {
            this.this$0 = var1_1;
            this.placeholderSet = null;
            if (p == null) {
                throw new IllegalArgumentException("dockable must not be null");
            }
            this.value = p;
        }

        public Item(P p, Set<Path> set, PlaceholderMap placeholderMap) {
            this.this$0 = var1_1;
            this.placeholderSet = null;
            if (p == null) {
                throw new IllegalArgumentException("dockable must not be null");
            }
            this.value = p;
            this.placeholderMap = placeholderMap;
            this.setPlaceholderSet(set);
        }

        public Item(PlaceholderList placeholderList, Set<Path> set) {
            this.this$0 = placeholderList;
            this.placeholderSet = null;
            if (set == null || set.isEmpty()) {
                throw new IllegalArgumentException("placeholder must not be null nor empty");
            }
            this.setPlaceholderSet(set);
        }

        public void setStrategy(PlaceholderStrategy placeholderStrategy) {
            if (this.placeholderMap != null) {
                this.placeholderMap.setPlaceholderStrategy(placeholderStrategy);
            }
        }

        protected void setOwner(Entry entry) {
            if (this.this$0.bound && this.this$0.strategy != null && this.placeholderMap != null) {
                if (entry == null) {
                    this.placeholderMap.setPlaceholderStrategy(null);
                } else {
                    this.placeholderMap.setPlaceholderStrategy(this.this$0.strategy);
                }
            }
            this.owner = entry;
        }

        public boolean isPlaceholder() {
            return this.value == null;
        }

        public Set<Path> getPlaceholderSet() {
            return this.placeholderSet;
        }

        public void setPlaceholderSet(Set<Path> set) {
            if (set != null && set.contains(null)) {
                throw new IllegalArgumentException("placeholderSet contains a null value");
            }
            this.placeholderSet = set;
        }

        public void removeAll(Set<Path> set) {
            if (this.placeholderSet != null) {
                this.placeholderSet.removeAll(set);
                if (this.placeholderSet.isEmpty()) {
                    this.placeholderSet = null;
                }
            }
            if (this.placeholderMap != null) {
                this.placeholderMap.removeAll(set, true);
                if (this.placeholderMap.isEmpty()) {
                    this.setPlaceholderMap(null);
                }
            }
        }

        public void remove(Path path) {
            if (this.placeholderSet != null) {
                this.placeholderSet.remove(path);
                if (this.placeholderSet.isEmpty()) {
                    this.placeholderSet = null;
                }
            }
            if (this.placeholderMap != null) {
                this.placeholderMap.removeAll(path, true);
                if (this.placeholderMap.isEmpty()) {
                    this.setPlaceholderMap(null);
                }
            }
        }

        public void add(Path path) {
            if (path == null) {
                throw new IllegalArgumentException("placeholder must not be null");
            }
            if (this.placeholderSet == null) {
                this.placeholderSet = new HashSet<Path>();
            }
            this.placeholderSet.add(path);
        }

        public boolean hasPlaceholders() {
            return this.placeholderSet != null && !this.placeholderSet.isEmpty();
        }

        public boolean hasPlaceholder(Path path) {
            return this.placeholderSet != null && this.placeholderSet.contains(path);
        }

        public P getDockable() {
            return this.value;
        }

        public void setDockable(P p) {
            this.value = p;
            this.owner.refresh();
        }

        public void setPlaceholderMap(PlaceholderMap placeholderMap) {
            if (this.this$0.bound && this.this$0.strategy != null) {
                if (this.placeholderMap != null) {
                    this.placeholderMap.setPlaceholderStrategy(null);
                }
                this.placeholderMap = placeholderMap;
                if (this.placeholderMap != null) {
                    this.placeholderMap.setPlaceholderStrategy(this.this$0.strategy);
                }
            } else {
                this.placeholderMap = placeholderMap;
            }
        }

        public PlaceholderMap getPlaceholderMap() {
            return this.placeholderMap;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(dockable=");
            if (this.value != null) {
                stringBuilder.append(this.this$0.toString(this.value.asDockable()));
            }
            stringBuilder.append(", placeholders={");
            if (this.placeholderSet != null) {
                boolean bl = true;
                for (Path path : this.placeholderSet) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(path.toString());
                }
            }
            stringBuilder.append("})");
            return stringBuilder.toString();
        }
    }

    public static enum Level {
        BASE,
        DOCKABLE,
        PLACEHOLDER;

    }

    private abstract class SubList<A>
    implements Filter<A> {
        private Level level;
        private int size = -1;

        protected abstract A unwrap(Item var1);

        protected abstract Item wrap(A var1);

        protected abstract boolean visible(Item var1);

        public SubList(Level level) {
            this.level = level;
        }

        public PlaceholderList<D, S, P> getPlaceholderList() {
            return PlaceholderList.this;
        }

        public void invalidate() {
            this.size = -1;
        }

        private Entry getEntry(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("index < 0: " + n);
            }
            Entry entry = PlaceholderList.this.head(this.level);
            int n2 = n;
            while (n > 0) {
                entry = entry.next(this.level);
                --n;
                if (entry != null) continue;
                throw new IndexOutOfBoundsException("index=" + n2 + ", size=" + this.size());
            }
            return entry;
        }

        @Override
        public void add(A a) {
            this.add(this.size(), a);
        }

        @Override
        public void add(int n, A a) {
            this.insert(n, this.wrap(a));
        }

        @Override
        public void insertPlaceholder(int n, Path path) {
            if (path == null) {
                throw new IllegalArgumentException("placeholder must not be null");
            }
            HashSet<Path> hashSet = new HashSet<Path>();
            hashSet.add(path);
            this.insert(n, new Item(PlaceholderList.this, hashSet));
        }

        @Override
        public void addPlaceholder(int n, Path path) {
            Entry entry = PlaceholderList.this.search(n, this.level);
            if (entry == null) {
                throw new IndexOutOfBoundsException();
            }
            if (!entry.item.hasPlaceholder(path)) {
                PlaceholderList.this.removeAll(path);
                entry.item.add(path);
            }
        }

        private void insert(int n, Item item) {
            if (this.size() == n) {
                Entry entry = PlaceholderList.this.head;
                Entry entry2 = null;
                while (entry != null) {
                    entry2 = entry;
                    entry = entry.next;
                }
                new Entry(entry2, item);
            } else {
                Entry entry = this.getEntry(n);
                new Entry(entry.previous(this.level), item);
            }
        }

        @Override
        public PlaceholderMetaMap getMetaMap(int n) {
            return this.getEntry(n).item;
        }

        @Override
        public A get(int n) {
            return this.unwrap(this.getEntry(n).item);
        }

        @Override
        public int indexOf(A a) {
            int n = 0;
            Entry entry = PlaceholderList.this.head(this.level);
            while (entry != null) {
                if (this.unwrap(entry.item).equals(a)) {
                    return n;
                }
                entry = entry.next(this.level);
                ++n;
            }
            return -1;
        }

        @Override
        public int indexOfPlaceholder(Path path) {
            int n = 0;
            Entry entry = PlaceholderList.this.head(this.level);
            while (entry != null) {
                if (entry.item.hasPlaceholder(path)) {
                    return n;
                }
                entry = entry.next(this.level);
                ++n;
            }
            return -1;
        }

        @Override
        public A remove(int n) {
            Entry entry = this.getEntry(n);
            entry.remove();
            return this.unwrap(entry.item);
        }

        @Override
        public int remove(A a) {
            int n = 0;
            Entry entry = PlaceholderList.this.head(this.level);
            while (entry != null) {
                if (this.unwrap(entry.item).equals(a)) {
                    entry.remove();
                    return n;
                }
                entry = entry.next(this.level);
                ++n;
            }
            return -1;
        }

        @Override
        public A set(int n, A a) {
            Entry entry = this.getEntry(n);
            A a2 = this.unwrap(entry.item);
            entry.set(this.wrap(a));
            return a2;
        }

        @Override
        public int size() {
            if (this.size == -1) {
                this.size = 0;
                Entry entry = PlaceholderList.this.head(this.level);
                while (entry != null) {
                    ++this.size;
                    entry = entry.next(this.level);
                }
            }
            return this.size;
        }

        @Override
        public void move(int n, int n2) {
            Entry entry = PlaceholderList.this.search(n, this.level);
            if (entry == null) {
                throw new IllegalArgumentException("no entry for index: " + n);
            }
            int n3 = n2 - n;
            entry.move(n3, this.level);
        }

        @Override
        public void move(Filter<A> filter, int n, int n2) {
            if (filter == this) {
                this.move(n, n2);
                return;
            }
            if (!(filter instanceof SubList)) {
                throw new IllegalArgumentException("The type " + filter.getClass().getName() + " is not recognized");
            }
            SubList subList = (SubList)filter;
            if (subList.getPlaceholderList() == this.getPlaceholderList()) {
                n = PlaceholderList.this.levelToBase(n, subList.level);
                n2 = PlaceholderList.this.levelToBase(n2, this.level);
                subList.move(n, n2);
                return;
            }
            Entry entry = subList.getPlaceholderList().search(n, subList.level);
            if (entry == null) {
                throw new IllegalArgumentException("sourceIndex out of bounds: " + n);
            }
            if ((n2 = n2 == this.size() ? PlaceholderList.this.list().size() : PlaceholderList.this.levelToBase(n2, this.level)) < 0 || n2 > PlaceholderList.this.list().size()) {
                throw new IllegalArgumentException("destination out of bounds: " + n2);
            }
            PlaceholderMap placeholderMap = entry.item.placeholderMap;
            Set set = entry.item.placeholderSet;
            PlaceholderListItem placeholderListItem = entry.item.value;
            entry.remove();
            Item item = new Item(PlaceholderList.this, placeholderListItem, set, placeholderMap);
            PlaceholderList.this.list().add(n2, item);
            if (PlaceholderList.this.bound) {
                item.setStrategy(PlaceholderList.this.getStrategy());
                PlaceholderList.this.checkAllPlaceholders();
            }
        }

        @Override
        public Iterator<A> iterator() {
            return new Iterator<A>(){
                private Entry current = null;
                private Entry next;
                {
                    this.next = PlaceholderList.this.head(SubList.this.level);
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public A next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    this.current = this.next;
                    this.next = this.next.next(SubList.this.level);
                    return SubList.this.unwrap(this.current.item);
                }

                @Override
                public void remove() {
                    if (this.current == null) {
                        throw new IllegalStateException();
                    }
                    this.current.remove();
                    this.current = null;
                }
            };
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (A a : this) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(a);
            }
            return stringBuilder.toString();
        }
    }
}

