/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanMode;
import bibliothek.gui.dock.station.span.SpanUsage;
import bibliothek.gui.dock.themes.StationSpanFactoryValue;
import java.util.ArrayList;
import java.util.List;

public abstract class ListSpanStrategy {
    private List<Span> spans = new ArrayList<Span>();
    private Span teaser;
    private boolean horizontal = true;
    private DockStation station;
    private StationSpanFactoryValue factory;

    public ListSpanStrategy(String string, DockStation dockStation) {
        this.station = dockStation;
        this.factory = new StationSpanFactoryValue(string, dockStation){

            @Override
            protected void changed() {
                ListSpanStrategy.this.teaser = null;
                ListSpanStrategy.this.spans.clear();
                ListSpanStrategy.this.reset();
            }
        };
    }

    public void setController(DockController dockController) {
        this.factory.setController(dockController);
    }

    protected abstract boolean isHorizontal();

    protected abstract int getNumberOfDockables();

    protected abstract void spanResized();

    public void reset() {
        boolean bl = this.isHorizontal();
        if (bl != this.horizontal) {
            this.horizontal = bl;
            this.spans.clear();
            this.teaser = null;
        }
        if (this.teaser == null) {
            this.teaser = this.createSpan(!this.horizontal, SpanUsage.HIDING);
        }
        int n = this.getNumberOfDockables() + 1;
        int n2 = this.spans.size();
        while (n > n2) {
            this.spans.add(this.createSpan(this.horizontal, SpanUsage.INSERTING));
            ++n2;
        }
        while (n < n2) {
            this.spans.remove(--n2);
        }
        this.teaser.set(SpanMode.OFF);
        for (Span span : this.spans) {
            span.set(SpanMode.OFF);
        }
    }

    private Span createSpan(final boolean bl, final SpanUsage spanUsage) {
        return this.factory.create(new SpanCallback(){

            @Override
            public void resized() {
                ListSpanStrategy.this.spanResized();
            }

            @Override
            public boolean isVertical() {
                return !this.isHorizontal();
            }

            @Override
            public boolean isHorizontal() {
                return bl;
            }

            @Override
            public DockStation getStation() {
                return ListSpanStrategy.this.station;
            }

            @Override
            public SpanUsage getUsage() {
                return spanUsage;
            }
        });
    }

    public void tease(int n) {
        if (this.teaser != null) {
            this.teaser.mutate(SpanMode.TEASING);
        }
        int n2 = 0;
        int n3 = this.spans.size();
        while (n2 < n3) {
            if (n2 == n) {
                this.spans.get(n2).mutate(SpanMode.OPEN);
            } else {
                this.spans.get(n2).mutate(SpanMode.OFF);
            }
            ++n2;
        }
    }

    public void size(int n, int n2) {
        if (n >= 0 && n < this.spans.size()) {
            this.spans.get(n).configureSize(SpanMode.OPEN, n2);
        }
    }

    public void untease() {
        if (this.teaser != null) {
            this.teaser.mutate(SpanMode.OFF);
        }
        for (Span span : this.spans) {
            span.mutate(SpanMode.OFF);
        }
    }

    public int getTeasing() {
        if (this.teaser == null) {
            return 0;
        }
        return this.teaser.getSize();
    }

    public int getGap(int n) {
        if (n >= this.spans.size()) {
            return 0;
        }
        return this.spans.get(n).getSize();
    }
}

